/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.hosted;

import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.svm.jni.hosted.JNINativeCallWrapperMethod;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.ResolvedJavaMethod;

class JNINativeCallWrapperSubstitutionProcessor
extends SubstitutionProcessor {
    private final Map<ResolvedJavaMethod, JNINativeCallWrapperMethod> callWrappers = new ConcurrentHashMap<ResolvedJavaMethod, JNINativeCallWrapperMethod>();

    JNINativeCallWrapperSubstitutionProcessor() {
    }

    public ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
        assert (method.isNative()) : "Must have been registered as a native substitution processor";
        return this.callWrappers.computeIfAbsent(method, JNINativeCallWrapperMethod::new);
    }

    public ResolvedJavaMethod resolve(ResolvedJavaMethod method) {
        if (method instanceof JNINativeCallWrapperMethod) {
            return ((JNINativeCallWrapperMethod)method).getOriginal();
        }
        return method;
    }
}

