/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.stack;

import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.NonmovableObjectArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.ReusableTypeReader;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.stack.JavaStackWalk;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.ParameterizedStackFrameVisitor;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

public class ThreadStackPrinter {
    @NeverInline(value="debugger breakpoint")
    @Uninterruptible(reason="Called from uninterruptible code.")
    public static void printBacktrace() {
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static void printStacktrace(Pointer startSP, CodePointer startIP, Stage0StackFramePrintVisitor printVisitor, Log log) {
        JavaStackWalk walk = (JavaStackWalk)StackValue.get(JavaStackWalk.class);
        JavaStackWalker.initWalk(walk, startSP, startIP);
        JavaFrameAnchor anchor = walk.getAnchor();
        if (walk.getIPCodeInfo().isNull() && anchor.isNonNull()) {
            ThreadStackPrinter.logFrameAnchor(log, startSP, startIP);
            walk.setSP(anchor.getLastJavaSP());
            walk.setPossiblyStaleIP(anchor.getLastJavaIP());
            walk.setIPCodeInfo(CodeInfoTable.lookupCodeInfo(anchor.getLastJavaIP()));
        }
        JavaStackWalker.doWalk(walk, printVisitor, log);
    }

    @Uninterruptible(reason="CodeInfo in JavaStackWalk is currently null, so printing to log is safe right now.", calleeMustBe=false)
    private static void logFrameAnchor(Log log, Pointer startSP, CodePointer startIP) {
        Stage0StackFramePrintVisitor.logFrameRaw(log, startSP, startIP);
        log.string("  IP is not within Java code. Trying frame anchor of last Java frame instead.").newline();
    }

    public static class Stage1StackFramePrintVisitor
    extends Stage0StackFramePrintVisitor {
        public static Stage1StackFramePrintVisitor SINGLETON = new Stage1StackFramePrintVisitor();

        Stage1StackFramePrintVisitor() {
        }

        protected static void logFrameInfo(Log log, FrameInfoQueryResult frameInfo, String runtimeMethodInfoName) {
            log.string("  ");
            if (runtimeMethodInfoName != null) {
                log.string("[").string(runtimeMethodInfoName).string("] ");
            }
            frameInfo.log(log);
        }

        protected static void logVirtualFrames(Log log, Pointer sp, CodePointer ip, DeoptimizedFrame deoptFrame) {
            for (DeoptimizedFrame.VirtualFrame frame = deoptFrame.getTopFrame(); frame != null; frame = frame.getCaller()) {
                Stage1StackFramePrintVisitor.logFrameRaw(log, sp, ip);
                Stage1StackFramePrintVisitor.logFrameInfo(log, frame.getFrameInfo(), "image code, deopt");
                if (frame.getCaller() == null) continue;
                log.newline();
            }
        }

        @Override
        protected void logFrame(Log log, Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptFrame) {
            if (deoptFrame != null) {
                Stage1StackFramePrintVisitor.logVirtualFrames(log, sp, ip, deoptFrame);
            } else {
                Stage1StackFramePrintVisitor.logFrameRaw(log, sp, ip);
                log.spaces(2);
                CodeInfoAccess.log(codeInfo, log);
                log.string(" name = ").string(CodeInfoAccess.getName(codeInfo));
            }
        }
    }

    public static class Stage0StackFramePrintVisitor
    extends ParameterizedStackFrameVisitor<Log> {
        public static Stage0StackFramePrintVisitor SINGLETON = new Stage0StackFramePrintVisitor();

        Stage0StackFramePrintVisitor() {
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Provide allocation-free StackFrameVisitor")
        protected final boolean visitFrame(Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptFrame, Log log) {
            this.logFrame(log, sp, ip, codeInfo, deoptFrame);
            log.newline();
            return true;
        }

        @Override
        protected final boolean unknownFrame(Pointer sp, CodePointer ip, DeoptimizedFrame deoptimizedFrame, Log log) {
            Stage0StackFramePrintVisitor.logFrameRaw(log, sp, ip);
            if (DeoptimizationSupport.enabled()) {
                log.string("  deoptFrame=").object(deoptimizedFrame);
            }
            log.string("  IP is not within Java code. Aborting stack trace printing.").newline();
            return false;
        }

        protected void logFrame(Log log, Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptFrame) {
            Stage0StackFramePrintVisitor.logFrameRaw(log, sp, ip);
            log.string("  FrameSize ").signed(CodeInfoAccess.lookupTotalFrameSize(codeInfo, CodeInfoAccess.relativeIP(codeInfo, ip)));
        }

        protected static void logFrameRaw(Log log, Pointer sp, CodePointer ip) {
            log.string("SP ").zhex(sp.rawValue());
            log.string(" IP ").zhex(ip.rawValue());
        }
    }

    public static class StackFramePrintVisitor
    extends Stage1StackFramePrintVisitor {
        public static StackFramePrintVisitor SINGLETON = new StackFramePrintVisitor();
        private static ReusableTypeReader frameInfoReader = new ReusableTypeReader();
        private static SingleShotFrameInfoQueryResultAllocator SingleShotFrameInfoQueryResultAllocator = new SingleShotFrameInfoQueryResultAllocator();
        private static DummyValueInfoAllocator DummyValueInfoAllocator = new DummyValueInfoAllocator();

        StackFramePrintVisitor() {
        }

        @Override
        protected void logFrame(Log log, Pointer sp, CodePointer ip, CodeInfo codeInfo, DeoptimizedFrame deoptFrame) {
            if (deoptFrame != null) {
                StackFramePrintVisitor.logVirtualFrames(log, sp, ip, deoptFrame);
            } else {
                frameInfoReader.reset();
                long entryOffset = CodeInfoAccess.initFrameInfoReader(codeInfo, ip, frameInfoReader);
                if (entryOffset >= 0L) {
                    FrameInfoQueryResult validResult;
                    boolean isFirst = true;
                    SingleShotFrameInfoQueryResultAllocator.reload();
                    while ((validResult = CodeInfoAccess.nextFrameInfo(codeInfo, entryOffset, frameInfoReader, SingleShotFrameInfoQueryResultAllocator, DummyValueInfoAllocator, isFirst)) != null) {
                        SingleShotFrameInfoQueryResultAllocator.reload();
                        if (!isFirst) {
                            log.newline();
                        }
                        StackFramePrintVisitor.logFrameRaw(log, sp, ip);
                        StackFramePrintVisitor.logFrameInfo(log, validResult, CodeInfoAccess.getName(codeInfo));
                        isFirst = false;
                    }
                } else {
                    super.logFrame(log, sp, ip, codeInfo, deoptFrame);
                }
            }
        }

        private static class DummyValueInfoAllocator
        implements FrameInfoDecoder.ValueInfoAllocator {
            private DummyValueInfoAllocator() {
            }

            @Override
            @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Provide allocation-free StackFrameVisitor")
            public FrameInfoQueryResult.ValueInfo newValueInfo() {
                return null;
            }

            @Override
            @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Provide allocation-free StackFrameVisitor")
            public FrameInfoQueryResult.ValueInfo[] newValueInfoArray(int len) {
                return null;
            }

            @Override
            @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Provide allocation-free StackFrameVisitor")
            public FrameInfoQueryResult.ValueInfo[][] newValueInfoArrayArray(int len) {
                return null;
            }

            @Override
            @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Provide allocation-free StackFrameVisitor")
            public void decodeConstant(FrameInfoQueryResult.ValueInfo valueInfo, NonmovableObjectArray<?> frameInfoObjectConstants) {
            }
        }

        private static class SingleShotFrameInfoQueryResultAllocator
        implements FrameInfoDecoder.FrameInfoQueryResultAllocator {
            private static FrameInfoQueryResult frameInfoQueryResult = new FrameInfoQueryResult();
            private boolean fired;

            private SingleShotFrameInfoQueryResultAllocator() {
            }

            void reload() {
                this.fired = false;
            }

            @Override
            @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Provide allocation-free StackFrameVisitor")
            public FrameInfoQueryResult newFrameInfoQueryResult() {
                if (this.fired) {
                    return null;
                }
                this.fired = true;
                frameInfoQueryResult.init();
                return frameInfoQueryResult;
            }
        }
    }
}

