/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.posix.NativeSecureRandomFilesCloserShutdownHook;
import com.oracle.svm.core.posix.Target_sun_security_provider_NativePRNG;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
class NativeSecureRandomFilesCloser
implements Feature {
    NativeSecureRandomFilesCloser() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        access.registerReachabilityHandler(NativeSecureRandomFilesCloser::registerShutdownHook, new Object[]{Target_sun_security_provider_NativePRNG.class});
    }

    private static void registerShutdownHook(Feature.DuringAnalysisAccess access) {
        RuntimeSupport.getRuntimeSupport().addTearDownHook(new NativeSecureRandomFilesCloserShutdownHook());
    }
}

