/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.management;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.jdk.management.SubstrateOperatingSystemMXBeanBase;
import com.oracle.svm.core.util.VMError;
import com.sun.management.OperatingSystemMXBean;
import javax.management.ObjectName;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import sun.management.Util;

public abstract class SubstrateOperatingSystemMXBean
extends SubstrateOperatingSystemMXBeanBase
implements OperatingSystemMXBean {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected SubstrateOperatingSystemMXBean() {
    }

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName("java.lang:type=OperatingSystem");
    }

    @Override
    public String getName() {
        return System.getProperty("os.name");
    }

    @Override
    public String getArch() {
        return SubstrateUtil.getArchitectureName();
    }

    @Override
    public String getVersion() {
        return System.getProperty("os.version");
    }

    @Override
    public int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public long getTotalPhysicalMemorySize() {
        return PhysicalMemory.size().rawValue();
    }

    @Override
    public double getSystemLoadAverage() {
        return -1.0;
    }

    @Override
    public long getCommittedVirtualMemorySize() {
        throw VMError.unsupportedFeature("OperatingSystemMXBean methods");
    }

    @Override
    public long getTotalSwapSpaceSize() {
        throw VMError.unsupportedFeature("OperatingSystemMXBean methods");
    }

    @Override
    public long getFreeSwapSpaceSize() {
        throw VMError.unsupportedFeature("OperatingSystemMXBean methods");
    }

    @Override
    public long getProcessCpuTime() {
        throw VMError.unsupportedFeature("OperatingSystemMXBean methods");
    }

    @Override
    public long getFreePhysicalMemorySize() {
        throw VMError.unsupportedFeature("OperatingSystemMXBean methods");
    }

    @Override
    public double getSystemCpuLoad() {
        throw VMError.unsupportedFeature("OperatingSystemMXBean methods");
    }

    @Override
    public double getProcessCpuLoad() {
        throw VMError.unsupportedFeature("OperatingSystemMXBean methods");
    }
}

