/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.AccessControllerUtil;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;

@TargetClass(value=AccessController.class)
final class Target_java_security_AccessController {
    Target_java_security_AccessController() {
    }

    @Substitute
    private static <T> T doPrivileged(PrivilegedAction<T> action) throws Throwable {
        try {
            return action.run();
        }
        catch (Throwable ex) {
            throw AccessControllerUtil.wrapCheckedException(ex);
        }
    }

    @Substitute
    private static <T> T doPrivilegedWithCombiner(PrivilegedAction<T> action) throws Throwable {
        try {
            return action.run();
        }
        catch (Throwable ex) {
            throw AccessControllerUtil.wrapCheckedException(ex);
        }
    }

    @Substitute
    private static <T> T doPrivileged(PrivilegedAction<T> action, AccessControlContext context) throws Throwable {
        try {
            return action.run();
        }
        catch (Throwable ex) {
            throw AccessControllerUtil.wrapCheckedException(ex);
        }
    }

    @Substitute
    private static <T> T doPrivileged(PrivilegedAction<T> action, AccessControlContext context, Permission ... perms) throws Throwable {
        try {
            return action.run();
        }
        catch (Throwable ex) {
            throw AccessControllerUtil.wrapCheckedException(ex);
        }
    }

    @Substitute
    private static <T> T doPrivileged(PrivilegedExceptionAction<T> action) throws Throwable {
        try {
            return action.run();
        }
        catch (Throwable ex) {
            throw AccessControllerUtil.wrapCheckedException(ex);
        }
    }

    @Substitute
    private static <T> T doPrivilegedWithCombiner(PrivilegedExceptionAction<T> action) throws Throwable {
        try {
            return action.run();
        }
        catch (Throwable ex) {
            throw AccessControllerUtil.wrapCheckedException(ex);
        }
    }

    @Substitute
    private static <T> T doPrivilegedWithCombiner(PrivilegedExceptionAction<T> action, AccessControlContext context, Permission ... perms) throws Throwable {
        try {
            return action.run();
        }
        catch (Throwable ex) {
            throw AccessControllerUtil.wrapCheckedException(ex);
        }
    }

    @Substitute
    private static <T> T doPrivileged(PrivilegedExceptionAction<T> action, AccessControlContext context) throws Throwable {
        try {
            return action.run();
        }
        catch (Throwable ex) {
            throw AccessControllerUtil.wrapCheckedException(ex);
        }
    }

    @Substitute
    private static void checkPermission(Permission perm) throws AccessControlException {
    }

    @Substitute
    private static AccessControlContext getContext() {
        return AccessControllerUtil.NO_CONTEXT_SINGLETON;
    }

    @Substitute
    private static AccessControlContext createWrapper(DomainCombiner combiner, Class<?> caller, AccessControlContext parent, AccessControlContext context, Permission[] perms) {
        return AccessControllerUtil.NO_CONTEXT_SINGLETON;
    }
}

