/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_1)
final class StaticFieldBaseNode
extends FloatingNode
implements Lowerable {
    public static final NodeClass<StaticFieldBaseNode> TYPE = NodeClass.create(StaticFieldBaseNode.class);
    private final boolean primitive;

    protected StaticFieldBaseNode(boolean primitive) {
        super(TYPE, StampFactory.objectNonNull());
        this.primitive = primitive;
    }

    public void lower(LoweringTool tool) {
        if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
            return;
        }
        JavaConstant constant = SubstrateObjectConstant.forObject(this.primitive ? StaticFieldsSupport.getStaticPrimitiveFields() : StaticFieldsSupport.getStaticObjectFields());
        assert (constant.isNonNull());
        this.replaceAndDelete((Node)ConstantNode.forConstant((JavaConstant)constant, (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)this.graph()));
    }
}

