/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.hosted;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.phases.SubstrateIntrinsicGraphBuilder;
import com.oracle.svm.hosted.code.NonBytecodeStaticMethod;
import com.oracle.svm.reflect.hosted.CanBeStaticallyBoundNode;
import com.oracle.svm.reflect.hosted.ReflectionGraphKit;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecode;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;

public class ReflectiveInvokeMethod
extends NonBytecodeStaticMethod {
    private final Method method;

    public ReflectiveInvokeMethod(String name, ResolvedJavaMethod prototype, Method method) {
        super(name, prototype.getDeclaringClass(), prototype.getSignature(), prototype.getConstantPool());
        this.method = method;
    }

    public StructuredGraph buildGraph(DebugContext ctx, ResolvedJavaMethod m, HostedProviders providers, GraphProvider.Purpose purpose) {
        ConstantNode returnValue;
        ReflectionGraphKit graphKit = new ReflectionGraphKit(ctx, providers, m);
        ValueNode forceSpecialInvoke = graphKit.loadLocal(0, JavaKind.Int);
        ValueNode receiver = graphKit.loadLocal(1, JavaKind.Object);
        ValueNode argumentArray = graphKit.loadLocal(2, JavaKind.Object);
        graphKit.getFrameState().clearLocals();
        ResolvedJavaMethod targetMethod = providers.getMetaAccess().lookupJavaMethod((Executable)this.method);
        Class<?>[] argTypes = this.method.getParameterTypes();
        int receiverOffset = targetMethod.isStatic() ? 0 : 1;
        ValueNode[] args = new ValueNode[argTypes.length + receiverOffset];
        if (targetMethod.isStatic()) {
            graphKit.emitEnsureInitializedCall(targetMethod.getDeclaringClass());
        } else {
            ValueNode receiverNonNull = graphKit.maybeCreateExplicitNullCheck(receiver);
            args[0] = graphKit.startInstanceOf(receiverNonNull, targetMethod.getDeclaringClass(), true, true);
            graphKit.elsePart();
            graphKit.branchToIllegalArgumentException();
            graphKit.endIf();
        }
        graphKit.fillArgsArray(argumentArray, receiverOffset, args, argTypes);
        CallTargetNode.InvokeKind invokeKind = targetMethod.isStatic() ? CallTargetNode.InvokeKind.Static : (targetMethod.isInterface() ? CallTargetNode.InvokeKind.Interface : (targetMethod.canBeStaticallyBound() || targetMethod.isConstructor() ? CallTargetNode.InvokeKind.Special : CallTargetNode.InvokeKind.Virtual));
        ArrayList<InvokeWithExceptionNode> invokes = new ArrayList<InvokeWithExceptionNode>();
        if (invokeKind.isIndirect()) {
            LogicNode canBeStaticallyBoundCondition = (LogicNode)graphKit.getGraph().unique((Node)new CanBeStaticallyBoundNode(targetMethod));
            LogicNode forceSpecialInvokeCondition = (LogicNode)graphKit.append((ValueNode)IntegerEqualsNode.create((ValueNode)forceSpecialInvoke, (ValueNode)ConstantNode.forBoolean((boolean)true, (StructuredGraph)graphKit.getGraph()), (NodeView)NodeView.DEFAULT));
            LogicNode condition = LogicNode.or((LogicNode)canBeStaticallyBoundCondition, (LogicNode)forceSpecialInvokeCondition, (ProfileData.BranchProbabilityData)BranchProbabilityNode.NOT_LIKELY_PROFILE);
            graphKit.startIf(condition, BranchProbabilityNode.NOT_LIKELY_PROFILE);
            graphKit.thenPart();
            if (targetMethod.isAbstract()) {
                graphKit.branchToIllegalArgumentException();
            } else {
                InvokeWithExceptionNode specialInvoke = graphKit.createJavaCallWithException(CallTargetNode.InvokeKind.Special, targetMethod, args);
                invokes.add(specialInvoke);
                graphKit.exceptionPart();
                graphKit.branchToInvocationTargetException(graphKit.exceptionObject());
                graphKit.endInvokeWithException();
            }
            graphKit.elsePart();
        }
        InvokeWithExceptionNode regularInvoke = graphKit.createJavaCallWithException(invokeKind, targetMethod, args);
        invokes.add(regularInvoke);
        graphKit.exceptionPart();
        graphKit.branchToInvocationTargetException(graphKit.exceptionObject());
        graphKit.endInvokeWithException();
        AbstractMergeNode merge = invokeKind.isIndirect() ? graphKit.endIf() : null;
        JavaKind returnKind = targetMethod.getSignature().getReturnKind();
        if (returnKind == JavaKind.Void) {
            returnValue = graphKit.createObject(null);
        } else {
            returnValue = graphKit.createPhi(invokes, merge);
            if (returnKind.isPrimitive()) {
                ResolvedJavaType boxedRetType = graphKit.getMetaAccess().lookupJavaType(returnKind.toBoxedJavaClass());
                returnValue = graphKit.createBoxing((ValueNode)returnValue, returnKind, boxedRetType);
            }
        }
        graphKit.createReturn((ValueNode)returnValue, JavaKind.Object);
        graphKit.emitIllegalArgumentException(this.method, receiver, argumentArray);
        graphKit.emitInvocationTargetException();
        for (InvokeWithExceptionNode invoke : invokes) {
            InvocationPlugin invocationPlugin;
            if (!invoke.getInvokeKind().isDirect() || (invocationPlugin = providers.getGraphBuilderPlugins().getInvocationPlugins().lookupInvocation(targetMethod)) == null || invocationPlugin.inlineOnly()) continue;
            ResolvedJavaMethodBytecode code = new ResolvedJavaMethodBytecode(targetMethod);
            StructuredGraph intrinsicGraph = new SubstrateIntrinsicGraphBuilder(graphKit.getOptions(), graphKit.getDebug(), (CoreProviders)providers, (Bytecode)code).buildGraph(invocationPlugin);
            if (intrinsicGraph == null) continue;
            InliningUtil.inline((Invoke)invoke, (StructuredGraph)intrinsicGraph, (boolean)false, (ResolvedJavaMethod)targetMethod);
        }
        return graphKit.finalizeGraph();
    }
}

