/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.phases.EnumSwitchPlugin;
import com.oracle.svm.hosted.phases.EnumSwitchPluginRegistry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
final class EnumSwitchFeature
implements GraalFeature {
    BigBang bb;
    final ConcurrentMap<AnalysisMethod, Boolean> methodsSafeForExecution = new ConcurrentHashMap<AnalysisMethod, Boolean>();

    EnumSwitchFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        ImageSingletons.add(EnumSwitchPluginRegistry.class, (Object)new EnumSwitchPluginRegistry());
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        this.bb = access.getBigBang();
        access.getHostVM().addMethodAfterParsingHook(this::onMethodParsed);
    }

    private void onMethodParsed(AnalysisMethod method, StructuredGraph graph) {
        boolean methodSafeForExecution = graph.getNodes().filter(node -> node instanceof EnsureClassInitializedNode).isEmpty();
        Boolean existingValue = this.methodsSafeForExecution.put(method, methodSafeForExecution);
        assert (existingValue == null) : "Method parsed twice: " + method.format("%H.%n(%p)");
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.bb = null;
    }

    @Override
    public void registerGraphBuilderPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        plugins.appendNodePlugin((NodePlugin)new EnumSwitchPlugin(providers.getSnippetReflection(), reason));
    }
}

