/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.diagnostic;

import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.diagnostic.HostedHeapDump;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class HostedHeapDumpFeature
implements Feature {
    private List<String> phases;
    private Path dumpLocation;
    private String imageName;
    private String timeStamp;

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        if (Options.DumpHeap.getValue() != null) {
            List validPhases = Stream.of(Phases.values()).map(Phases::getName).collect(Collectors.toList());
            List<String> values = OptionUtils.flatten(",", Options.DumpHeap.getValue());
            this.phases = new ArrayList<String>();
            for (String value : values) {
                if (validPhases.contains(value)) {
                    this.phases.add(value);
                    continue;
                }
                throw UserError.abort("Invalid value %s given for %s. Valid values are: %s.", value, SubstrateOptionsParser.commandArgument(Options.DumpHeap, ""), String.join((CharSequence)", ", validPhases));
            }
            return !this.phases.isEmpty();
        }
        return false;
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        FeatureImpl.DuringSetupAccessImpl config = (FeatureImpl.DuringSetupAccessImpl)access;
        this.dumpLocation = HostedHeapDumpFeature.getDumpLocation();
        this.imageName = ReportUtils.extractImageName((String)config.getHostVM().getImageName());
        this.timeStamp = HostedHeapDumpFeature.getTimeStamp();
    }

    public void onAnalysisExit(Feature.OnAnalysisExitAccess access) {
        if (this.phases.contains(Phases.AfterAnalysis.getName())) {
            this.dumpHeap(Phases.AfterAnalysis.getName());
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (this.phases.contains(Phases.BeforeCompilation.getName())) {
            this.dumpHeap(Phases.BeforeCompilation.getName());
        }
    }

    private void dumpHeap(String reason) {
        String outputFile = this.dumpLocation.resolve(this.imageName + '-' + reason + '-' + this.timeStamp + ".hprof").toString();
        System.out.println("Dumping heap " + reason.replace("-", " ") + " to " + outputFile);
        HostedHeapDump.take(outputFile);
    }

    private static Path getDumpLocation() {
        try {
            Path folder = Paths.get(Paths.get(SubstrateOptions.Path.getValue(), new String[0]).toString(), "dumps").toAbsolutePath();
            return Files.createDirectories(folder, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new Error("Cannot create heap dumps directory.", e);
        }
    }

    private static String getTimeStamp() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss");
        return LocalDateTime.now().format(formatter);
    }

    static enum Phases {
        AfterAnalysis("after-analysis"),
        BeforeCompilation("before-compilation");

        final String name;

        private Phases(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    static class Options {
        @Option(help={"Dump the heap at a specific time during image building.The option accepts a list of comma separated phases, any of: after-analysis, before-compilation."})
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> DumpHeap = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());

        Options() {
        }
    }
}

