/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.configure.ConditionalElement;
import com.oracle.svm.core.configure.ReflectionConfigurationParserDelegate;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.util.ClassUtil;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.ReflectionRegistry;

public class ReflectionRegistryAdapter
implements ReflectionConfigurationParserDelegate<ConditionalElement<Class<?>>> {
    private final ReflectionRegistry registry;
    private final ImageClassLoader classLoader;

    public ReflectionRegistryAdapter(ReflectionRegistry registry, ImageClassLoader classLoader) {
        this.registry = registry;
        this.classLoader = classLoader;
    }

    @Override
    public void registerType(ConditionalElement<Class<?>> type) {
        this.registry.register(type.getCondition(), new Class[]{type.getElement()});
    }

    @Override
    public TypeResult<ConfigurationCondition> resolveCondition(String typeName) {
        String canonicalizedName = ReflectionRegistryAdapter.canonicalizeTypeName(typeName);
        TypeResult<Class<?>> clazz = this.classLoader.findClass(canonicalizedName);
        return clazz.map(Class::getTypeName).map(ConfigurationCondition::create);
    }

    @Override
    public TypeResult<ConditionalElement<Class<?>>> resolveType(ConfigurationCondition condition, String typeName) {
        String name = ReflectionRegistryAdapter.canonicalizeTypeName(typeName);
        TypeResult<Class<?>> clazz = this.classLoader.findClass(name);
        return clazz.map(c -> new ConditionalElement<Class>(condition, (Class)c));
    }

    private static String canonicalizeTypeName(String typeName) {
        String name = typeName;
        if (name.indexOf(91) != -1) {
            name = MetaUtil.internalNameToJava((String)MetaUtil.toInternalName((String)name), (boolean)true, (boolean)true);
        }
        return name;
    }

    @Override
    public void registerPublicClasses(ConditionalElement<Class<?>> type) {
        this.registry.register(type.getCondition(), (Class[])type.getElement().getClasses());
    }

    @Override
    public void registerDeclaredClasses(ConditionalElement<Class<?>> type) {
        this.registry.register(type.getCondition(), (Class[])type.getElement().getDeclaredClasses());
    }

    @Override
    public void registerPublicFields(ConditionalElement<Class<?>> type) {
        this.registry.register(type.getCondition(), false, type.getElement().getFields());
    }

    @Override
    public void registerDeclaredFields(ConditionalElement<Class<?>> type) {
        this.registry.register(type.getCondition(), false, type.getElement().getDeclaredFields());
    }

    @Override
    public void registerPublicMethods(boolean queriedOnly, ConditionalElement<Class<?>> type) {
        this.registry.register(type.getCondition(), queriedOnly, (Executable[])type.getElement().getMethods());
    }

    @Override
    public void registerDeclaredMethods(boolean queriedOnly, ConditionalElement<Class<?>> type) {
        this.registry.register(type.getCondition(), queriedOnly, (Executable[])type.getElement().getDeclaredMethods());
    }

    @Override
    public void registerPublicConstructors(boolean queriedOnly, ConditionalElement<Class<?>> type) {
        this.registry.register(type.getCondition(), queriedOnly, (Executable[])type.getElement().getConstructors());
    }

    @Override
    public void registerDeclaredConstructors(boolean queriedOnly, ConditionalElement<Class<?>> type) {
        this.registry.register(type.getCondition(), queriedOnly, (Executable[])type.getElement().getDeclaredConstructors());
    }

    @Override
    public void registerField(ConditionalElement<Class<?>> type, String fieldName, boolean allowWrite) throws NoSuchFieldException {
        this.registry.register(type.getCondition(), allowWrite, new Field[]{type.getElement().getDeclaredField(fieldName)});
    }

    @Override
    public boolean registerAllMethodsWithName(boolean queriedOnly, ConditionalElement<Class<?>> type, String methodName) {
        Method[] methods;
        boolean found = false;
        for (Method method : methods = type.getElement().getDeclaredMethods()) {
            if (!((Executable)method).getName().equals(methodName)) continue;
            this.registerExecutable(type.getCondition(), queriedOnly, method);
            found = true;
        }
        return found;
    }

    @Override
    public boolean registerAllConstructors(boolean queriedOnly, ConditionalElement<Class<?>> type) {
        Executable[] methods = type.getElement().getDeclaredConstructors();
        this.registerExecutable(type.getCondition(), queriedOnly, methods);
        return methods.length > 0;
    }

    @Override
    public void registerMethod(boolean queriedOnly, ConditionalElement<Class<?>> type, String methodName, List<ConditionalElement<Class<?>>> methodParameterTypes) throws NoSuchMethodException {
        Method method;
        Class<?>[] parameterTypesArray = ReflectionRegistryAdapter.getParameterTypes(methodParameterTypes);
        try {
            method = type.getElement().getDeclaredMethod(methodName, parameterTypesArray);
        }
        catch (NoClassDefFoundError e) {
            try {
                method = type.getElement().getMethod(methodName, parameterTypesArray);
            }
            catch (Throwable ignored) {
                throw e;
            }
        }
        this.registerExecutable(type.getCondition(), queriedOnly, method);
    }

    @Override
    public void registerConstructor(boolean queriedOnly, ConditionalElement<Class<?>> type, List<ConditionalElement<Class<?>>> methodParameterTypes) throws NoSuchMethodException {
        Class<?>[] parameterTypesArray = ReflectionRegistryAdapter.getParameterTypes(methodParameterTypes);
        this.registerExecutable(type.getCondition(), queriedOnly, type.getElement().getDeclaredConstructor(parameterTypesArray));
    }

    private static Class<?>[] getParameterTypes(List<ConditionalElement<Class<?>>> methodParameterTypes) {
        return (Class[])methodParameterTypes.stream().map(ConditionalElement::getElement).toArray(Class[]::new);
    }

    private void registerExecutable(ConfigurationCondition condition, boolean queriedOnly, Executable ... executable) {
        this.registry.register(condition, queriedOnly, executable);
    }

    @Override
    public String getTypeName(ConditionalElement<Class<?>> type) {
        return type.getElement().getTypeName();
    }

    @Override
    public String getSimpleName(ConditionalElement<Class<?>> type) {
        return ClassUtil.getUnqualifiedName(type.getElement());
    }
}

