/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hosted;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.graal.nodes.SubstrateFieldLocationIdentity;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.ReadableJavaField;
import com.oracle.svm.core.util.HostedStringDeduplication;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.SubstrateGraalRuntime;
import com.oracle.svm.graal.hosted.GraalProviderObjectReplacements;
import com.oracle.svm.graal.meta.SubstrateField;
import com.oracle.svm.graal.meta.SubstrateMethod;
import com.oracle.svm.graal.meta.SubstrateSignature;
import com.oracle.svm.graal.meta.SubstrateType;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.ameta.AnalysisConstantFieldProvider;
import com.oracle.svm.hosted.ameta.AnalysisConstantReflectionProvider;
import com.oracle.svm.hosted.analysis.NativeImagePointsToAnalysis;
import com.oracle.svm.hosted.meta.HostedConstantFieldProvider;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import jdk.vm.ci.hotspot.HotSpotSignature;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.api.runtime.GraalRuntime;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.debug.MetricKey;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackendFactory;
import org.graalvm.compiler.hotspot.SnippetResolvedJavaMethod;
import org.graalvm.compiler.hotspot.SnippetResolvedJavaType;
import org.graalvm.compiler.nodes.FieldLocationIdentity;
import org.graalvm.nativeimage.c.function.RelocatedPointer;
import org.graalvm.nativeimage.hosted.Feature;

public class GraalObjectReplacer
implements Function<Object, Object> {
    private final AnalysisUniverse aUniverse;
    private final AnalysisMetaAccess aMetaAccess;
    private final HashMap<AnalysisMethod, SubstrateMethod> methods = new HashMap();
    private final HashMap<AnalysisField, SubstrateField> fields = new HashMap();
    private final HashMap<FieldLocationIdentity, SubstrateFieldLocationIdentity> fieldLocationIdentities = new HashMap();
    private final HashMap<AnalysisType, SubstrateType> types = new HashMap();
    private final HashMap<Signature, SubstrateSignature> signatures = new HashMap();
    private final GraalProviderObjectReplacements providerReplacements;
    private SubstrateGraalRuntime sGraalRuntime;
    private final HostedStringDeduplication stringTable;

    public GraalObjectReplacer(AnalysisUniverse aUniverse, AnalysisMetaAccess aMetaAccess, GraalProviderObjectReplacements providerReplacements) {
        this.aUniverse = aUniverse;
        this.aMetaAccess = aMetaAccess;
        this.providerReplacements = providerReplacements;
        this.stringTable = HostedStringDeduplication.singleton();
    }

    public void setGraalRuntime(SubstrateGraalRuntime sGraalRuntime) {
        assert (this.sGraalRuntime == null);
        this.sGraalRuntime = sGraalRuntime;
    }

    @Override
    public Object apply(Object source) {
        if (source == null) {
            return null;
        }
        Object dest = source;
        if (source instanceof RelocatedPointer) {
            return dest;
        }
        if (source instanceof SnippetResolvedJavaMethod || source instanceof SnippetResolvedJavaType) {
            return source;
        }
        if (source instanceof MetaAccessProvider) {
            dest = this.providerReplacements.getMetaAccessProvider();
        } else {
            if (source instanceof HotSpotJVMCIRuntime) {
                throw new UnsupportedFeatureException("HotSpotJVMCIRuntime should not appear in the image: " + source);
            }
            if (source instanceof GraalHotSpotVMConfig) {
                throw new UnsupportedFeatureException("GraalHotSpotVMConfig should not appear in the image: " + source);
            }
            if (source instanceof HotSpotBackendFactory) {
                HotSpotBackendFactory factory = (HotSpotBackendFactory)source;
                Architecture hostArch = HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getTarget().arch;
                if (!factory.getArchitecture().equals(hostArch.getClass())) {
                    throw new UnsupportedFeatureException("Non-host archtecture HotSpotBackendFactory should not appear in the image: " + source);
                }
            } else if (source instanceof GraalRuntime) {
                dest = this.sGraalRuntime;
            } else if (source instanceof AnalysisConstantReflectionProvider) {
                dest = this.providerReplacements.getConstantReflectionProvider();
            } else if (source instanceof AnalysisConstantFieldProvider) {
                dest = this.providerReplacements.getConstantFieldProvider();
            } else if (source instanceof ForeignCallsProvider) {
                dest = this.providerReplacements.getForeignCallsProvider();
            } else if (source instanceof SnippetReflectionProvider) {
                dest = this.providerReplacements.getSnippetReflectionProvider();
            } else if (source instanceof MetricKey) {
                ((MetricKey)source).getName();
            } else {
                if (source instanceof HotSpotResolvedJavaMethod) {
                    throw new UnsupportedFeatureException(source.toString());
                }
                if (source instanceof HotSpotResolvedJavaField) {
                    throw new UnsupportedFeatureException(source.toString());
                }
                if (source instanceof HotSpotResolvedJavaType) {
                    throw new UnsupportedFeatureException(source.toString());
                }
                if (source instanceof HotSpotSignature) {
                    throw new UnsupportedFeatureException(source.toString());
                }
                if (source instanceof HotSpotObjectConstant) {
                    throw new UnsupportedFeatureException(source.toString());
                }
                if (source instanceof ResolvedJavaMethod && !(source instanceof SubstrateMethod)) {
                    dest = this.createMethod((ResolvedJavaMethod)source);
                } else if (source instanceof ResolvedJavaField && !(source instanceof SubstrateField)) {
                    dest = this.createField((ResolvedJavaField)source);
                } else if (source instanceof ResolvedJavaType && !(source instanceof SubstrateType)) {
                    dest = this.createType((JavaType)((ResolvedJavaType)source));
                } else if (source instanceof FieldLocationIdentity && !(source instanceof SubstrateFieldLocationIdentity)) {
                    dest = this.createFieldLocationIdentity((FieldLocationIdentity)source);
                }
            }
        }
        assert (dest != null);
        String className = dest.getClass().getName();
        assert (SubstrateUtil.isBuildingLibgraal() || !className.contains(".hotspot.") || className.contains(".svm.jtt.hotspot.")) : "HotSpot object in image " + className;
        assert (!className.contains(".analysis.meta.")) : "Analysis meta object in image " + className;
        assert (!className.contains(".hosted.meta.")) : "Hosted meta object in image " + className;
        assert (!SubstrateUtil.isBuildingLibgraal() || !className.contains(".svm.hosted.snippets.")) : "Hosted snippet object in image " + className;
        return dest;
    }

    public synchronized SubstrateMethod createMethod(ResolvedJavaMethod original) {
        assert (!(original instanceof SubstrateMethod)) : original;
        AnalysisMethod aMethod = original instanceof AnalysisMethod ? (AnalysisMethod)original : (original instanceof HostedMethod ? ((HostedMethod)original).wrapped : this.aUniverse.lookup((JavaMethod)original));
        SubstrateMethod sMethod = this.methods.get(aMethod);
        if (sMethod == null) {
            assert (!(original instanceof HostedMethod)) : "too late to create new method";
            sMethod = new SubstrateMethod((ResolvedJavaMethod)aMethod, this.stringTable);
            this.methods.put(aMethod, sMethod);
            sMethod.setLinks(this.createSignature((Signature)aMethod.getSignature()), this.createType((JavaType)aMethod.getDeclaringClass()));
            sMethod.setAnnotationsEncoding(NativeImagePointsToAnalysis.encodeAnnotations(this.aMetaAccess, aMethod.getAnnotations(), aMethod.getDeclaredAnnotations(), null));
        }
        return sMethod;
    }

    public synchronized SubstrateField createField(ResolvedJavaField original) {
        AnalysisField aField;
        assert (!(original instanceof SubstrateField)) : original;
        if (original instanceof AnalysisField) {
            aField = (AnalysisField)original;
        } else if (original instanceof HostedField) {
            aField = ((HostedField)original).wrapped;
        } else {
            throw new InternalError(original.toString());
        }
        SubstrateField sField = this.fields.get(aField);
        if (sField == null) {
            assert (!(original instanceof HostedField)) : "too late to create new field";
            int modifiers = aField.getModifiers();
            if (ReadableJavaField.injectFinalForRuntimeCompilation(aField.wrapped)) {
                modifiers |= 0x10;
            }
            sField = new SubstrateField((MetaAccessProvider)this.aMetaAccess, (ResolvedJavaField)aField, modifiers, this.stringTable);
            this.fields.put(aField, sField);
            sField.setLinks(this.createType((JavaType)aField.getType()), this.createType((JavaType)aField.getDeclaringClass()));
            sField.setAnnotationsEncoding(NativeImagePointsToAnalysis.encodeAnnotations(this.aMetaAccess, aField.getAnnotations(), aField.getDeclaredAnnotations(), null));
        }
        return sField;
    }

    private synchronized SubstrateFieldLocationIdentity createFieldLocationIdentity(FieldLocationIdentity original) {
        assert (!(original instanceof SubstrateFieldLocationIdentity)) : original;
        SubstrateFieldLocationIdentity dest = this.fieldLocationIdentities.get(original);
        if (dest == null) {
            SubstrateField destField = this.createField(original.getField());
            dest = new SubstrateFieldLocationIdentity(destField);
            this.fieldLocationIdentities.put(original, dest);
        }
        return dest;
    }

    public SubstrateField getField(AnalysisField field) {
        return this.fields.get(field);
    }

    public boolean removeField(AnalysisField field) {
        return this.fields.remove(field) != null;
    }

    public boolean typeCreated(JavaType original) {
        return this.types.containsKey(GraalObjectReplacer.toAnalysisType(original));
    }

    public synchronized SubstrateType createType(JavaType original) {
        assert (!(original instanceof SubstrateType)) : original;
        if (original == null) {
            return null;
        }
        AnalysisType aType = GraalObjectReplacer.toAnalysisType(original);
        VMError.guarantee(aType.isLinked(), "types reachable for JIT compilation must not have linkage errors");
        SubstrateType sType = this.types.get(aType);
        if (sType == null) {
            assert (!(original instanceof HostedType)) : "too late to create new type";
            aType.registerAsReachable();
            DynamicHub hub = ((SVMHost)this.aUniverse.hostVM()).dynamicHub((ResolvedJavaType)aType);
            sType = new SubstrateType(aType.getJavaKind(), hub);
            this.types.put(aType, sType);
            hub.setMetaType(sType);
            sType.setRawAllInstanceFields(this.createAllInstanceFields((ResolvedJavaType)aType));
            this.createType((JavaType)aType.getSuperclass());
            this.createType((JavaType)aType.getComponentType());
            for (AnalysisType aInterface : aType.getInterfaces()) {
                this.createType((JavaType)aInterface);
            }
        }
        return sType;
    }

    private static AnalysisType toAnalysisType(JavaType original) {
        if (original instanceof HostedType) {
            return ((HostedType)original).getWrapped();
        }
        if (original instanceof AnalysisType) {
            return (AnalysisType)original;
        }
        throw new InternalError("unexpected type " + original);
    }

    private SubstrateField[] createAllInstanceFields(ResolvedJavaType originalType) {
        ResolvedJavaField[] originalFields = originalType.getInstanceFields(true);
        SubstrateField[] sFields = new SubstrateField[originalFields.length];
        for (int idx = 0; idx < originalFields.length; ++idx) {
            sFields[idx] = this.createField(originalFields[idx]);
        }
        return sFields;
    }

    private synchronized SubstrateSignature createSignature(Signature original) {
        assert (!(original instanceof SubstrateSignature)) : original;
        SubstrateSignature sSignature = this.signatures.get(original);
        if (sSignature == null) {
            sSignature = new SubstrateSignature();
            this.signatures.put(original, sSignature);
            SubstrateType[] parameterTypes = new SubstrateType[original.getParameterCount(false)];
            for (int index = 0; index < original.getParameterCount(false); ++index) {
                parameterTypes[index] = this.createType(original.getParameterType(index, null));
            }
            sSignature.setTypes(parameterTypes, this.createType(original.getReturnType(null)));
        }
        return sSignature;
    }

    public boolean updateDataDuringAnalysis(AnalysisMetaAccess metaAccess) {
        boolean result = false;
        ArrayList<AnalysisMethod> aMethods = new ArrayList<AnalysisMethod>();
        aMethods.addAll(this.methods.keySet());
        int index = 0;
        while (index < aMethods.size()) {
            AnalysisMethod aMethod = (AnalysisMethod)aMethods.get(index++);
            SubstrateMethod substrateMethod = this.methods.get(aMethod);
            SubstrateMethod[] implementations = new SubstrateMethod[aMethod.getImplementations().length];
            int idx = 0;
            for (AnalysisMethod impl : aMethod.getImplementations()) {
                SubstrateMethod sImpl = this.methods.get(impl);
                if (sImpl == null) {
                    sImpl = this.createMethod((ResolvedJavaMethod)impl);
                    aMethods.add(impl);
                    result = true;
                }
                implementations[idx++] = sImpl;
            }
            if (!substrateMethod.setImplementations(implementations)) continue;
            result = true;
        }
        for (Map.Entry<AnalysisMethod, SubstrateMethod> entry : this.methods.entrySet()) {
            if (!entry.getValue().setAnnotationsEncoding(NativeImagePointsToAnalysis.encodeAnnotations(metaAccess, entry.getKey().getAnnotations(), entry.getKey().getDeclaredAnnotations(), entry.getValue().getAnnotationsEncoding()))) continue;
            result = true;
        }
        for (Map.Entry<Object, Object> entry : this.fields.entrySet()) {
            if (!((SubstrateField)entry.getValue()).setAnnotationsEncoding(NativeImagePointsToAnalysis.encodeAnnotations(metaAccess, ((AnalysisField)entry.getKey()).getAnnotations(), ((AnalysisField)entry.getKey()).getDeclaredAnnotations(), ((SubstrateField)entry.getValue()).getAnnotationsEncoding()))) continue;
            result = true;
        }
        return result;
    }

    public void updateSubstrateDataAfterCompilation(HostedUniverse hUniverse, ConstantFieldProvider constantFieldProvider) {
        for (Map.Entry<AnalysisType, SubstrateType> entry : this.types.entrySet()) {
            AnalysisType aType = entry.getKey();
            SubstrateType sType = entry.getValue();
            if (!hUniverse.contains((JavaType)aType)) continue;
            HostedType hType = hUniverse.lookup((JavaType)aType);
            if (hType.getUniqueConcreteImplementation() != null) {
                sType.setTypeCheckData(hType.getUniqueConcreteImplementation().getHub());
            }
            if (sType.getInstanceFieldCount() <= 1) continue;
            sType.setRawAllInstanceFields(this.createAllInstanceFields(hType));
        }
        for (Map.Entry<Object, Object> entry : this.fields.entrySet()) {
            AnalysisField aField = (AnalysisField)entry.getKey();
            SubstrateField sField = (SubstrateField)entry.getValue();
            HostedField hField = hUniverse.lookup((JavaField)aField);
            JavaConstant constantValue = hField.isStatic() && ((HostedConstantFieldProvider)constantFieldProvider).isFinalField(hField, null) ? hField.readValue(null) : null;
            sField.setSubstrateData(hField.getLocation(), hField.isAccessed(), hField.isWritten(), constantValue);
        }
    }

    public void updateSubstrateDataAfterHeapLayout(HostedUniverse hUniverse) {
        for (Map.Entry<AnalysisMethod, SubstrateMethod> entry : this.methods.entrySet()) {
            AnalysisMethod aMethod = entry.getKey();
            SubstrateMethod sMethod = entry.getValue();
            HostedMethod hMethod = hUniverse.lookup((JavaMethod)aMethod);
            int vTableIndex = hMethod.hasVTableIndex() ? hMethod.getVTableIndex() : -1;
            sMethod.setSubstrateData(vTableIndex, hMethod.isCodeAddressOffsetValid() ? hMethod.getCodeAddressOffset() : 0, hMethod.getDeoptOffsetInImage());
        }
    }

    public void registerImmutableObjects(Feature.CompilationAccess access) {
        for (SubstrateMethod substrateMethod : this.methods.values()) {
            access.registerAsImmutable((Object)substrateMethod);
            access.registerAsImmutable(substrateMethod.getRawImplementations());
            access.registerAsImmutable((Object)substrateMethod.getEncodedLineNumberTable());
        }
        for (SubstrateField substrateField : this.fields.values()) {
            access.registerAsImmutable((Object)substrateField);
        }
        for (FieldLocationIdentity fieldLocationIdentity : this.fieldLocationIdentities.values()) {
            access.registerAsImmutable((Object)fieldLocationIdentity);
        }
        for (SubstrateType substrateType : this.types.values()) {
            access.registerAsImmutable((Object)substrateType);
            access.registerAsImmutable((Object)substrateType.getRawAllInstanceFields());
        }
        for (SubstrateSignature substrateSignature : this.signatures.values()) {
            access.registerAsImmutable((Object)substrateSignature);
            access.registerAsImmutable(substrateSignature.getRawParameterTypes());
        }
    }
}

