/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hosted;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.GraalConfiguration;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateReplacements;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.GraalSupport;
import com.oracle.svm.graal.SubstrateGraalRuntime;
import com.oracle.svm.graal.hosted.DeoptimizationFeature;
import com.oracle.svm.graal.hosted.FieldsOffsetsFeature;
import com.oracle.svm.graal.hosted.GraalObjectReplacer;
import com.oracle.svm.graal.hosted.GraalProviderObjectReplacements;
import com.oracle.svm.graal.hosted.GraphPrepareMetaAccessExtensionProvider;
import com.oracle.svm.graal.hosted.RuntimeGraalSetup;
import com.oracle.svm.graal.hosted.RuntimeStrengthenStampsPhase;
import com.oracle.svm.graal.hosted.SubstrateRuntimeGraalSetup;
import com.oracle.svm.graal.meta.SubstrateMethod;
import com.oracle.svm.graal.meta.SubstrateType;
import com.oracle.svm.hosted.FeatureHandler;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.c.GraalAccess;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.code.CompilationInfoSupport;
import com.oracle.svm.hosted.code.SharedRuntimeConfigurationBuilder;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.phases.SubstrateClassInitializationPlugin;
import com.oracle.svm.hosted.phases.SubstrateGraphBuilderPhase;
import com.oracle.truffle.api.CompilerDirectives;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.runtime.GraalRuntime;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;
import org.graalvm.compiler.core.gen.NodeMatchRules;
import org.graalvm.compiler.core.match.MatchStatement;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.loop.phases.ConvertDeoptimizeToGuardPhase;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.GraphEncoder;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.IterativeConditionalEliminationPhase;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.truffle.compiler.phases.DeoptimizeOnExceptionPhase;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public final class GraalFeature
implements Feature {
    private GraalObjectReplacer objectReplacer;
    private HostedProviders hostedProviders;
    private GraphEncoder graphEncoder;
    private SharedRuntimeConfigurationBuilder runtimeConfigBuilder;
    private boolean initialized;
    private GraphBuilderConfiguration graphBuilderConfig;
    private OptimisticOptimizations optimisticOpts;
    private IncludeCalleePredicate includeCalleePredicate;
    private Predicate<ResolvedJavaMethod> deoptimizeOnExceptionPredicate;
    private Map<AnalysisMethod, CallTreeNode> methods;

    public StructuredGraph lookupMethodGraph(AnalysisMethod method) {
        CallTreeNode callTree = this.methods.get(method);
        assert (callTree != null) : "Unable to find method.";
        StructuredGraph graph = callTree.getGraph();
        assert (graph != null) : "Method's graph is null.";
        return graph;
    }

    public HostedProviders getHostedProviders() {
        return this.hostedProviders;
    }

    public GraalObjectReplacer getObjectReplacer() {
        return this.objectReplacer;
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(DeoptimizationFeature.class, FieldsOffsetsFeature.class);
    }

    public void duringSetup(Feature.DuringSetupAccess c) {
        FeatureImpl.DuringSetupAccessImpl config = (FeatureImpl.DuringSetupAccessImpl)c;
        AnalysisMetaAccess aMetaAccess = config.getMetaAccess();
        try {
            aMetaAccess.lookupJavaType(SubstrateType.class);
        }
        catch (NoClassDefFoundError ex) {
            throw VMError.shouldNotReachHere("Building a native image with Graal support requires Truffle on the class path. For unit tests run with 'svmtest', add the option '--truffle'.");
        }
        ImageSingletons.add(GraalSupport.class, (Object)new GraalSupport());
        if (!ImageSingletons.contains(RuntimeGraalSetup.class)) {
            ImageSingletons.add(RuntimeGraalSetup.class, (Object)new SubstrateRuntimeGraalSetup());
        }
        GraalProviderObjectReplacements providerReplacements = ((RuntimeGraalSetup)ImageSingletons.lookup(RuntimeGraalSetup.class)).getProviderObjectReplacements(aMetaAccess);
        this.objectReplacer = new GraalObjectReplacer(config.getUniverse(), aMetaAccess, providerReplacements);
        config.registerObjectReplacer(this.objectReplacer);
        config.registerClassReachabilityListener(GraalSupport::registerPhaseStatistics);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess c) {
        DebugContext debug = DebugContext.forCurrentThread();
        for (JavaKind kind : new JavaKind[]{JavaKind.Boolean, JavaKind.Byte, JavaKind.Char, JavaKind.Double, JavaKind.Float, JavaKind.Int, JavaKind.Long, JavaKind.Short}) {
            RuntimeReflection.register((Class[])new Class[]{kind.toBoxedJavaClass()});
            Class<?>[] innerClasses = kind.toBoxedJavaClass().getDeclaredClasses();
            if (innerClasses == null || innerClasses.length <= 0) continue;
            RuntimeReflection.register((Class[])new Class[]{innerClasses[0]});
            try {
                RuntimeReflection.register((Field[])new Field[]{innerClasses[0].getDeclaredField("cache")});
            }
            catch (Throwable t) {
                throw debug.handle(t);
            }
        }
        FeatureImpl.BeforeAnalysisAccessImpl config = (FeatureImpl.BeforeAnalysisAccessImpl)c;
        GraalSupport.allocatePhaseStatisticsCache();
        GraalFeature.populateMatchRuleRegistry();
        Function<Providers, SubstrateBackend> backendProvider = GraalSupport.getRuntimeBackendProvider();
        ClassInitializationSupport classInitializationSupport = config.getHostVM().getClassInitializationSupport();
        Providers originalProviders = GraalAccess.getOriginalProviders();
        this.runtimeConfigBuilder = ((RuntimeGraalSetup)ImageSingletons.lookup(RuntimeGraalSetup.class)).createRuntimeConfigurationBuilder((OptionValues)RuntimeOptionValues.singleton(), config.getHostVM(), config.getUniverse(), (MetaAccessProvider)config.getMetaAccess(), originalProviders.getConstantReflection(), backendProvider, config.getNativeLibraries(), classInitializationSupport, originalProviders.getLoopsDataProvider()).build();
        RuntimeConfiguration runtimeConfig = this.runtimeConfigBuilder.getRuntimeConfig();
        Providers runtimeProviders = runtimeConfig.getProviders();
        WordTypes wordTypes = this.runtimeConfigBuilder.getWordTypes();
        this.hostedProviders = new HostedProviders(runtimeProviders.getMetaAccess(), runtimeProviders.getCodeCache(), runtimeProviders.getConstantReflection(), runtimeProviders.getConstantFieldProvider(), runtimeProviders.getForeignCalls(), runtimeProviders.getLowerer(), runtimeProviders.getReplacements(), runtimeProviders.getStampProvider(), runtimeConfig.getSnippetReflection(), wordTypes, runtimeProviders.getPlatformConfigurationProvider(), (MetaAccessExtensionProvider)new GraphPrepareMetaAccessExtensionProvider(), runtimeProviders.getLoopsDataProvider());
        SubstrateGraalRuntime graalRuntime = new SubstrateGraalRuntime();
        this.objectReplacer.setGraalRuntime(graalRuntime);
        ImageSingletons.add(GraalRuntime.class, (Object)graalRuntime);
        RuntimeSupport.getRuntimeSupport().addShutdownHook(new GraalSupport.GraalShutdownHook());
        FeatureHandler featureHandler = config.getFeatureHandler();
        NativeImageGenerator.registerGraphBuilderPlugins(featureHandler, runtimeConfig, this.hostedProviders, config.getMetaAccess(), config.getUniverse(), null, null, config.getNativeLibraries(), config.getImageClassLoader(), ParsingReason.JITCompilation, ((Inflation)config.getBigBang()).getAnnotationSubstitutionProcessor(), new SubstrateClassInitializationPlugin(config.getHostVM()), classInitializationSupport, ConfigurationValues.getTarget());
        NativeImageGenerator.registerReplacements(debug, featureHandler, runtimeConfig, runtimeConfig.getProviders(), runtimeConfig.getSnippetReflection(), false, true);
        featureHandler.forEachGraalFeature(feature -> feature.registerCodeObserver(runtimeConfig));
        Suites suites = NativeImageGenerator.createSuites(featureHandler, runtimeConfig, runtimeConfig.getSnippetReflection(), false);
        LIRSuites lirSuites = NativeImageGenerator.createLIRSuites(featureHandler, runtimeConfig.getProviders(), false);
        Suites firstTierSuites = NativeImageGenerator.createFirstTierSuites(featureHandler, runtimeConfig, runtimeConfig.getSnippetReflection(), false);
        LIRSuites firstTierLirSuites = NativeImageGenerator.createFirstTierLIRSuites(featureHandler, runtimeConfig.getProviders(), false);
        GraalSupport.setRuntimeConfig(runtimeConfig, suites, lirSuites, firstTierSuites, firstTierLirSuites);
        NodeClass<?>[] snippetNodeClasses = ((SubstrateReplacements)runtimeProviders.getReplacements()).getSnippetNodeClasses();
        for (NodeClass<?> nodeClass : snippetNodeClasses) {
            config.getMetaAccess().lookupJavaType(nodeClass.getClazz()).registerAsAllocated(null);
        }
        this.graphBuilderConfig = GraphBuilderConfiguration.getDefault((GraphBuilderConfiguration.Plugins)this.hostedProviders.getGraphBuilderPlugins()).withBytecodeExceptionMode(GraphBuilderConfiguration.BytecodeExceptionMode.ExplicitOnly);
        this.includeCalleePredicate = GraalFeature::defaultIncludeCallee;
        this.optimisticOpts = OptimisticOptimizations.ALL.remove(new OptimisticOptimizations.Optimization[]{OptimisticOptimizations.Optimization.UseLoopLimitChecks});
        this.methods = new LinkedHashMap<AnalysisMethod, CallTreeNode>();
        this.graphEncoder = new GraphEncoder(ConfigurationValues.getTarget().arch);
        for (ResolvedJavaMethod method : ((SubstrateReplacements)runtimeProviders.getReplacements()).getSnippetMethods()) {
            this.objectReplacer.apply(method);
        }
    }

    private static void populateMatchRuleRegistry() {
        GraalSupport.get().setMatchRuleRegistry(new HashMap<Class<? extends NodeMatchRules>, EconomicMap<Class<? extends Node>, List<MatchStatement>>>());
        GraalConfiguration.instance().populateMatchRuleRegistry(GraalSupport.get().getMatchRuleRegistry());
    }

    private static boolean defaultIncludeCallee(CallTreeNode calleeNode, List<AnalysisMethod> implementationMethods) {
        return false;
    }

    public void initializeRuntimeCompilationConfiguration(IncludeCalleePredicate newIncludeCalleePredicate) {
        this.initializeRuntimeCompilationConfiguration(this.hostedProviders, this.graphBuilderConfig, newIncludeCalleePredicate, this.deoptimizeOnExceptionPredicate);
    }

    public void initializeRuntimeCompilationConfiguration(HostedProviders newHostedProviders, GraphBuilderConfiguration newGraphBuilderConfig, IncludeCalleePredicate newIncludeCalleePredicate, Predicate<ResolvedJavaMethod> newDeoptimizeOnExceptionPredicate) {
        VMError.guarantee(!this.initialized, "runtime compilation configuration already initialized");
        this.initialized = true;
        this.hostedProviders = newHostedProviders;
        this.graphBuilderConfig = newGraphBuilderConfig;
        this.includeCalleePredicate = newIncludeCalleePredicate;
        this.deoptimizeOnExceptionPredicate = newDeoptimizeOnExceptionPredicate;
        if (SubstrateOptions.IncludeNodeSourcePositions.getValue().booleanValue()) {
            this.graphBuilderConfig = this.graphBuilderConfig.withNodeSourcePosition(true);
        }
    }

    public SubstrateMethod requireFrameInformationForMethod(ResolvedJavaMethod method) {
        AnalysisMethod aMethod = (AnalysisMethod)method;
        SubstrateMethod sMethod = this.objectReplacer.createMethod((ResolvedJavaMethod)aMethod);
        CompilationInfoSupport.singleton().registerFrameInformationRequired(aMethod);
        return sMethod;
    }

    public SubstrateMethod prepareMethodForRuntimeCompilation(Executable method, FeatureImpl.BeforeAnalysisAccessImpl config) {
        return this.prepareMethodForRuntimeCompilation((ResolvedJavaMethod)config.getMetaAccess().lookupJavaMethod(method), config);
    }

    public SubstrateMethod prepareMethodForRuntimeCompilation(ResolvedJavaMethod method, FeatureImpl.BeforeAnalysisAccessImpl config) {
        AnalysisMethod aMethod = (AnalysisMethod)method;
        SubstrateMethod sMethod = this.objectReplacer.createMethod((ResolvedJavaMethod)aMethod);
        if (!this.methods.containsKey(aMethod)) {
            this.methods.put(aMethod, new CallTreeNode((ResolvedJavaMethod)aMethod, (ResolvedJavaMethod)aMethod, null, 0, ""));
            config.registerAsInvoked(aMethod);
        }
        return sMethod;
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess c) {
        NodeClass[] nodeClasses;
        FeatureImpl.DuringAnalysisAccessImpl config = (FeatureImpl.DuringAnalysisAccessImpl)c;
        ArrayDeque<CallTreeNode> worklist = new ArrayDeque<CallTreeNode>();
        worklist.addAll(this.methods.values());
        while (!worklist.isEmpty()) {
            this.processMethod((CallTreeNode)worklist.removeFirst(), worklist, config.getBigBang());
        }
        SubstrateMethod[] methodsToCompileArr = new SubstrateMethod[this.methods.size()];
        int idx = 0;
        for (CallTreeNode node : this.methods.values()) {
            methodsToCompileArr[idx++] = this.objectReplacer.createMethod((ResolvedJavaMethod)node.implementationMethod);
        }
        if (GraalSupport.setMethodsToCompile(methodsToCompileArr)) {
            config.requireAnalysisIteration();
        }
        this.graphEncoder.finishPrepare();
        AnalysisMetaAccess metaAccess = config.getMetaAccess();
        for (NodeClass nodeClass : nodeClasses = this.graphEncoder.getNodeClasses()) {
            metaAccess.lookupJavaType(nodeClass.getClazz()).registerAsAllocated(null);
        }
        if (GraalSupport.setGraphEncoding(this.graphEncoder.getEncoding(), this.graphEncoder.getObjects(), nodeClasses)) {
            config.requireAnalysisIteration();
        }
        if (this.objectReplacer.updateDataDuringAnalysis(config.getMetaAccess())) {
            config.requireAnalysisIteration();
        }
    }

    private void processMethod(CallTreeNode node, Deque<CallTreeNode> worklist, BigBang bb) {
        AnalysisMethod method = node.implementationMethod;
        assert (method.isImplementationInvoked());
        if (node.graph == null) {
            if (method.getAnnotation(Fold.class) != null || method.getAnnotation(Node.NodeIntrinsic.class) != null) {
                throw VMError.shouldNotReachHere("Parsing method annotated with @Fold or @NodeIntrinsic: " + method.format("%H.%n(%p)"));
            }
            if (!method.allowRuntimeCompilation()) {
                throw VMError.shouldNotReachHere("Parsing method that is not available for runtime compilation: " + method.format("%H.%n(%p)"));
            }
            boolean parse = false;
            DebugContext debug = bb.getDebug();
            StructuredGraph graph = method.buildGraph(debug, (ResolvedJavaMethod)method, this.hostedProviders, GraphProvider.Purpose.PREPARE_RUNTIME_COMPILATION);
            if (graph == null) {
                if (!method.hasBytecodes()) {
                    return;
                }
                parse = true;
                graph = new StructuredGraph.Builder(debug.getOptions(), debug, StructuredGraph.AllowAssumptions.YES).method((ResolvedJavaMethod)method).recordInlinedMethods(false).build();
            }
            try (DebugContext.Scope scope = debug.scope((Object)"RuntimeCompile", (Object)graph);){
                if (parse) {
                    RuntimeGraphBuilderPhase builderPhase = new RuntimeGraphBuilderPhase((Providers)this.hostedProviders, this.graphBuilderConfig, this.optimisticOpts, null, this.hostedProviders.getWordTypes(), node);
                    builderPhase.apply(graph);
                }
                if (graph.getNodes(StackValueNode.TYPE).isNotEmpty()) {
                    return;
                }
                CanonicalizerPhase.create().apply(graph, (Object)this.hostedProviders);
                if (this.deoptimizeOnExceptionPredicate != null) {
                    new DeoptimizeOnExceptionPhase(this.deoptimizeOnExceptionPredicate).apply(graph);
                }
                new ConvertDeoptimizeToGuardPhase().apply(graph, (Object)this.hostedProviders);
                this.graphEncoder.prepare(graph);
                node.graph = graph;
            }
            catch (Throwable ex) {
                debug.handle(ex);
            }
        }
        assert (node.graph != null);
        List callTargets = node.graph.getNodes(MethodCallTargetNode.TYPE).snapshot();
        callTargets.sort((t1, t2) -> Integer.compare(t1.invoke().bci(), t2.invoke().bci()));
        for (MethodCallTargetNode targetNode : callTargets) {
            AnalysisMethod targetMethod = (AnalysisMethod)targetNode.targetMethod();
            AnalysisMethod callerMethod = (AnalysisMethod)targetNode.invoke().stateAfter().getMethod();
            InvokeTypeFlow invokeFlow = callerMethod.getTypeFlow().getOriginalMethodFlows().getInvoke((Object)targetNode.invoke().bci());
            if (invokeFlow == null) continue;
            Collection allImplementationMethods = invokeFlow.getCallees();
            if (allImplementationMethods.size() == 0) {
                node.unreachableInvokes.add(targetNode.invoke());
            } else {
                node.unreachableInvokes.remove(targetNode.invoke());
            }
            ArrayList<AnalysisMethod> implementationMethods = new ArrayList<AnalysisMethod>();
            for (AnalysisMethod implementationMethod : allImplementationMethods) {
                if (this.methods.containsKey(implementationMethod)) continue;
                implementationMethods.add(implementationMethod);
            }
            if (implementationMethods.size() <= 0) continue;
            implementationMethods.sort((m1, m2) -> m1.getQualifiedName().compareTo(m2.getQualifiedName()));
            String sourceReference = GraalFeature.buildSourceReference(targetNode.invoke().stateAfter());
            for (AnalysisMethod implementationMethod : implementationMethods) {
                CallTreeNode calleeNode = new CallTreeNode((ResolvedJavaMethod)implementationMethod, (ResolvedJavaMethod)targetMethod, node, node.level + 1, sourceReference);
                if (this.includeCalleePredicate.includeCallee(calleeNode, implementationMethods)) {
                    assert (!this.methods.containsKey(implementationMethod));
                    this.methods.put(implementationMethod, calleeNode);
                    worklist.add(calleeNode);
                    node.children.add(calleeNode);
                    this.objectReplacer.createMethod((ResolvedJavaMethod)implementationMethod);
                }
                CompilationInfoSupport.singleton().registerForcedCompilation((ResolvedJavaMethod)implementationMethod);
            }
        }
    }

    public static String buildSourceReference(FrameState startState) {
        StringBuilder sourceReferenceBuilder = new StringBuilder();
        for (FrameState state = startState; state != null; state = state.outerFrameState()) {
            if (sourceReferenceBuilder.length() > 0) {
                sourceReferenceBuilder.append(" -> ");
            }
            sourceReferenceBuilder.append(state.getCode().asStackTraceElement(state.bci).toString());
        }
        return sourceReferenceBuilder.toString();
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess c) {
        FeatureImpl.CompilationAccessImpl config = (FeatureImpl.CompilationAccessImpl)c;
        if (Options.PrintRuntimeCompileMethods.getValue().booleanValue()) {
            this.printCallTree();
        }
        System.out.println(this.methods.size() + " method(s) included for runtime compilation");
        if (Options.PrintStaticTruffleBoundaries.getValue().booleanValue()) {
            this.printStaticTruffleBoundaries();
        }
        int maxMethods = 0;
        for (String value : Options.MaxRuntimeCompileMethods.getValue().values()) {
            String numberStr = null;
            try {
                numberStr = value.split("#")[0];
                maxMethods = (int)((long)maxMethods + Long.parseLong(numberStr));
            }
            catch (NumberFormatException ex) {
                throw UserError.abort("Invalid value for option 'MaxRuntimeCompileMethods': '%s' is not a valid number", numberStr);
            }
        }
        if (Options.EnforceMaxRuntimeCompileMethods.getValue().booleanValue() && maxMethods != 0 && this.methods.size() > maxMethods) {
            this.printDeepestLevelPath();
            throw VMError.shouldNotReachHere("Number of methods for runtime compilation exceeds the allowed limit: " + this.methods.size() + " > " + maxMethods);
        }
        HostedMetaAccess hMetaAccess = config.getMetaAccess();
        this.runtimeConfigBuilder.updateLazyState(hMetaAccess);
        this.graphEncoder = new GraphEncoder(ConfigurationValues.getTarget().arch);
        RuntimeStrengthenStampsPhase strengthenStamps = new RuntimeStrengthenStampsPhase(config.getUniverse(), this.objectReplacer);
        CanonicalizerPhase canonicalizer = CanonicalizerPhase.create();
        IterativeConditionalEliminationPhase conditionalElimination = new IterativeConditionalEliminationPhase(canonicalizer, true);
        ConvertDeoptimizeToGuardPhase convertDeoptimizeToGuard = new ConvertDeoptimizeToGuardPhase();
        for (CallTreeNode node : this.methods.values()) {
            StructuredGraph graph = node.graph;
            if (graph == null) continue;
            DebugContext debug = graph.getDebug();
            try {
                DebugContext.Scope scope = debug.scope((Object)"RuntimeOptimize", (Object)graph);
                Throwable throwable = null;
                try {
                    GraalFeature.removeUnreachableInvokes(node);
                    strengthenStamps.apply(graph);
                    canonicalizer.apply(graph, (Object)this.hostedProviders);
                    conditionalElimination.apply(graph, (Object)this.hostedProviders);
                    convertDeoptimizeToGuard.apply(graph, (Object)this.hostedProviders);
                    this.graphEncoder.prepare(graph);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (scope == null) continue;
                    if (throwable != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    scope.close();
                }
            }
            catch (Throwable ex) {
                debug.handle(ex);
            }
        }
        this.graphEncoder.finishPrepare();
        for (CallTreeNode node : this.methods.values()) {
            if (node.graph == null) continue;
            GraalFeature.registerDeoptEntries(node);
            long startOffset = this.graphEncoder.encode(node.graph);
            this.objectReplacer.createMethod((ResolvedJavaMethod)node.implementationMethod).setEncodedGraphStartOffset(startOffset);
            node.graph = null;
        }
        GraalSupport.setGraphEncoding(this.graphEncoder.getEncoding(), this.graphEncoder.getObjects(), this.graphEncoder.getNodeClasses());
        this.objectReplacer.updateDataDuringAnalysis((AnalysisMetaAccess)hMetaAccess.getWrapped());
        this.graphEncoder = null;
    }

    private static void removeUnreachableInvokes(CallTreeNode node) {
        for (Invoke invoke : node.unreachableInvokes) {
            if (!invoke.asNode().isAlive()) continue;
            if (invoke.callTarget().invokeKind().hasReceiver()) {
                InliningUtil.nonNullReceiver((Invoke)invoke);
            }
            FixedGuardNode guard = new FixedGuardNode((LogicNode)LogicConstantNode.forBoolean((boolean)true, (Graph)node.graph), DeoptimizationReason.UnreachedCode, DeoptimizationAction.None, true);
            node.graph.addBeforeFixed(invoke.asNode(), (FixedWithNextNode)node.graph.add((Node)guard));
        }
    }

    private static void registerDeoptEntries(CallTreeNode node) {
        for (FrameState frameState : node.graph.getNodes(FrameState.TYPE)) {
            if (frameState.hasExactlyOneUsage()) {
                Node usage = frameState.usages().first();
                if (node.level > 0 && usage == node.graph.start()) continue;
                if (usage instanceof Invoke && ((Invoke)usage).stateAfter() == frameState) {
                    FixedNode next = ((Invoke)usage).next();
                    while (next instanceof AbstractBeginNode) {
                        next = ((AbstractBeginNode)next).next();
                    }
                    if (next instanceof LoweredDeadEndNode) continue;
                }
            }
            for (FrameState inlineState = frameState; inlineState != null; inlineState = inlineState.outerFrameState()) {
                if (inlineState.bci < 0) continue;
                CompilationInfoSupport.singleton().registerDeoptEntry(inlineState);
            }
        }
        for (Node n : node.graph.getNodes()) {
            if (!(n instanceof Invoke)) continue;
            Invoke invoke = (Invoke)n;
            FrameState stateDuring = invoke.stateAfter().duplicateModifiedDuringCall(invoke.bci(), invoke.asNode().getStackKind());
            assert (stateDuring.duringCall() && !stateDuring.rethrowException());
            CompilationInfoSupport.singleton().registerDeoptEntry(stateDuring);
        }
    }

    private void printDeepestLevelPath() {
        CallTreeNode maxLevelCallTreeNode = null;
        for (CallTreeNode callTreeNode : this.methods.values()) {
            if (maxLevelCallTreeNode != null && maxLevelCallTreeNode.level >= callTreeNode.level) continue;
            maxLevelCallTreeNode = callTreeNode;
        }
        System.out.println(String.format("Deepest level call tree path (%d calls):", maxLevelCallTreeNode.level));
        CallTreeNode node = maxLevelCallTreeNode;
        while (node != null) {
            System.out.format("%5d ; %s ; %s", node.graph == null ? -1 : node.graph.getNodeCount(), node.sourceReference, node.implementationMethod == null ? "" : node.implementationMethod.format("%H.%n(%p)"));
            if (node.targetMethod != null && !node.targetMethod.equals((Object)node.implementationMethod)) {
                System.out.print(" ; " + node.targetMethod.format("%H.%n(%p)"));
            }
            System.out.println();
            node = node.parent;
        }
    }

    private void printStaticTruffleBoundaries() {
        HashSet<ResolvedJavaMethod> foundBoundaries = new HashSet<ResolvedJavaMethod>();
        int callSiteCount = 0;
        int calleeCount = 0;
        for (CallTreeNode node : this.methods.values()) {
            StructuredGraph graph = node.graph;
            for (MethodCallTargetNode callTarget : graph.getNodes(MethodCallTargetNode.TYPE)) {
                ResolvedJavaMethod targetMethod = callTarget.targetMethod();
                CompilerDirectives.TruffleBoundary truffleBoundary = (CompilerDirectives.TruffleBoundary)targetMethod.getAnnotation(CompilerDirectives.TruffleBoundary.class);
                if (truffleBoundary == null) continue;
                ++callSiteCount;
                if (foundBoundaries.contains(targetMethod)) continue;
                foundBoundaries.add(targetMethod);
                System.out.println("Truffle boundary found: " + targetMethod);
                ++calleeCount;
            }
        }
        System.out.println(String.format("Number of Truffle call boundaries: %d, number of unique called methods outside the boundary: %d", callSiteCount, calleeCount));
    }

    private void printCallTree() {
        System.out.println("depth;method;Graal nodes;invoked from source;full method name;full name of invoked virtual method");
        for (CallTreeNode node : this.methods.values()) {
            if (node.level != 0) continue;
            this.printCallTreeNode(node);
        }
        System.out.println();
    }

    private void printCallTreeNode(CallTreeNode node) {
        StringBuilder indent = new StringBuilder();
        for (int i = 0; i < node.level; ++i) {
            indent.append("  ");
        }
        if (node.implementationMethod != null) {
            indent.append(node.implementationMethod.format("%h.%n"));
        }
        System.out.format("%4d ; %-80s  ;%5d ; %s ; %s", node.level, indent, node.graph == null ? -1 : node.graph.getNodeCount(), node.sourceReference, node.implementationMethod == null ? "" : node.implementationMethod.format("%H.%n(%p)"));
        if (node.targetMethod != null && !node.targetMethod.equals((Object)node.implementationMethod)) {
            System.out.print(" ; " + node.targetMethod.format("%H.%n(%p)"));
        }
        System.out.println();
        for (CallTreeNode child : node.children) {
            this.printCallTreeNode(child);
        }
    }

    public void afterCompilation(Feature.AfterCompilationAccess a) {
        FeatureImpl.CompilationAccessImpl config = (FeatureImpl.CompilationAccessImpl)a;
        HostedMetaAccess hMetaAccess = config.getMetaAccess();
        HostedUniverse hUniverse = (HostedUniverse)hMetaAccess.getUniverse();
        this.objectReplacer.updateSubstrateDataAfterCompilation(hUniverse, config.getProviders().getConstantFieldProvider());
        this.objectReplacer.registerImmutableObjects(config);
        GraalSupport.registerImmutableObjects(config);
        ((SubstrateReplacements)this.runtimeConfigBuilder.getRuntimeConfig().getProviders().getReplacements()).registerImmutableObjects(config);
    }

    public void afterHeapLayout(Feature.AfterHeapLayoutAccess a) {
        FeatureImpl.AfterHeapLayoutAccessImpl config = (FeatureImpl.AfterHeapLayoutAccessImpl)a;
        HostedMetaAccess hMetaAccess = config.getMetaAccess();
        HostedUniverse hUniverse = (HostedUniverse)hMetaAccess.getUniverse();
        this.objectReplacer.updateSubstrateDataAfterHeapLayout(hUniverse);
    }

    public static class RuntimeBytecodeParser
    extends SubstrateGraphBuilderPhase.SubstrateBytecodeParser {
        RuntimeBytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
            super(graphBuilderInstance, graph, parent, method, entryBCI, intrinsicContext, false);
        }

        protected boolean tryInvocationPlugin(CallTargetNode.InvokeKind invokeKind, ValueNode[] args, ResolvedJavaMethod targetMethod, JavaKind resultType) {
            boolean result = super.tryInvocationPlugin(invokeKind, args, targetMethod, resultType);
            if (result) {
                CompilationInfoSupport.singleton().registerAsDeoptInlininingExclude(targetMethod);
            }
            return result;
        }

        public CallTreeNode getCallTreeNode() {
            return ((RuntimeGraphBuilderPhase)this.getGraphBuilderInstance()).node;
        }
    }

    public static class RuntimeGraphBuilderPhase
    extends SubstrateGraphBuilderPhase {
        final CallTreeNode node;

        RuntimeGraphBuilderPhase(Providers providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext, WordTypes wordTypes, CallTreeNode node) {
            super((CoreProviders)providers, graphBuilderConfig, optimisticOpts, initialIntrinsicContext, wordTypes);
            this.node = node;
        }

        @Override
        protected BytecodeParser createBytecodeParser(StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
            return new RuntimeBytecodeParser(this, graph, parent, method, entryBCI, intrinsicContext);
        }
    }

    public static final class CallTreeNode {
        protected final AnalysisMethod implementationMethod;
        protected final AnalysisMethod targetMethod;
        protected final CallTreeNode parent;
        protected final List<CallTreeNode> children;
        protected final int level;
        protected final String sourceReference;
        protected StructuredGraph graph;
        protected final Set<Invoke> unreachableInvokes;

        public CallTreeNode(ResolvedJavaMethod implementationMethod, ResolvedJavaMethod targetMethod, CallTreeNode parent, int level, String sourceReference) {
            this.implementationMethod = (AnalysisMethod)implementationMethod;
            this.targetMethod = (AnalysisMethod)targetMethod;
            this.parent = parent;
            this.level = level;
            this.sourceReference = sourceReference;
            this.children = new ArrayList<CallTreeNode>();
            this.unreachableInvokes = new HashSet<Invoke>();
        }

        public AnalysisMethod getImplementationMethod() {
            return this.implementationMethod;
        }

        public AnalysisMethod getTargetMethod() {
            return this.targetMethod;
        }

        public CallTreeNode getParent() {
            return this.parent;
        }

        public List<CallTreeNode> getChildren() {
            return this.children;
        }

        public int getLevel() {
            return this.level;
        }

        public String getSourceReference() {
            return this.sourceReference;
        }

        public StructuredGraph getGraph() {
            return this.graph;
        }

        public void setGraph(StructuredGraph graph) {
            this.graph = graph;
        }
    }

    public static interface IncludeCalleePredicate {
        public boolean includeCallee(CallTreeNode var1, List<AnalysisMethod> var2);
    }

    public static final class IsEnabledAndNotLibgraal
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return ImageSingletons.contains(GraalFeature.class) && !SubstrateUtil.isBuildingLibgraal();
        }
    }

    public static final class IsEnabled
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return ImageSingletons.contains(GraalFeature.class);
        }
    }

    public static class Options {
        @Option(help={"Print call tree of methods available for runtime compilation"})
        public static final HostedOptionKey<Boolean> PrintRuntimeCompileMethods = new HostedOptionKey<Boolean>(false);
        @Option(help={"Print truffle boundaries found during the analysis"})
        public static final HostedOptionKey<Boolean> PrintStaticTruffleBoundaries = new HostedOptionKey<Boolean>(false);
        @Option(help={"Maximum number of methods allowed for runtime compilation."})
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> MaxRuntimeCompileMethods = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        @Option(help={"Enforce checking of maximum number of methods allowed for runtime compilation. Useful for checking in the gate that the number of methods does not go up without a good reason."})
        public static final HostedOptionKey<Boolean> EnforceMaxRuntimeCompileMethods = new HostedOptionKey<Boolean>(false);
    }
}

