/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.threadlocal;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.annotate.UnknownObjectField;
import com.oracle.svm.core.annotate.UnknownPrimitiveField;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class VMThreadLocalMTSupport {
    @UnknownPrimitiveField
    public int vmThreadSize = -1;
    @UnknownObjectField(types={byte[].class})
    public byte[] vmThreadReferenceMapEncoding;
    @UnknownPrimitiveField
    public long vmThreadReferenceMapIndex = -1L;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public VMThreadLocalMTSupport() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public NonmovableArray<Byte> getThreadLocalsReferenceMap() {
        assert (this.vmThreadReferenceMapEncoding != null);
        return NonmovableArrays.fromImageHeap((Object)this.vmThreadReferenceMapEncoding);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getThreadLocalsReferenceMapIndex() {
        long result = this.vmThreadReferenceMapIndex;
        assert (result >= 0L);
        assert ((long)((int)result) == result);
        return (int)result;
    }
}

