/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux.libc;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.c.libc.LibCBase;
import com.oracle.svm.core.util.UserError;
import java.util.Collections;
import java.util.List;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;

public class MuslLibC
implements LibCBase {
    public static final String NAME = "musl";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public List<String> getAdditionalQueryCodeCompilerOptions() {
        return Collections.singletonList("--static");
    }

    @Override
    public String getTargetCompiler() {
        return "x86_64-linux-musl-gcc";
    }

    @Override
    public boolean hasIsolatedNamespaces() {
        return false;
    }

    @Override
    public boolean requiresLibCSpecificStaticJDKLibraries() {
        return true;
    }

    @Override
    public void checkIfLibCSupported() {
        if (!SubstrateOptions.StaticExecutable.getValue().booleanValue()) {
            throw UserError.abort("Musl can only be used for statically linked executables.", new Object[0]);
        }
        if (JavaVersionUtil.JAVA_SPEC < 11) {
            throw UserError.abort("Musl can only be used with labsjdk 11+.", new Object[0]);
        }
    }
}

