/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.os;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.os.AbstractImageHeapProvider;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.util.PointerUtils;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public abstract class AbstractCopyingImageHeapProvider
extends AbstractImageHeapProvider {
    @Override
    public boolean guaranteesHeapPreferredAddressSpaceAlignment() {
        return true;
    }

    @Override
    @Uninterruptible(reason="Called during isolate initialization.")
    public int initialize(Pointer reservedAddressSpace, UnsignedWord reservedSize, WordPointer basePointer, WordPointer endPointer) {
        Pointer heapBase;
        UnsignedWord imageHeapAddressSpaceSize = AbstractCopyingImageHeapProvider.getImageHeapAddressSpaceSize();
        Pointer allocatedMemory = (Pointer)WordFactory.nullPointer();
        if (reservedAddressSpace.isNull()) {
            UnsignedWord alignment = WordFactory.unsigned((int)Heap.getHeap().getPreferredAddressSpaceAlignment());
            heapBase = allocatedMemory = VirtualMemoryProvider.get().reserve(imageHeapAddressSpaceSize, alignment);
            if (allocatedMemory.isNull()) {
                return 801;
            }
        } else {
            if (reservedSize.belowThan(imageHeapAddressSpaceSize)) {
                return 802;
            }
            heapBase = reservedAddressSpace;
        }
        Word imageHeapBegin = Isolates.IMAGE_HEAP_BEGIN.get();
        UnsignedWord imageHeapSizeInFile = AbstractCopyingImageHeapProvider.getImageHeapSizeInFile();
        Pointer imageHeap = heapBase.add(Heap.getHeap().getImageHeapOffsetInAddressSpace());
        imageHeap = VirtualMemoryProvider.get().commit((PointerBase)imageHeap, imageHeapSizeInFile, 3);
        if (imageHeap.isNull()) {
            this.freeImageHeap((PointerBase)allocatedMemory);
            return 801;
        }
        int copyResult = this.copyMemory((Pointer)imageHeapBegin, imageHeapSizeInFile, imageHeap);
        if (copyResult != 0) {
            this.freeImageHeap((PointerBase)allocatedMemory);
            return copyResult;
        }
        UnsignedWord pageSize = VirtualMemoryProvider.get().getGranularity();
        int nullRegionSize = Heap.getHeap().getImageHeapNullRegionSize();
        Pointer firstPartOfReadOnlyImageHeap = imageHeap.add(nullRegionSize);
        UnsignedWord writableBeginPageOffset = UnsignedUtils.roundDown((UnsignedWord)Isolates.IMAGE_HEAP_WRITABLE_BEGIN.get().subtract(imageHeapBegin.add(nullRegionSize)), pageSize);
        if (writableBeginPageOffset.aboveThan(0) && VirtualMemoryProvider.get().protect((PointerBase)firstPartOfReadOnlyImageHeap, writableBeginPageOffset, 1) != 0) {
            this.freeImageHeap((PointerBase)allocatedMemory);
            return 9;
        }
        UnsignedWord writableEndPageOffset = UnsignedUtils.roundUp((UnsignedWord)Isolates.IMAGE_HEAP_WRITABLE_END.get().subtract(imageHeapBegin), pageSize);
        if (writableEndPageOffset.belowThan(imageHeapSizeInFile)) {
            Pointer afterWritableBoundary = imageHeap.add(writableEndPageOffset);
            UnsignedWord afterWritableSize = imageHeapSizeInFile.subtract(writableEndPageOffset);
            if (VirtualMemoryProvider.get().protect((PointerBase)afterWritableBoundary, afterWritableSize, 1) != 0) {
                this.freeImageHeap((PointerBase)allocatedMemory);
                return 9;
            }
        }
        if (nullRegionSize > 0 && VirtualMemoryProvider.get().protect((PointerBase)imageHeapBegin, WordFactory.unsigned((int)nullRegionSize), 0) != 0) {
            return 9;
        }
        basePointer.write((WordBase)heapBase);
        if (endPointer.isNonNull()) {
            endPointer.write((WordBase)PointerUtils.roundUp((PointerBase)imageHeap.add(imageHeapSizeInFile), pageSize));
        }
        return 0;
    }

    @Uninterruptible(reason="Called during isolate initialization.")
    protected abstract int copyMemory(Pointer var1, UnsignedWord var2, Pointer var3);

    @Override
    @Uninterruptible(reason="Called during isolate tear-down.")
    public int freeImageHeap(PointerBase imageHeap) {
        if (imageHeap.isNonNull() && VirtualMemoryProvider.get().free(imageHeap, AbstractCopyingImageHeapProvider.getImageHeapAddressSpaceSize()) != 0) {
            return 20;
        }
        return 0;
    }
}

