/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.jdk.UninterruptibleEntry;
import com.oracle.svm.core.locks.VMMutex;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.WordFactory;

public abstract class UninterruptibleHashtable<T extends UninterruptibleEntry<T>> {
    private static final int DEFAULT_TABLE_LENGTH = 2053;
    private final T[] table;
    private final VMMutex mutex;
    private long nextId;
    private int size;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public UninterruptibleHashtable(String name) {
        this(name, 2053);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public UninterruptibleHashtable(String name, int primeLength) {
        this.table = this.createTable(primeLength);
        this.mutex = new VMMutex(name);
        this.size = 0;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected abstract T[] createTable(int var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract boolean isEqual(T var1, T var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract T copyToHeap(T var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract void free(T var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void clear() {
        for (int i = 0; i < this.table.length; ++i) {
            T entry = this.table[i];
            while (entry.isNonNull()) {
                T tmp = entry;
                entry = entry.getNext();
                this.free(tmp);
            }
            this.table[i] = (UninterruptibleEntry)WordFactory.nullPointer();
        }
        this.size = 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void setSize(int size) {
        this.size = size;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void teardown() {
        this.clear();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long add(T valueOnStack) {
        assert (valueOnStack.isNonNull());
        this.mutex.lockNoTransition();
        try {
            int index = Integer.remainderUnsigned(valueOnStack.getHash(), 2053);
            T entry = this.table[index];
            while (entry.isNonNull()) {
                if (this.isEqual(valueOnStack, entry)) {
                    long l = entry.getId();
                    return l;
                }
                entry = entry.getNext();
            }
            long l = this.insertEntry(index, valueOnStack);
            return l;
        }
        finally {
            this.mutex.unlock();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private long insertEntry(int index, T valueOnStack) {
        T newEntry = this.copyToHeap(valueOnStack);
        if (newEntry.isNonNull()) {
            long id = ++this.nextId;
            T existingEntry = this.table[index];
            newEntry.setNext(existingEntry);
            newEntry.setId(id);
            this.table[index] = newEntry;
            ++this.size;
            return id;
        }
        return 0L;
    }

    public T[] getTable() {
        return this.table;
    }
}

