/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.containers;

import java.lang.reflect.Method;

public interface Metrics {
    public static Metrics systemMetrics() {
        try {
            Class<?> c = Class.forName("com.oracle.svm.core.containers.CgroupMetrics");
            Method m = c.getMethod("getInstance", new Class[0]);
            return (Metrics)m.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (ReflectiveOperationException e) {
            throw new InternalError(e);
        }
    }

    public String getProvider();

    public long getCpuUsage();

    public long[] getPerCpuUsage();

    public long getCpuUserUsage();

    public long getCpuSystemUsage();

    public long getCpuPeriod();

    public long getCpuQuota();

    public long getCpuShares();

    public long getCpuNumPeriods();

    public long getCpuNumThrottled();

    public long getCpuThrottledTime();

    public long getEffectiveCpuCount();

    public int[] getCpuSetCpus();

    public int[] getEffectiveCpuSetCpus();

    public int[] getCpuSetMems();

    public int[] getEffectiveCpuSetMems();

    public long getMemoryFailCount();

    public long getMemoryLimit();

    public long getMemoryUsage();

    public long getTcpMemoryUsage();

    public long getMemoryAndSwapLimit();

    public long getMemoryAndSwapUsage();

    public long getMemorySoftLimit();

    public long getBlkIOServiceCount();

    public long getBlkIOServiced();
}

