/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.util.json.JSONParser;
import com.oracle.svm.core.util.json.JSONParserException;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;

public class SerializationConfigurationParser
extends ConfigurationParser {
    public static final String NAME_KEY = "name";
    public static final String CUSTOM_TARGET_CONSTRUCTOR_CLASS_KEY = "customTargetConstructorClass";
    public static final String SERIALIZATION_TYPES_KEY = "types";
    private final RuntimeSerializationSupport serializationSupport;

    public SerializationConfigurationParser(RuntimeSerializationSupport serializationSupport, boolean strictConfiguration) {
        super(strictConfiguration);
        this.serializationSupport = serializationSupport;
    }

    @Override
    public void parseAndRegister(Reader reader) throws IOException {
        JSONParser parser = new JSONParser(reader);
        Object json = parser.parse();
        if (json instanceof List) {
            this.parseSerializationList(SerializationConfigurationParser.asList(json, "first level of document must be an array of serialization descriptor objects"));
        } else if (json instanceof Map) {
            Object listObject = SerializationConfigurationParser.asMap(json, "first level of document must be a map of serialization types").get(SERIALIZATION_TYPES_KEY);
            if (listObject != null) {
                this.parseSerializationList(SerializationConfigurationParser.asList(listObject, "types must be an array of serialization descriptor objects"));
            }
        } else {
            throw new JSONParserException("first level of document must either be an array of serialization lists or a map of serialization types");
        }
    }

    private void parseSerializationList(List<Object> list) {
        for (Object serializationKey : list) {
            this.parseSerializationDescriptorObject(SerializationConfigurationParser.asMap(serializationKey, "second level of document must be serialization descriptor objects"));
        }
    }

    private void parseSerializationDescriptorObject(Map<String, Object> data) {
        this.checkAttributes(data, "serialization descriptor object", Collections.singleton(NAME_KEY), Arrays.asList(CUSTOM_TARGET_CONSTRUCTOR_CLASS_KEY, "condition"));
        ConfigurationCondition unresolvedCondition = this.parseCondition(data);
        String targetSerializationClass = SerializationConfigurationParser.asString(data.get(NAME_KEY));
        Object optionalCustomCtorValue = data.get(CUSTOM_TARGET_CONSTRUCTOR_CLASS_KEY);
        String customTargetConstructorClass = optionalCustomCtorValue != null ? SerializationConfigurationParser.asString(optionalCustomCtorValue) : null;
        this.serializationSupport.registerWithTargetConstructorClass(unresolvedCondition, targetSerializationClass, customTargetConstructorClass);
    }
}

