/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

public final class PointerUtils {
    private PointerUtils() {
    }

    @Uninterruptible(reason="Used in uninterruptible code.", mayBeInlined=true)
    public static Pointer roundDown(PointerBase that, UnsignedWord multiple) {
        return (Pointer)UnsignedUtils.roundDown((UnsignedWord)that, multiple);
    }

    @Uninterruptible(reason="Used in uninterruptible code.", mayBeInlined=true)
    public static Pointer roundUp(PointerBase that, UnsignedWord multiple) {
        return (Pointer)UnsignedUtils.roundUp((UnsignedWord)that, multiple);
    }

    @Uninterruptible(reason="Used in uninterruptible code.", mayBeInlined=true)
    public static boolean isAMultiple(PointerBase that, UnsignedWord multiple) {
        return UnsignedUtils.isAMultiple((UnsignedWord)that, multiple);
    }

    public static UnsignedWord absoluteDifference(PointerBase pointer1, PointerBase pointer2) {
        Pointer p1 = (Pointer)pointer1;
        Pointer p2 = (Pointer)pointer2;
        Pointer result = p1.aboveOrEqual((UnsignedWord)p2) ? p1.subtract((UnsignedWord)p2) : p2.subtract((UnsignedWord)p1);
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends PointerBase> T min(T x, T y) {
        return ((Pointer)x).belowOrEqual((UnsignedWord)((Pointer)y)) ? x : y;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends PointerBase> T max(T x, T y) {
        return ((Pointer)x).aboveOrEqual((UnsignedWord)((Pointer)y)) ? x : y;
    }
}

