/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.graal.nodes.DeoptTestNode;
import com.oracle.svm.core.graal.snippets.DeoptTester;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateIntrinsics;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import java.util.Map;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

public final class DeoptTestSnippets
extends SubstrateTemplates
implements Snippets {
    @Snippet
    protected static void deoptTestSnippet() {
        SubstrateIntrinsics.runtimeCall(DeoptTester.DEOPTTEST);
    }

    public static void registerLowerings(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new DeoptTestSnippets(options, factories, providers, snippetReflection, lowerings);
    }

    private DeoptTestSnippets(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, factories, providers, snippetReflection);
        lowerings.put(DeoptTestNode.class, new DeoptTestLowering());
    }

    protected class DeoptTestLowering
    implements NodeLoweringProvider<DeoptTestNode> {
        private final SnippetTemplate.SnippetInfo deoptTest;

        protected DeoptTestLowering() {
            this.deoptTest = DeoptTestSnippets.this.snippet(DeoptTestSnippets.class, "deoptTestSnippet", new LocationIdentity[0]);
        }

        @Override
        public void lower(DeoptTestNode node, LoweringTool tool) {
            if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.LOW_TIER) {
                return;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.deoptTest, node.graph().getGuardsStage(), tool.getLoweringStage());
            DeoptTestSnippets.this.template((ValueNode)node, args).instantiate(DeoptTestSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

