/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.serialize;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.reflect.serialize.SerializationRegistry;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SerializationSupport
implements SerializationRegistry {
    private final Constructor<?> stubConstructor;
    private final Map<SerializationLookupKey, Object> constructorAccessors = new ConcurrentHashMap<SerializationLookupKey, Object>();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SerializationSupport(Constructor<?> stubConstructor) {
        this.stubConstructor = stubConstructor;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Object addConstructorAccessor(Class<?> declaringClass, Class<?> targetConstructorClass, Object constructorAccessor) {
        SerializationLookupKey key = new SerializationLookupKey(declaringClass, targetConstructorClass);
        return this.constructorAccessors.putIfAbsent(key, constructorAccessor);
    }

    @Override
    public Object getSerializationConstructorAccessor(Class<?> declaringClass, Class<?> rawTargetConstructorClass) {
        Class<?> targetConstructorClass = Modifier.isAbstract(declaringClass.getModifiers()) ? this.stubConstructor.getDeclaringClass() : rawTargetConstructorClass;
        Object constructorAccessor = this.constructorAccessors.get(new SerializationLookupKey(declaringClass, targetConstructorClass));
        if (constructorAccessor != null) {
            return constructorAccessor;
        }
        String targetConstructorClassName = targetConstructorClass.getName();
        if (targetConstructorClassName.contains("$$Lambda$")) {
            throw VMError.unsupportedFeature("Can't serialize " + targetConstructorClassName + ". Lambda class serialization is currently not supported");
        }
        throw VMError.unsupportedFeature("SerializationConstructorAccessor class not found for declaringClass: " + declaringClass.getName() + " (targetConstructorClass: " + targetConstructorClassName + "). Usually adding " + declaringClass.getName() + " to serialization-config.json fixes the problem.");
    }

    private static final class SerializationLookupKey {
        private final Class<?> declaringClass;
        private final Class<?> targetConstructorClass;

        private SerializationLookupKey(Class<?> declaringClass, Class<?> targetConstructorClass) {
            assert (declaringClass != null && targetConstructorClass != null);
            this.declaringClass = declaringClass;
            this.targetConstructorClass = targetConstructorClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SerializationLookupKey that = (SerializationLookupKey)o;
            return this.declaringClass.equals(that.declaringClass) && this.targetConstructorClass.equals(that.targetConstructorClass);
        }

        public int hashCode() {
            return Objects.hash(this.declaringClass, this.targetConstructorClass);
        }
    }

    public static final class StubForAbstractClass
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private StubForAbstractClass() {
        }
    }
}

