/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.snippets;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class IntrinsificationPluginRegistry {
    private static final Object NULL_MARKER = new Object();
    private final ConcurrentHashMap<CallSiteDescriptor, Object> analysisElements = new ConcurrentHashMap();

    public void add(ResolvedJavaMethod method, int bci, Object element) {
        Object nonNullElement = element != null ? element : NULL_MARKER;
        Object previous = this.analysisElements.put(new CallSiteDescriptor(method, bci), nonNullElement);
        VMError.guarantee(previous == null, "Detected previously intrinsified element");
    }

    public <T> T get(ResolvedJavaMethod method, int bci) {
        Object nonNullElement = this.analysisElements.get(new CallSiteDescriptor(method, bci));
        return (T)(nonNullElement != NULL_MARKER ? nonNullElement : null);
    }

    static final class CallSiteDescriptor {
        private final AnalysisMethod method;
        private final int bci;

        private CallSiteDescriptor(ResolvedJavaMethod method, int bci) {
            this.method = CallSiteDescriptor.toAnalysisMethod(method);
            this.bci = bci;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CallSiteDescriptor) {
                CallSiteDescriptor other = (CallSiteDescriptor)obj;
                return other.bci == this.bci && other.method.equals((Object)this.method);
            }
            return false;
        }

        public int hashCode() {
            return this.method.hashCode() ^ this.bci;
        }

        public String toString() {
            return this.method.format("%h.%n(%p)") + "@" + this.bci;
        }

        private static AnalysisMethod toAnalysisMethod(ResolvedJavaMethod method) {
            if (method instanceof HostedMethod) {
                return ((HostedMethod)method).wrapped;
            }
            VMError.guarantee(method instanceof AnalysisMethod);
            return (AnalysisMethod)method;
        }
    }
}

