/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Method;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;

public class BootLoaderSupport {
    public static ClassLoader getBootLoader() {
        if (JavaVersionUtil.JAVA_SPEC <= 8) {
            return null;
        }
        try {
            Class<?> classLoadersClass = Class.forName("jdk.internal.loader.ClassLoaders");
            Method method = ReflectionUtil.lookupMethod(classLoadersClass, (String)"bootLoader", (Class[])new Class[0]);
            Object r = method.invoke(null, new Object[0]);
            return (ClassLoader)r;
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere("Cannot get access to the boot loader", e);
        }
    }
}

