/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.IsolateListenerSupport;
import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.graal.nodes.WriteCurrentVMThreadNode;
import com.oracle.svm.core.graal.nodes.WriteHeapBaseNode;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public abstract class SubstrateSegfaultHandler {
    private boolean installed;

    @Fold
    public static SubstrateSegfaultHandler singleton() {
        return (SubstrateSegfaultHandler)ImageSingletons.lookup(SubstrateSegfaultHandler.class);
    }

    public static boolean isInstalled() {
        return SubstrateSegfaultHandler.singleton().installed;
    }

    public void install() {
        this.installInternal();
        this.installed = true;
    }

    protected abstract void installInternal();

    protected abstract void printSignalInfo(Log var1, PointerBase var2);

    @Uninterruptible(reason="Called from uninterruptible code.")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in segfault handler.", overridesCallers=true)
    protected static boolean tryEnterIsolate(RegisterDumper.Context context) {
        Isolate isolate = SingleIsolateSegfaultSetup.singleton().getIsolate();
        if (isolate.rawValue() != -1L) {
            int error = CEntryPointActions.enterAttachThreadFromCrashHandler(isolate);
            return error == 0;
        }
        if (!SubstrateOptions.useLLVMBackend()) {
            if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                PointerBase heapBase = RegisterDumper.singleton().getHeapBase(context);
                WriteHeapBaseNode.writeCurrentVMHeapBase(heapBase);
            }
            if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                PointerBase threadPointer = RegisterDumper.singleton().getThreadPointer(context);
                WriteCurrentVMThreadNode.writeCurrentVMThread((IsolateThread)threadPointer);
            }
            return Isolates.checkSanity(isolate = VMThreads.IsolateTL.get()) == 0 && (SubstrateOptions.SpawnIsolates.getValue() == false || isolate.equal((ComparableWord)KnownIntrinsics.heapBase()));
        }
        return false;
    }

    @Uninterruptible(reason="Must be uninterruptible until we get immune to safepoints.", calleeMustBe=false)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in segfault handler.", overridesCallers=true)
    protected static void dump(PointerBase signalInfo, RegisterDumper.Context context) {
        VMThreads.StatusSupport.setStatusIgnoreSafepoints();
        StackOverflowCheck.singleton().disableStackOverflowChecksForFatalError();
        SubstrateSegfaultHandler.dumpInterruptibly(signalInfo, context);
    }

    private static void dumpInterruptibly(PointerBase signalInfo, RegisterDumper.Context context) {
        PointerBase callerIP = RegisterDumper.singleton().getIP(context);
        LogHandler logHandler = (LogHandler)ImageSingletons.lookup(LogHandler.class);
        Log log = Log.enterFatalContext(logHandler, (CodePointer)callerIP, "[ [ SubstrateSegfaultHandler caught a segfault. ] ]", null);
        if (log != null) {
            log.newline();
            log.string("[ [ SubstrateSegfaultHandler caught a segfault in thread ").zhex((WordBase)CurrentIsolate.getCurrentThread()).string(" ] ]").newline();
            ((SubstrateSegfaultHandler)ImageSingletons.lookup(SubstrateSegfaultHandler.class)).printSignalInfo(log, signalInfo);
            PointerBase sp = RegisterDumper.singleton().getSP(context);
            PointerBase ip = RegisterDumper.singleton().getIP(context);
            boolean printedDiagnostics = SubstrateDiagnostics.printFatalError(log, (Pointer)sp, (CodePointer)ip, context, false);
            if (printedDiagnostics) {
                log.string("Segfault detected, aborting process. Use runtime option -R:-InstallSegfaultHandler if you don't want to use SubstrateSegfaultHandler.").newline();
                log.newline();
            }
        }
        logHandler.fatalError();
    }

    static class SingleIsolateSegfaultSetup
    implements IsolateListenerSupport.IsolateListener {
        private static final CGlobalData<Pointer> baseIsolate = CGlobalDataFactory.createWord();

        SingleIsolateSegfaultSetup() {
        }

        @Fold
        public static SingleIsolateSegfaultSetup singleton() {
            return (SingleIsolateSegfaultSetup)ImageSingletons.lookup(SingleIsolateSegfaultSetup.class);
        }

        @Override
        @Uninterruptible(reason="Thread state not yet set up.")
        public void afterCreateIsolate(Isolate isolate) {
            PointerBase value = (PointerBase)baseIsolate.get().compareAndSwapWord(0, WordFactory.zero(), (WordBase)isolate, LocationIdentity.ANY_LOCATION);
            if (!value.isNull()) {
                baseIsolate.get().writeWord(0, (WordBase)WordFactory.signed((int)-1));
            }
        }

        @Uninterruptible(reason="Thread state not yet set up.")
        public Isolate getIsolate() {
            return (Isolate)baseIsolate.get().readWord(0);
        }
    }

    public static class Options {
        @Option(help={"Install segfault handler that prints register contents and full Java stacktrace. Default: enabled for an executable, disabled for a shared library."})
        static final RuntimeOptionKey<Boolean> InstallSegfaultHandler = new RuntimeOptionKey<Object>(null);
    }
}

