/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.HashSet;
import java.util.Set;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.bytecode.BytecodeStream;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.java.BciBlockMapping;
import org.graalvm.compiler.options.OptionValues;

final class HostedBciBlockMapping
extends BciBlockMapping {
    private final Set<DeoptEntryInsertionPoint> insertedBlocks = new HashSet<DeoptEntryInsertionPoint>();

    private HostedBciBlockMapping(Bytecode code, DebugContext debug) {
        super(code, debug);
    }

    public static BciBlockMapping create(BytecodeStream stream, Bytecode code, OptionValues options, DebugContext debug, boolean hasAsyncExceptions) {
        HostedBciBlockMapping map = new HostedBciBlockMapping(code, debug);
        HostedBciBlockMapping.buildMap((BytecodeStream)stream, (Bytecode)code, (OptionValues)options, (DebugContext)debug, (BciBlockMapping)map, (boolean)hasAsyncExceptions);
        return map;
    }

    protected BciBlockMapping.BciBlock getInstructionBlock(int bci) {
        BciBlockMapping.BciBlock current = this.blockMap[bci];
        assert (!(current instanceof BciBlockMapping.ExceptionDispatchBlock));
        if (current instanceof DeoptBciBlock) {
            assert (!(current.getSuccessor(0) instanceof DeoptBciBlock));
            return current.getSuccessor(0);
        }
        return current;
    }

    private boolean needsDeoptEntryBlock(int bci, boolean duringCall, boolean rethrowException) {
        return ((HostedMethod)this.code.getMethod()).compilationInfo.isDeoptEntry(bci, duringCall, rethrowException);
    }

    protected boolean isStartOfNewBlock(BciBlockMapping.BciBlock current, int bci) {
        if (this.needsDeoptEntryBlock(bci, false, false)) {
            return true;
        }
        return super.isStartOfNewBlock(current, bci);
    }

    private void recordInsertedBlock(DeoptEntryInsertionPoint block) {
        ++this.blocksNotYetAssignedId;
        assert (this.insertedBlocks.add(block));
    }

    protected void addInvokeNormalSuccessor(int invokeBci, BciBlockMapping.BciBlock sux) {
        if (sux.isExceptionEntry()) {
            throw new PermanentBailoutException("Exception handler can be reached by both normal and exceptional control flow");
        }
        if (this.needsDeoptEntryBlock(invokeBci, true, false) && !(sux instanceof DeoptBciBlock)) {
            DeoptBciBlock proxyBlock = DeoptBciBlock.createDeoptProxy(sux.getStartBci(), invokeBci);
            this.recordInsertedBlock(proxyBlock);
            this.getInstructionBlock(invokeBci).addSuccessor((BciBlockMapping.BciBlock)proxyBlock);
            proxyBlock.addSuccessor(sux);
            return;
        }
        super.addInvokeNormalSuccessor(invokeBci, sux);
    }

    private void addExceptionHandlerEdge(DeoptBciBlock block) {
        BciBlockMapping.ExceptionDispatchBlock deoptExceptionHandler = this.handleExceptions(block.getStartBci(), false, false);
        if (deoptExceptionHandler != null) {
            block.addSuccessor((BciBlockMapping.BciBlock)deoptExceptionHandler);
        }
    }

    protected BciBlockMapping.BciBlock startNewBlock(int bci) {
        BciBlockMapping.BciBlock currentBlock = this.blockMap[bci];
        if (currentBlock != null) {
            assert (currentBlock.getStartBci() == bci);
            return currentBlock;
        }
        BciBlockMapping.BciBlock newBlock = new BciBlockMapping.BciBlock(bci);
        ++this.blocksNotYetAssignedId;
        if (this.needsDeoptEntryBlock(bci, false, false)) {
            DeoptBciBlock deoptEntry = DeoptBciBlock.createDeoptEntry(bci);
            this.recordInsertedBlock(deoptEntry);
            deoptEntry.addSuccessor(newBlock);
            newBlock = deoptEntry;
        }
        this.blockMap[bci] = newBlock;
        return newBlock;
    }

    protected Set<BciBlockMapping.BciBlock> makeExceptionEntries(boolean splitRanges) {
        Set requestedBlockStarts = super.makeExceptionEntries(splitRanges);
        for (BciBlockMapping.BciBlock block : requestedBlockStarts) {
            if (!(block instanceof DeoptBciBlock)) continue;
            this.addExceptionHandlerEdge((DeoptBciBlock)block);
        }
        return requestedBlockStarts;
    }

    protected BciBlockMapping.BciBlock processNewBciBlock(int bci, BciBlockMapping.BciBlock newBlock) {
        if (this.needsDeoptEntryBlock(bci, false, false)) {
            DeoptBciBlock deoptBciBlock = DeoptBciBlock.createDeoptEntry(bci);
            this.recordInsertedBlock(deoptBciBlock);
            deoptBciBlock.addSuccessor(newBlock);
            this.addExceptionHandlerEdge(deoptBciBlock);
            this.blockMap[bci] = deoptBciBlock;
            return deoptBciBlock;
        }
        return newBlock;
    }

    protected BciBlockMapping.ExceptionDispatchBlock processNewExceptionDispatchBlock(int bci, boolean isInvoke, BciBlockMapping.ExceptionDispatchBlock handler) {
        boolean isExplictDeoptEntry = this.needsDeoptEntryBlock(bci, false, true);
        if (isExplictDeoptEntry || isInvoke && this.needsDeoptEntryBlock(bci, true, false)) {
            DeoptExceptionDispatchBlock block;
            boolean isProxy;
            boolean bl = isProxy = !isExplictDeoptEntry;
            if (handler == null) {
                block = new DeoptExceptionDispatchBlock(bci, isProxy);
            } else {
                block = new DeoptExceptionDispatchBlock(handler, bci, isProxy);
                block.addSuccessor((BciBlockMapping.BciBlock)handler);
            }
            this.recordInsertedBlock(block);
            return block;
        }
        return handler;
    }

    protected boolean verify() {
        HashSet<Long> coveredEncodedBcis = new HashSet<Long>();
        for (DeoptEntryInsertionPoint deopt : this.insertedBlocks) {
            BciBlockMapping.BciBlock block = deopt.asBlock();
            int bci = deopt.deoptEntryBci();
            boolean duringCall = deopt.duringCall();
            boolean rethrowException = deopt.rethrowException();
            if (block.getId() < 0) {
                assert (!((HostedMethod)this.code.getMethod()).compilationInfo.isRegisteredDeoptEntry(bci, duringCall, rethrowException));
                continue;
            }
            assert (this.needsDeoptEntryBlock(bci, duringCall, rethrowException));
            assert (deopt.isProxy() == duringCall) : "deopt proxy nodes always represent implicit deopt entries from invokes.";
            if (!deopt.isProxy()) assert (coveredEncodedBcis.add(FrameInfoEncoder.encodeBci(bci, duringCall, rethrowException))) : "Deoptimization entry points must be unique.";
            assert (block.getSuccessorCount() <= 2) : "DeoptEntryInsertionPoint must have at most 2 successors";
            for (BciBlockMapping.BciBlock sux : block.getSuccessors()) {
                assert (!(sux instanceof DeoptEntryInsertionPoint)) : "Successor of DeoptEntryInsertionPoint should not be a DeoptEntryInsertionPoint.";
            }
            assert (!block.isDuplicate()) : "DeoptEntryInsertionPoint must be unique";
        }
        return super.verify();
    }

    static class DeoptExceptionDispatchBlock
    extends BciBlockMapping.ExceptionDispatchBlock
    implements DeoptEntryInsertionPoint {
        public final boolean isProxy;

        DeoptExceptionDispatchBlock(int bci, boolean isProxy) {
            super(bci);
            this.isProxy = isProxy;
        }

        DeoptExceptionDispatchBlock(BciBlockMapping.ExceptionDispatchBlock dispatch, int bci, boolean isProxy) {
            super(dispatch.handler, bci);
            this.isProxy = isProxy;
        }

        @Override
        public int deoptEntryBci() {
            return this.deoptBci;
        }

        @Override
        public int frameStateBci() {
            return this.deoptBci;
        }

        @Override
        public boolean duringCall() {
            return this.isProxy;
        }

        @Override
        public boolean rethrowException() {
            return !this.isProxy;
        }

        @Override
        public boolean isProxy() {
            return this.isProxy;
        }

        @Override
        public BciBlockMapping.BciBlock asBlock() {
            return this;
        }

        public String toString() {
            return super.toString() + " (DeoptExceptionDispatchBlock)";
        }
    }

    static final class DeoptBciBlock
    extends BciBlockMapping.BciBlock
    implements DeoptEntryInsertionPoint {
        public final int deoptEntryBci;
        public final boolean isProxy;

        private DeoptBciBlock(int startBci, int deoptEntryBci, boolean isProxy) {
            super(startBci, startBci);
            this.deoptEntryBci = deoptEntryBci;
            this.isProxy = isProxy;
        }

        static DeoptBciBlock createDeoptEntry(int bci) {
            return new DeoptBciBlock(bci, bci, false);
        }

        static DeoptBciBlock createDeoptProxy(int successorBci, int deoptBci) {
            return new DeoptBciBlock(successorBci, deoptBci, true);
        }

        public void setEndBci(int bci) {
            throw GraalError.shouldNotReachHere();
        }

        public boolean isInstructionBlock() {
            return false;
        }

        @Override
        public int deoptEntryBci() {
            return this.deoptEntryBci;
        }

        @Override
        public int frameStateBci() {
            return this.getStartBci();
        }

        @Override
        public boolean duringCall() {
            return this.isProxy;
        }

        @Override
        public boolean rethrowException() {
            return false;
        }

        @Override
        public boolean isProxy() {
            return this.isProxy;
        }

        @Override
        public BciBlockMapping.BciBlock asBlock() {
            return this;
        }

        public String toString() {
            return super.toString() + " (DeoptBciBlock)";
        }
    }

    static interface DeoptEntryInsertionPoint {
        public int deoptEntryBci();

        public boolean duringCall();

        public boolean rethrowException();

        public int frameStateBci();

        public boolean isProxy();

        public BciBlockMapping.BciBlock asBlock();
    }
}

