/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.CErrorNumber;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.CConst;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.PosixDirectives;
import com.oracle.svm.core.posix.headers.darwin.DarwinStat;
import com.oracle.svm.core.posix.headers.linux.LinuxStat;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@CContext(value=PosixDirectives.class)
public final class PosixStat {
    @CConstant
    public static native int S_IFLNK();

    @CConstant
    public static native int S_IFDIR();

    @CConstant
    public static native int S_IRUSR();

    @CConstant
    public static native int S_IRGRP();

    @CConstant
    public static native int S_IROTH();

    @CConstant
    public static native int S_IWUSR();

    @CConstant
    public static native int S_IWGRP();

    @CConstant
    public static native int S_IWOTH();

    @CConstant
    public static native int S_IRWXU();

    @CConstant
    public static native int S_IXGRP();

    @CConstant
    public static native int S_IXOTH();

    public static boolean isOpen(int fd) {
        int result;
        if (Platform.includedIn(Platform.LINUX.class)) {
            LinuxStat.stat64 stat2 = (LinuxStat.stat64)StackValue.get(LinuxStat.stat64.class);
            result = LinuxStat.NoTransitions.fstat64(fd, stat2);
        } else if (Platform.includedIn(Platform.DARWIN.class)) {
            DarwinStat.stat stat3 = (DarwinStat.stat)StackValue.get(DarwinStat.stat.class);
            result = DarwinStat.NoTransitions.fstat(fd, stat3);
        } else {
            throw VMError.shouldNotReachHere("Unsupported platform");
        }
        return result == 0 || CErrorNumber.getCErrorNumber() != Errno.EBADF();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static SignedWord getSize(int fd) {
        long size = -1L;
        if (Platform.includedIn(Platform.LINUX.class)) {
            LinuxStat.stat64 stat2 = (LinuxStat.stat64)StackValue.get(LinuxStat.stat64.class);
            if (LinuxStat.NoTransitions.fstat64(fd, stat2) == 0) {
                size = stat2.st_size();
            }
        } else if (Platform.includedIn(Platform.DARWIN.class)) {
            DarwinStat.stat stat3 = (DarwinStat.stat)StackValue.get(DarwinStat.stat.class);
            if (DarwinStat.NoTransitions.fstat(fd, stat3) == 0) {
                size = stat3.st_size();
            }
        } else {
            throw VMError.shouldNotReachHere("Unsupported platform");
        }
        return WordFactory.signed((long)size);
    }

    @Fold
    public static int sizeOfStatStruct() {
        if (Platform.includedIn(Platform.LINUX.class)) {
            return SizeOf.get(LinuxStat.stat64.class);
        }
        if (Platform.includedIn(Platform.DARWIN.class)) {
            return SizeOf.get(DarwinStat.stat.class);
        }
        throw VMError.shouldNotReachHere("Unsupported platform");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static int st_uid(stat buf) {
        if (Platform.includedIn(Platform.LINUX.class)) {
            return ((LinuxStat.stat64)((Object)buf)).st_uid();
        }
        if (Platform.includedIn(Platform.DARWIN.class)) {
            return ((DarwinStat.stat)((Object)buf)).st_uid();
        }
        throw VMError.shouldNotReachHere("Unsupported platform");
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean S_ISLNK(stat buf) {
        return PosixStat.st_mode(buf).and(PosixStat.S_IFLNK()).equal(PosixStat.S_IFLNK());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean S_ISDIR(stat buf) {
        return PosixStat.st_mode(buf).and(PosixStat.S_IFDIR()).equal(PosixStat.S_IFDIR());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord st_mode(stat buf) {
        if (Platform.includedIn(Platform.LINUX.class)) {
            return ((LinuxStat.stat64)((Object)buf)).st_mode();
        }
        if (Platform.includedIn(Platform.DARWIN.class)) {
            return ((DarwinStat.stat)((Object)buf)).st_mode();
        }
        throw VMError.shouldNotReachHere("Unsupported platform");
    }

    public static UnsignedWord st_nlink(stat buf) {
        if (Platform.includedIn(Platform.LINUX.class)) {
            return ((LinuxStat.stat64)((Object)buf)).st_nlink();
        }
        if (Platform.includedIn(Platform.DARWIN.class)) {
            return ((DarwinStat.stat)((Object)buf)).st_nlink();
        }
        throw VMError.shouldNotReachHere("Unsupported platform");
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private PosixStat() {
    }

    public static class NoTransitions {
        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int mkdir(@CConst CCharPointer var0, int var1);

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int fstat(int fd, stat buf) {
            if (Platform.includedIn(Platform.LINUX.class)) {
                return LinuxStat.NoTransitions.fstat64(fd, (LinuxStat.stat64)((Object)buf));
            }
            if (Platform.includedIn(Platform.DARWIN.class)) {
                return DarwinStat.NoTransitions.fstat(fd, (DarwinStat.stat)((Object)buf));
            }
            throw VMError.shouldNotReachHere("Unsupported platform");
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int lstat(CCharPointer path, stat buf) {
            if (Platform.includedIn(Platform.LINUX.class)) {
                return LinuxStat.NoTransitions.lstat64(path, (LinuxStat.stat64)((Object)buf));
            }
            if (Platform.includedIn(Platform.DARWIN.class)) {
                return DarwinStat.NoTransitions.lstat(path, (DarwinStat.stat)((Object)buf));
            }
            throw VMError.shouldNotReachHere("Unsupported platform");
        }
    }

    public static interface stat
    extends WordBase {
    }
}

