/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.windows.headers.Process;
import com.oracle.svm.core.windows.headers.WinBase;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.WINDOWS.class})
public final class WindowsJavaThreads
extends JavaThreads {
    private static final CEntryPointLiteral<CFunctionPointer> osThreadStartRoutine = CEntryPointLiteral.create(WindowsJavaThreads.class, (String)"osThreadStartRoutine", (Class[])new Class[]{WindowsThreadStartData.class});

    @Platforms(value={Platform.HOSTED_ONLY.class})
    WindowsJavaThreads() {
    }

    @Override
    protected void doStartThread(Thread thread, long stackSize) {
        int threadStackSize = (int)stackSize;
        int initFlag = Process.CREATE_SUSPENDED();
        WindowsThreadStartData startData = (WindowsThreadStartData)UnmanagedMemory.malloc((int)SizeOf.get(WindowsThreadStartData.class));
        this.prepareStartData(thread, startData);
        if (threadStackSize != 0) {
            initFlag |= Process.STACK_SIZE_PARAM_IS_A_RESERVATION();
        }
        CIntPointer osThreadID = (CIntPointer)StackValue.get(CIntPointer.class);
        WinBase.HANDLE osThreadHandle = Process._beginthreadex(WordFactory.nullPointer(), threadStackSize, (PointerBase)osThreadStartRoutine.getFunctionPointer(), (WordBase)startData, initFlag, osThreadID);
        VMError.guarantee(osThreadHandle.rawValue() != 0L, "Could not create thread");
        startData.setOSThreadHandle(osThreadHandle);
        Process.ResumeThread(osThreadHandle);
    }

    @Override
    protected void setNativeName(Thread thread, String name) {
    }

    @Override
    protected void yield() {
        Process.SwitchToThread();
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=OSThreadStartRoutinePrologue.class, epilogue=CEntryPointSetup.LeaveDetachThreadEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    static WordBase osThreadStartRoutine(WindowsThreadStartData data) {
        ObjectHandle threadHandle = data.getThreadHandle();
        WinBase.HANDLE osThreadHandle = data.getOSThreadHandle();
        UnmanagedMemory.free((PointerBase)data);
        try {
            WindowsJavaThreads.threadStartRoutine(threadHandle);
        }
        finally {
            WinBase.CloseHandle(osThreadHandle);
        }
        return WordFactory.nullPointer();
    }

    private static class OSThreadStartRoutinePrologue {
        private static final CGlobalData<CCharPointer> errorMessage = CGlobalDataFactory.createCString("Failed to attach a newly launched thread.");

        private OSThreadStartRoutinePrologue() {
        }

        static void enter(WindowsThreadStartData data) {
            int code = CEntryPointActions.enterAttachThread(data.getIsolate(), false);
            if (code != 0) {
                CEntryPointActions.failFatally(code, errorMessage.get());
            }
        }
    }

    @RawStructure
    static interface WindowsThreadStartData
    extends JavaThreads.ThreadStartData {
        @RawField
        public WinBase.HANDLE getOSThreadHandle();

        @RawField
        public void setOSThreadHandle(WinBase.HANDLE var1);
    }
}

