/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.identityhashcode;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.identityhashcode.IdentityHashCodeSupport;
import com.oracle.svm.core.snippets.SnippetRuntime;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.replacements.IdentityHashCodeSnippets;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.word.LocationIdentity;

final class SubstrateIdentityHashCodeSnippets
extends IdentityHashCodeSnippets {
    static final SnippetRuntime.SubstrateForeignCallDescriptor GENERATE_IDENTITY_HASH_CODE = SnippetRuntime.findForeignCall(IdentityHashCodeSupport.class, "generateIdentityHashCode", true, IdentityHashCodeSupport.IDENTITY_HASHCODE_LOCATION);

    SubstrateIdentityHashCodeSnippets() {
    }

    protected int computeIdentityHashCode(Object obj) {
        int identityHashCode = ObjectAccess.readInt((Object)obj, (int)ConfigurationValues.getObjectLayout().getIdentityHashCodeOffset(), (LocationIdentity)IdentityHashCodeSupport.IDENTITY_HASHCODE_LOCATION);
        if (BranchProbabilityNode.probability((double)0.99, (identityHashCode != 0 ? 1 : 0) != 0)) {
            return identityHashCode;
        }
        return SubstrateIdentityHashCodeSnippets.generateIdentityHashCode(GENERATE_IDENTITY_HASH_CODE, obj);
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native int generateIdentityHashCode(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1);
}

