/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.methodhandles;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.invoke.MethodHandleUtils;
import com.oracle.svm.core.invoke.Target_java_lang_invoke_MemberName;
import com.oracle.svm.core.jdk.JDK11_0_10OrEarlier;
import com.oracle.svm.core.jdk.JDK11_0_11OrLater;
import com.oracle.svm.core.jdk.JDK15OrLater;
import com.oracle.svm.core.jdk.Target_java_lang_Module;
import com.oracle.svm.core.util.VMError;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;

@TargetClass(value=MethodHandles.class, innerClass={"Lookup"}, onlyWith={MethodHandleUtils.MethodHandlesSupported.class})
final class Target_java_lang_invoke_MethodHandles_Lookup {
    @Alias
    @TargetElement(onlyWith={JDK15OrLater.class})
    private Class<?> lookupClass;
    @Alias
    @TargetElement(onlyWith={JDK15OrLater.class})
    private Class<?> prevLookupClass;
    @Alias
    @TargetElement(onlyWith={JDK15OrLater.class})
    private int allowedModes;

    Target_java_lang_invoke_MethodHandles_Lookup() {
    }

    @Substitute
    public Class<?> defineClass(byte[] bytes) {
        throw VMError.unimplemented("Defining new classes at runtime is not supported");
    }

    @Substitute
    @TargetElement(onlyWith={JDK11_0_10OrEarlier.class})
    private MethodHandle maybeBindCaller(Target_java_lang_invoke_MemberName method, MethodHandle mh, Class<?> boundCallerClass) throws IllegalAccessException {
        return mh;
    }

    @Substitute
    @TargetElement(onlyWith={JDK11_0_11OrLater.class})
    private MethodHandle maybeBindCaller(Target_java_lang_invoke_MemberName method, MethodHandle mh, Target_java_lang_invoke_MethodHandles_Lookup boundCaller) throws IllegalAccessException {
        return mh;
    }

    @Substitute
    @TargetElement(onlyWith={JDK15OrLater.class})
    private IllegalAccessException makeAccessException(Class<?> targetClass) {
        String message = "access violation: " + targetClass;
        if (this == SubstrateUtil.cast(MethodHandles.publicLookup(), Target_java_lang_invoke_MethodHandles_Lookup.class)) {
            message = message + ", from public Lookup";
        } else {
            Target_java_lang_Module m = SubstrateUtil.cast(this.lookupClass, DynamicHub.class).getModule();
            message = message + ", from " + this.lookupClass + " (" + m + ")";
            if (this.prevLookupClass != null) {
                message = message + ", previous lookup " + this.prevLookupClass.getName() + " (" + SubstrateUtil.cast(this.prevLookupClass, DynamicHub.class).getModule() + ")";
            }
        }
        return new IllegalAccessException(message);
    }

    @Substitute
    @TargetElement(onlyWith={JDK15OrLater.class})
    void checkSecurityManager(Class<?> refc) {
    }
}

