/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapParameters;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.word.UnsignedWord;

public final class HeapPolicy {
    public static UnsignedWord getMaximumHeapSize() {
        return GCImpl.getPolicy().getMaximumHeapSize();
    }

    public static UnsignedWord getMinimumHeapSize() {
        return GCImpl.getPolicy().getMinimumHeapSize();
    }

    public static void setMaximumHeapSize(UnsignedWord value) {
        HeapParameters.setMaximumHeapSize(value);
    }

    public static void setMinimumHeapSize(UnsignedWord value) {
        HeapParameters.setMinimumHeapSize(value);
    }

    @Fold
    public static UnsignedWord getAlignedHeapChunkSize() {
        return HeapParameters.getAlignedHeapChunkSize();
    }

    @Fold
    public static UnsignedWord getLargeArrayThreshold() {
        return HeapParameters.getLargeArrayThreshold();
    }

    private HeapPolicy() {
    }
}

