/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.genscavenge.AbstractCollectionPolicy;
import com.oracle.svm.core.genscavenge.AdaptivePaddedAverage;
import com.oracle.svm.core.genscavenge.AdaptiveWeightedAverage;
import com.oracle.svm.core.genscavenge.CollectionPolicy;
import com.oracle.svm.core.genscavenge.GCAccounting;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.GenScavengeGCCause;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.ReciprocalLeastSquareFit;
import com.oracle.svm.core.genscavenge.Timer;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

final class AdaptiveCollectionPolicy
extends AbstractCollectionPolicy {
    private static final int ADAPTIVE_TIME_WEIGHT = 25;
    private static final int ADAPTIVE_SIZE_POLICY_READY_THRESHOLD = 5;
    private static final int ADAPTIVE_SIZE_DECREMENT_SCALE_FACTOR = 4;
    private static final int ADAPTIVE_SIZE_POLICY_WEIGHT = 10;
    private static final boolean USE_ADAPTIVE_SIZE_POLICY_WITH_SYSTEM_GC = false;
    private static final boolean USE_ADAPTIVE_SIZE_DECAY_MAJOR_GC_COST = true;
    private static final double ADAPTIVE_SIZE_MAJOR_GC_DECAY_TIME_SCALE = 10.0;
    private static final boolean USE_ADAPTIVE_SIZE_POLICY_FOOTPRINT_GOAL = true;
    private static final int THRESHOLD_TOLERANCE = 10;
    private static final int SURVIVOR_PADDING = 3;
    private static final int INITIAL_TENURING_THRESHOLD = 7;
    private static final int PROMOTED_PADDING = 3;
    private static final int TENURED_GENERATION_SIZE_SUPPLEMENT_DECAY = 2;
    private static final int YOUNG_GENERATION_SIZE_SUPPLEMENT_DECAY = 8;
    private static final int PAUSE_PADDING = 1;
    private static final int GC_TIME_RATIO = 19;
    private static final int YOUNG_GENERATION_SIZE_INCREMENT = 10;
    private static final int TENURED_GENERATION_SIZE_INCREMENT = 10;
    private static final int YOUNG_GENERATION_SIZE_SUPPLEMENT = 0;
    private static final int TENURED_GENERATION_SIZE_SUPPLEMENT = 0;
    private static final boolean ADAPTIVE_SIZE_USE_COST_ESTIMATORS = true;
    private static final int ADAPTIVE_SIZE_POLICY_INITIALIZING_STEPS = 5;
    private static final double ADAPTIVE_SIZE_ESTIMATOR_MIN_SIZE_COST_TRADEOFF = 0.5;
    private static final int ADAPTIVE_SIZE_COST_ESTIMATORS_HISTORY_LENGTH = 12;
    private static final int CONSECUTIVE_MINOR_TO_MAJOR_COLLECTION_PAUSE_TIME_RATIO = 2;
    private static final double ADAPTIVE_SIZE_COST_ESTIMATOR_GC_COST_LIMIT = 0.5;
    private static final double THROUGHPUT_GOAL = 0.95;
    private static final double THRESHOLD_TOLERANCE_PERCENT = 1.1;
    private final Timer minorTimer = new Timer("minor/between minor");
    private final AdaptiveWeightedAverage avgMinorGcCost = new AdaptiveWeightedAverage(25);
    private final AdaptivePaddedAverage avgMinorPause = new AdaptivePaddedAverage(25, 1);
    private final AdaptivePaddedAverage avgSurvived = new AdaptivePaddedAverage(10, 3);
    private final AdaptivePaddedAverage avgPromoted = new AdaptivePaddedAverage(10, 3, true);
    private final ReciprocalLeastSquareFit minorCostEstimator = new ReciprocalLeastSquareFit(12);
    private long minorCount;
    private long latestMinorMutatorIntervalNanos;
    private boolean youngGenPolicyIsReady;
    private UnsignedWord youngGenSizeIncrementSupplement = WordFactory.unsigned((int)0);
    private long youngGenChangeForMinorThroughput;
    private int minorCountSinceMajorCollection;
    private final Timer majorTimer = new Timer("major/between major");
    private final AdaptiveWeightedAverage avgMajorGcCost = new AdaptiveWeightedAverage(25);
    private final AdaptivePaddedAverage avgMajorPause = new AdaptivePaddedAverage(25, 1);
    private final AdaptiveWeightedAverage avgMajorIntervalSeconds = new AdaptiveWeightedAverage(25);
    private final AdaptiveWeightedAverage avgOldLive = new AdaptiveWeightedAverage(10);
    private final ReciprocalLeastSquareFit majorCostEstimator = new ReciprocalLeastSquareFit(12);
    private long majorCount;
    private UnsignedWord oldGenSizeIncrementSupplement = WordFactory.unsigned((int)0);
    private long latestMajorMutatorIntervalNanos;
    private boolean oldSizeExceededInPreviousCollection;
    private long oldGenChangeForMajorThroughput;

    AdaptiveCollectionPolicy() {
        super(7);
    }

    @Override
    public String getName() {
        return "adaptive";
    }

    @Override
    public boolean shouldCollectCompletely(boolean followingIncrementalCollection) {
        this.guaranteeSizeParametersInitialized();
        if (!followingIncrementalCollection && CollectionPolicy.shouldCollectYoungGenSeparately(true)) {
            return false;
        }
        if (followingIncrementalCollection && this.oldSizeExceededInPreviousCollection) {
            return true;
        }
        if ((double)this.minorCountSinceMajorCollection * this.avgMinorPause.getAverage() >= 2.0 * this.avgMajorPause.getPaddedAverage()) {
            return true;
        }
        UnsignedWord youngUsed = HeapImpl.getHeapImpl().getYoungGeneration().getChunkBytes();
        UnsignedWord oldUsed = HeapImpl.getHeapImpl().getOldGeneration().getChunkBytes();
        UnsignedWord averagePromoted = UnsignedUtils.fromDouble(this.avgPromoted.getPaddedAverage());
        UnsignedWord promotionEstimate = UnsignedUtils.min(averagePromoted, youngUsed);
        UnsignedWord oldFree = this.oldSize.subtract(oldUsed);
        return promotionEstimate.aboveThan(oldFree);
    }

    private void updateAverages(UnsignedWord survivedChunkBytes, UnsignedWord survivorOverflowObjectBytes, UnsignedWord promotedObjectBytes) {
        this.avgSurvived.sample(survivedChunkBytes.add(survivorOverflowObjectBytes));
        this.avgPromoted.sample(promotedObjectBytes);
    }

    private void computeSurvivorSpaceSizeAndThreshold(boolean isSurvivorOverflow, UnsignedWord survivorLimit) {
        if (!this.youngGenPolicyIsReady) {
            return;
        }
        boolean incrTenuringThreshold = false;
        boolean decrTenuringThreshold = false;
        if (!isSurvivorOverflow) {
            if (this.minorGcCost() > this.majorGcCost() * 1.1) {
                decrTenuringThreshold = true;
            } else if (this.majorGcCost() > this.minorGcCost() * 1.1) {
                incrTenuringThreshold = true;
            }
        } else {
            decrTenuringThreshold = true;
        }
        UnsignedWord targetSize = AdaptiveCollectionPolicy.minSpaceSize(AdaptiveCollectionPolicy.alignUp(UnsignedUtils.fromDouble(this.avgSurvived.getPaddedAverage())));
        if (targetSize.aboveThan(survivorLimit)) {
            targetSize = survivorLimit;
            decrTenuringThreshold = true;
        }
        this.survivorSize = targetSize;
        if (decrTenuringThreshold) {
            this.tenuringThreshold = Math.max(this.tenuringThreshold - 1, 1);
        } else if (incrTenuringThreshold) {
            this.tenuringThreshold = Math.min(this.tenuringThreshold + 1, HeapParameters.getMaxSurvivorSpaces() + 1);
        }
    }

    private void computeEdenSpaceSize() {
        UnsignedWord edenLimit;
        boolean expansionReducesCost = true;
        if (AdaptiveCollectionPolicy.shouldUseEstimator(this.youngGenChangeForMinorThroughput, this.minorGcCost())) {
            expansionReducesCost = AdaptiveCollectionPolicy.expansionSignificantlyReducesCost(this.minorCostEstimator, this.edenSize);
        }
        UnsignedWord desiredEdenSize = this.edenSize;
        if (expansionReducesCost && this.adjustedMutatorCost() < 0.95 && this.gcCost() > 0.0) {
            UnsignedWord edenHeapDelta = this.edenIncrementWithSupplementAlignedUp(this.edenSize);
            double scaleByRatio = this.minorGcCost() / this.gcCost();
            assert (scaleByRatio >= 0.0 && scaleByRatio <= 1.0);
            UnsignedWord scaledEdenHeapDelta = UnsignedUtils.fromDouble(scaleByRatio * UnsignedUtils.toDouble(edenHeapDelta));
            desiredEdenSize = AdaptiveCollectionPolicy.alignUp(desiredEdenSize.add(scaledEdenHeapDelta));
            desiredEdenSize = UnsignedUtils.max(desiredEdenSize, this.edenSize);
            ++this.youngGenChangeForMinorThroughput;
        }
        if (!expansionReducesCost || this.youngGenPolicyIsReady && this.adjustedMutatorCost() >= 0.95) {
            UnsignedWord desiredSum = this.edenSize.add(this.promoSize);
            desiredEdenSize = AdaptiveCollectionPolicy.adjustEdenForFootprint(this.edenSize, desiredSum);
        }
        assert (AdaptiveCollectionPolicy.isAligned(desiredEdenSize));
        if ((desiredEdenSize = AdaptiveCollectionPolicy.minSpaceSize(desiredEdenSize)).aboveThan(edenLimit = this.maxEdenSize())) {
            desiredEdenSize = UnsignedUtils.max(edenLimit, this.edenSize);
        }
        this.edenSize = desiredEdenSize;
    }

    private static boolean shouldUseEstimator(long genChangeForThroughput, double cost) {
        return genChangeForThroughput > 5L && cost <= 0.5;
    }

    private static boolean expansionSignificantlyReducesCost(ReciprocalLeastSquareFit estimator, UnsignedWord size) {
        double x0 = UnsignedUtils.toDouble(size);
        double deltax = 0.010000000000000009 * x0;
        if (deltax == 0.0) {
            return false;
        }
        double y0 = estimator.estimate(x0);
        double y1 = y0 * 0.995;
        double minSlope = (y1 - y0) / deltax;
        double estimatedSlope = estimator.getSlope(x0);
        return estimatedSlope <= minSlope;
    }

    private static UnsignedWord adjustEdenForFootprint(UnsignedWord curEden, UnsignedWord desiredSum) {
        assert (curEden.belowOrEqual(desiredSum));
        UnsignedWord change = AdaptiveCollectionPolicy.edenDecrement(curEden);
        change = AdaptiveCollectionPolicy.scaleDown(change, curEden, desiredSum);
        UnsignedWord reducedSize = curEden.subtract(change);
        assert (reducedSize.belowOrEqual(curEden));
        return AdaptiveCollectionPolicy.alignDown(reducedSize);
    }

    private static UnsignedWord scaleDown(UnsignedWord change, UnsignedWord part, UnsignedWord total) {
        assert (part.belowOrEqual(total));
        UnsignedWord reducedChange = change;
        if (total.aboveThan(0)) {
            double fraction = UnsignedUtils.toDouble(part) / UnsignedUtils.toDouble(total);
            reducedChange = UnsignedUtils.fromDouble(fraction * UnsignedUtils.toDouble(change));
        }
        assert (reducedChange.belowOrEqual(change));
        return reducedChange;
    }

    private static UnsignedWord edenDecrement(UnsignedWord curEden) {
        return AdaptiveCollectionPolicy.spaceIncrement(curEden, WordFactory.unsigned((int)10)).unsignedDivide(4);
    }

    private double adjustedMutatorCost() {
        double cost = 1.0 - this.decayingGcCost();
        assert (cost >= 0.0);
        return cost;
    }

    private double decayingGcCost() {
        double secondsSinceMajor;
        double decayedMajorGcCost = this.majorGcCost();
        double avgMajorInterval = this.avgMajorIntervalSeconds.getAverage();
        if (avgMajorInterval > 0.0 && (secondsSinceMajor = this.secondsSinceMajorGc()) > 0.0 && secondsSinceMajor > 10.0 * avgMajorInterval) {
            double decayed = decayedMajorGcCost * (10.0 * avgMajorInterval) / secondsSinceMajor;
            decayedMajorGcCost = Math.min(decayedMajorGcCost, decayed);
        }
        return Math.min(1.0, decayedMajorGcCost + this.minorGcCost());
    }

    private double minorGcCost() {
        return Math.max(0.0, this.avgMinorGcCost.getAverage());
    }

    private double majorGcCost() {
        return Math.max(0.0, this.avgMajorGcCost.getAverage());
    }

    private double gcCost() {
        double cost = Math.min(1.0, this.minorGcCost() + this.majorGcCost());
        assert (cost >= 0.0) : "Both minor and major costs are non-negative";
        return cost;
    }

    private UnsignedWord edenIncrementWithSupplementAlignedUp(UnsignedWord curEden) {
        return AdaptiveCollectionPolicy.alignUp(AdaptiveCollectionPolicy.spaceIncrement(curEden, this.youngGenSizeIncrementSupplement.add(10)));
    }

    private static UnsignedWord spaceIncrement(UnsignedWord curSize, UnsignedWord percentChange) {
        return curSize.unsignedDivide(100).multiply(percentChange);
    }

    private double secondsSinceMajorGc() {
        return TimeUtils.nanosToSecondsDouble(System.nanoTime() - this.majorTimer.getOpenedTime());
    }

    @Override
    public void onCollectionBegin(boolean completeCollection, long requestingNanoTime) {
        Timer timer = completeCollection ? this.majorTimer : this.minorTimer;
        timer.closeAt(requestingNanoTime);
        if (completeCollection) {
            this.latestMajorMutatorIntervalNanos = timer.getMeasuredNanos();
        } else {
            this.latestMinorMutatorIntervalNanos = timer.getMeasuredNanos();
        }
        UnsignedWord youngChunkBytes = GCImpl.getGCImpl().getAccounting().getYoungChunkBytesBefore();
        if (youngChunkBytes.notEqual(0)) {
            UnsignedWord youngAlignedChunkBytes = HeapImpl.getHeapImpl().getYoungGeneration().getAlignedChunkBytes();
            this.avgYoungGenAlignedChunkFraction.sample(UnsignedUtils.toDouble(youngAlignedChunkBytes) / UnsignedUtils.toDouble(youngChunkBytes));
        }
        timer.reset();
        timer.open();
    }

    @Override
    public void onCollectionEnd(boolean completeCollection, GCCause cause) {
        Timer timer = completeCollection ? this.majorTimer : this.minorTimer;
        timer.close();
        if (completeCollection) {
            AdaptiveCollectionPolicy.updateCollectionEndAverages(this.avgMajorGcCost, this.avgMajorPause, this.majorCostEstimator, this.avgMajorIntervalSeconds, cause, this.latestMajorMutatorIntervalNanos, timer.getMeasuredNanos(), this.promoSize);
            ++this.majorCount;
            this.minorCountSinceMajorCollection = 0;
        } else {
            AdaptiveCollectionPolicy.updateCollectionEndAverages(this.avgMinorGcCost, this.avgMinorPause, this.minorCostEstimator, null, cause, this.latestMinorMutatorIntervalNanos, timer.getMeasuredNanos(), this.edenSize);
            ++this.minorCount;
            ++this.minorCountSinceMajorCollection;
            if (this.minorCount >= 5L) {
                this.youngGenPolicyIsReady = true;
            }
        }
        timer.reset();
        timer.open();
        GCAccounting accounting = GCImpl.getGCImpl().getAccounting();
        UnsignedWord oldLive = accounting.getOldGenerationAfterChunkBytes();
        this.oldSizeExceededInPreviousCollection = oldLive.aboveThan(this.oldSize);
        UnsignedWord survivedChunkBytes = HeapImpl.getHeapImpl().getYoungGeneration().getSurvivorChunkBytes();
        UnsignedWord survivorOverflowObjectBytes = accounting.getSurvivorOverflowObjectBytes();
        UnsignedWord tenuredObjBytes = accounting.getTenuredObjectBytes();
        this.updateAverages(survivedChunkBytes, survivorOverflowObjectBytes, tenuredObjBytes);
        this.computeSurvivorSpaceSizeAndThreshold(survivorOverflowObjectBytes.aboveThan(0), this.sizes.maxSurvivorSize());
        this.computeEdenSpaceSize();
        if (completeCollection) {
            this.computeOldGenSpaceSize(oldLive);
        }
        this.decaySupplementalGrowth(completeCollection);
    }

    private void computeOldGenSpaceSize(UnsignedWord oldLive) {
        this.avgOldLive.sample(oldLive);
        UnsignedWord promoLimit = UnsignedUtils.fromDouble(UnsignedUtils.toDouble(this.sizes.maxOldSize()) - this.avgOldLive.getAverage());
        promoLimit = AdaptiveCollectionPolicy.alignDown(UnsignedUtils.max(this.promoSize, promoLimit));
        boolean expansionReducesCost = true;
        if (AdaptiveCollectionPolicy.shouldUseEstimator(this.oldGenChangeForMajorThroughput, this.majorGcCost())) {
            expansionReducesCost = AdaptiveCollectionPolicy.expansionSignificantlyReducesCost(this.majorCostEstimator, this.promoSize);
        }
        UnsignedWord desiredPromoSize = this.promoSize;
        if (expansionReducesCost && this.adjustedMutatorCost() < 0.95 && this.gcCost() > 0.0) {
            UnsignedWord promoHeapDelta = this.promoIncrementWithSupplementAlignedUp(this.promoSize);
            double scaleByRatio = this.majorGcCost() / this.gcCost();
            assert (scaleByRatio >= 0.0 && scaleByRatio <= 1.0);
            UnsignedWord scaledPromoHeapDelta = UnsignedUtils.fromDouble(scaleByRatio * UnsignedUtils.toDouble(promoHeapDelta));
            desiredPromoSize = AdaptiveCollectionPolicy.alignUp(this.promoSize.add(scaledPromoHeapDelta));
            desiredPromoSize = UnsignedUtils.max(desiredPromoSize, this.promoSize);
            ++this.oldGenChangeForMajorThroughput;
        }
        if (!expansionReducesCost || this.youngGenPolicyIsReady && this.adjustedMutatorCost() >= 0.95) {
            UnsignedWord desiredSum = this.edenSize.add(this.promoSize);
            desiredPromoSize = AdaptiveCollectionPolicy.adjustPromoForFootprint(this.promoSize, desiredSum);
        }
        assert (AdaptiveCollectionPolicy.isAligned(desiredPromoSize));
        desiredPromoSize = AdaptiveCollectionPolicy.minSpaceSize(desiredPromoSize);
        this.promoSize = desiredPromoSize = UnsignedUtils.min(desiredPromoSize, promoLimit);
        UnsignedWord desiredFreeSpace = this.calculatedOldFreeSizeInBytes();
        UnsignedWord desiredOldSize = AdaptiveCollectionPolicy.alignUp(oldLive.add(desiredFreeSpace));
        this.oldSize = UnsignedUtils.clamp(desiredOldSize, AdaptiveCollectionPolicy.minSpaceSize(), this.sizes.maxOldSize());
    }

    UnsignedWord calculatedOldFreeSizeInBytes() {
        return UnsignedUtils.fromDouble(UnsignedUtils.toDouble(this.promoSize) + this.avgPromoted.getPaddedAverage());
    }

    private static UnsignedWord adjustPromoForFootprint(UnsignedWord curPromo, UnsignedWord desiredSum) {
        assert (curPromo.belowOrEqual(desiredSum));
        UnsignedWord change = AdaptiveCollectionPolicy.promoDecrement(curPromo);
        change = AdaptiveCollectionPolicy.scaleDown(change, curPromo, desiredSum);
        UnsignedWord reducedSize = curPromo.subtract(change);
        assert (reducedSize.belowOrEqual(curPromo));
        return AdaptiveCollectionPolicy.alignDown(reducedSize);
    }

    private static UnsignedWord promoDecrement(UnsignedWord curPromo) {
        return AdaptiveCollectionPolicy.promoIncrement(curPromo).unsignedDivide(4);
    }

    private static UnsignedWord promoIncrement(UnsignedWord curPromo) {
        return AdaptiveCollectionPolicy.spaceIncrement(curPromo, WordFactory.unsigned((int)10));
    }

    private UnsignedWord promoIncrementWithSupplementAlignedUp(UnsignedWord curPromo) {
        return AdaptiveCollectionPolicy.alignUp(AdaptiveCollectionPolicy.spaceIncrement(curPromo, this.oldGenSizeIncrementSupplement.add(10)));
    }

    private void decaySupplementalGrowth(boolean completeCollection) {
        if (completeCollection) {
            if (this.majorCount % 2L == 0L) {
                this.oldGenSizeIncrementSupplement = this.oldGenSizeIncrementSupplement.unsignedShiftRight(1);
            }
        } else if (this.minorCount >= 5L && this.minorCount % 8L == 0L) {
            this.youngGenSizeIncrementSupplement = this.youngGenSizeIncrementSupplement.unsignedShiftRight(1);
        }
    }

    private static void updateCollectionEndAverages(AdaptiveWeightedAverage costAverage, AdaptivePaddedAverage pauseAverage, ReciprocalLeastSquareFit costEstimator, AdaptiveWeightedAverage intervalSeconds, GCCause cause, long mutatorNanos, long pauseNanos, UnsignedWord sizeBytes) {
        if (cause == GenScavengeGCCause.OnAllocation) {
            double cost = 0.0;
            double mutatorInSeconds = TimeUtils.nanosToSecondsDouble(mutatorNanos);
            double pauseInSeconds = TimeUtils.nanosToSecondsDouble(pauseNanos);
            pauseAverage.sample(pauseInSeconds);
            if (mutatorInSeconds > 0.0 && pauseInSeconds > 0.0) {
                double intervalInSeconds = mutatorInSeconds + pauseInSeconds;
                cost = pauseInSeconds / intervalInSeconds;
                costAverage.sample(cost);
                if (intervalSeconds != null) {
                    intervalSeconds.sample(intervalInSeconds);
                }
            }
            costEstimator.sample(UnsignedUtils.toDouble(sizeBytes), cost);
        }
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected long gcCount() {
        return this.minorCount + this.majorCount;
    }
}

