/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.containers;

import com.oracle.svm.core.containers.CgroupSubsystemController;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;

public final class CgroupUtil {
    static void unwrapIOExceptionAndRethrow(PrivilegedActionException pae) throws IOException {
        Throwable x = pae.getCause();
        if (x instanceof IOException) {
            throw (IOException)x;
        }
        if (x instanceof RuntimeException) {
            throw (RuntimeException)x;
        }
        if (x instanceof Error) {
            throw (Error)x;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String readStringValue(CgroupSubsystemController controller, String param) throws IOException {
        PrivilegedExceptionAction<BufferedReader> pea = () -> new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(Paths.get(controller.path(), param).toString()), StandardCharsets.UTF_8));
        try (BufferedReader bufferedReader = AccessController.doPrivileged(pea);){
            String string = bufferedReader.readLine();
            return string;
        }
        catch (PrivilegedActionException e) {
            CgroupUtil.unwrapIOExceptionAndRethrow(e);
            throw new InternalError(e.getCause());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readAllLinesPrivileged(Path path) throws IOException {
        PrivilegedExceptionAction<BufferedReader> pea = () -> new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path.toString()), StandardCharsets.UTF_8));
        try (BufferedReader bufferedReader = AccessController.doPrivileged(pea);){
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = bufferedReader.readLine()) != null) {
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        catch (PrivilegedActionException e) {
            CgroupUtil.unwrapIOExceptionAndRethrow(e);
            throw new InternalError(e.getCause());
        }
    }
}

