/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.code.UntetheredCodeInfoAccess;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.deopt.SubstrateSpeculationLog;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.truffle.api.SubstrateOptimizedCallTarget;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.WordFactory;

public class SubstrateOptimizedCallTargetInstalledCode
extends InstalledCode
implements SubstrateInstalledCode,
OptimizedAssumptionDependency {
    protected final SubstrateOptimizedCallTarget callTarget;
    private static final String NOT_CALLED_IN_SUBSTRATE_VM = "No implementation in Substrate VM";

    protected SubstrateOptimizedCallTargetInstalledCode(SubstrateOptimizedCallTarget callTarget) {
        super(null);
        this.callTarget = callTarget;
    }

    @Override
    public final void invalidate() {
        CodeInfoTable.invalidateInstalledCode(this);
        this.callTarget.onInvalidate(null, null, true);
    }

    public void onAssumptionInvalidated(Object source, CharSequence reason) {
        boolean wasActive = false;
        if (this.isAlive()) {
            CodeInfoTable.invalidateInstalledCode(this);
            wasActive = true;
        } else assert (!this.isValid()) : "Cannot be valid but not alive";
        this.callTarget.onInvalidate(source, reason, wasActive);
    }

    @Override
    public boolean isValid() {
        return super.isValid();
    }

    public CompilableTruffleAST getCompilable() {
        return this.callTarget;
    }

    @Override
    public SubstrateSpeculationLog getSpeculationLog() {
        return this.callTarget.getSpeculationLog();
    }

    @Override
    public String getName() {
        return this.callTarget.getName();
    }

    @Override
    public ResolvedJavaMethod getMethod() {
        return null;
    }

    @Override
    public void setAddress(long address, ResolvedJavaMethod method) {
        assert (VMOperation.isInProgressAtSafepoint());
        this.entryPoint = address;
        this.address = address;
        this.callTarget.onCodeInstalled(this);
    }

    @Override
    public void clearAddress() {
        assert (VMOperation.isInProgressAtSafepoint());
        this.entryPoint = 0L;
        this.address = 0L;
        this.callTarget.onCodeCleared(this);
    }

    @Override
    public void invalidateWithoutDeoptimization() {
        assert (VMOperation.isInProgressAtSafepoint());
        if (this.isValid()) {
            this.invalidateWithoutDeoptimization0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Must tether the CodeInfo.")
    private void invalidateWithoutDeoptimization0() {
        this.entryPoint = 0L;
        UntetheredCodeInfo untetheredInfo = CodeInfoTable.lookupCodeInfo((CodePointer)WordFactory.pointer((long)this.address));
        assert (untetheredInfo.isNonNull() && untetheredInfo.notEqual((ComparableWord)CodeInfoTable.getImageCodeInfo()));
        Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
        try {
            CodeInfo codeInfo = CodeInfoAccess.convert(untetheredInfo, tether);
            CodeInfoAccess.setState(codeInfo, 2);
        }
        finally {
            CodeInfoAccess.releaseTether(untetheredInfo, tether);
        }
    }

    static Object doInvoke(SubstrateOptimizedCallTarget callTarget, Object[] args) {
        SubstrateOptimizedCallTarget.safepointBarrier();
        long start = callTarget.installedCode.entryPoint;
        if (start != 0L) {
            SubstrateOptimizedCallTarget.CallBoundaryFunctionPointer target = (SubstrateOptimizedCallTarget.CallBoundaryFunctionPointer)WordFactory.pointer((long)start);
            Object result = target.invoke(callTarget, args);
            return result;
        }
        return callTarget.invokeCallBoundary(args);
    }

    @Uninterruptible(reason="Prevent the GC from freeing the CodeInfo object.")
    boolean isValidLastTier() {
        if (this.entryPoint == 0L) {
            return false;
        }
        UntetheredCodeInfo info = CodeInfoTable.lookupCodeInfo((CodePointer)WordFactory.pointer((long)this.entryPoint));
        return info.isNonNull() && info.notEqual((ComparableWord)CodeInfoTable.getImageCodeInfo()) && UntetheredCodeInfoAccess.getTier(info) == 2;
    }

    public long getStart() {
        throw VMError.shouldNotReachHere(NOT_CALLED_IN_SUBSTRATE_VM);
    }

    public byte[] getCode() {
        throw VMError.shouldNotReachHere(NOT_CALLED_IN_SUBSTRATE_VM);
    }

    public Object executeVarargs(Object ... args) {
        throw VMError.shouldNotReachHere(NOT_CALLED_IN_SUBSTRATE_VM);
    }
}

