/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.hosted;

import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.reflect.helpers.ReflectionProxyHelper;
import com.oracle.svm.reflect.hosted.ReflectionSubstitution;
import java.lang.reflect.Executable;
import java.lang.reflect.Proxy;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import org.graalvm.nativeimage.ImageSingletons;
import sun.misc.Unsafe;

public final class ExecutableAccessorComputer
implements RecomputeFieldValue.CustomFieldValueComputer {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();

    @Override
    public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
        Executable member = (Executable)receiver;
        ReflectionSubstitution subst = (ReflectionSubstitution)((Object)ImageSingletons.lookup(ReflectionSubstitution.class));
        Class<?> proxyClass = subst.getProxyClass(member);
        if (proxyClass == null) {
            throw VMError.shouldNotReachHere();
        }
        try {
            Proxy proxyInstance = (Proxy)UNSAFE.allocateInstance(proxyClass);
            ReflectionProxyHelper.setDefaultInvocationHandler(proxyInstance);
            return proxyInstance;
        }
        catch (InstantiationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

