/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.access;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ReflectionConfigurationParser;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.hosted.meta.MaterializedConstantFields;
import com.oracle.svm.hosted.substitute.SubstitutionReflectivityFilter;
import com.oracle.svm.jni.JNIJavaCallWrappers;
import com.oracle.svm.jni.JNISupport;
import com.oracle.svm.jni.access.JNIAccessibleClass;
import com.oracle.svm.jni.access.JNIAccessibleField;
import com.oracle.svm.jni.access.JNIAccessibleMethod;
import com.oracle.svm.jni.access.JNIAccessibleMethodDescriptor;
import com.oracle.svm.jni.access.JNINativeLinkage;
import com.oracle.svm.jni.access.JNIReflectionDictionary;
import com.oracle.svm.jni.hosted.JNICallTrampolineMethod;
import com.oracle.svm.jni.hosted.JNIFieldAccessorMethod;
import com.oracle.svm.jni.hosted.JNIJavaCallWrapperMethod;
import com.oracle.svm.jni.hosted.JNIJavaCallWrapperMethodSupport;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.ReflectionRegistry;

public class JNIAccessFeature
implements Feature {
    private boolean sealed = false;
    private NativeLibraries nativeLibraries;
    private JNICallTrampolineMethod varargsCallTrampolineMethod;
    private JNICallTrampolineMethod arrayCallTrampolineMethod;
    private JNICallTrampolineMethod valistCallTrampolineMethod;
    private JNICallTrampolineMethod varargsNonvirtualCallTrampolineMethod;
    private JNICallTrampolineMethod arrayNonvirtualCallTrampolineMethod;
    private JNICallTrampolineMethod valistNonvirtualCallTrampolineMethod;
    private int loadedConfigurations;
    private final Set<Class<?>> newClasses = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Executable> newMethods = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<Field, Boolean> newFields = new ConcurrentHashMap<Field, Boolean>();
    private final Map<JNINativeLinkage, JNINativeLinkage> newLinkages = new ConcurrentHashMap<JNINativeLinkage, JNINativeLinkage>();
    private final Map<JNINativeLinkage, JNINativeLinkage> nativeLinkages = new ConcurrentHashMap<JNINativeLinkage, JNINativeLinkage>();

    @Fold
    public static JNIAccessFeature singleton() {
        return (JNIAccessFeature)ImageSingletons.lookup(JNIAccessFeature.class);
    }

    private void abortIfSealed() {
        UserError.guarantee(!this.sealed, "Classes, methods and fields must be registered for JNI access before the analysis has completed.", new Object[0]);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess arg) {
        FeatureImpl.AfterRegistrationAccessImpl access = (FeatureImpl.AfterRegistrationAccessImpl)arg;
        JNIReflectionDictionary.initialize();
        JNIRuntimeAccessibilitySupportImpl registry = new JNIRuntimeAccessibilitySupportImpl();
        ImageSingletons.add(JNIRuntimeAccess.JNIRuntimeAccessibilitySupport.class, (Object)registry);
        ReflectionConfigurationParser<Class<?>> parser = ConfigurationParserUtils.create(registry, access.getImageClassLoader());
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurations(parser, access.getImageClassLoader(), "JNI", ConfigurationFiles.Options.JNIConfigurationFiles, ConfigurationFiles.Options.JNIConfigurationResources, ConfigurationFile.JNI.getFileName());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess arg) {
        if (!ImageSingletons.contains(JNIJavaCallWrapperMethodSupport.class)) {
            ImageSingletons.add(JNIJavaCallWrapperMethodSupport.class, (Object)new JNIJavaCallWrapperMethodSupport());
        }
        if (!ImageSingletons.contains(JNIFieldAccessorMethod.Factory.class)) {
            ImageSingletons.add(JNIFieldAccessorMethod.Factory.class, (Object)new JNIFieldAccessorMethod.Factory());
        }
        if (!ImageSingletons.contains(JNISupport.class)) {
            ImageSingletons.add(JNISupport.class, (Object)new JNISupport());
        }
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)arg;
        this.nativeLibraries = access.getNativeLibraries();
        this.varargsCallTrampolineMethod = JNIAccessFeature.createJavaCallTrampoline(access, JNIJavaCallWrapperMethod.CallVariant.VARARGS, false);
        this.arrayCallTrampolineMethod = JNIAccessFeature.createJavaCallTrampoline(access, JNIJavaCallWrapperMethod.CallVariant.ARRAY, false);
        this.valistCallTrampolineMethod = JNIAccessFeature.createJavaCallTrampoline(access, JNIJavaCallWrapperMethod.CallVariant.VA_LIST, false);
        this.varargsNonvirtualCallTrampolineMethod = JNIAccessFeature.createJavaCallTrampoline(access, JNIJavaCallWrapperMethod.CallVariant.VARARGS, true);
        this.arrayNonvirtualCallTrampolineMethod = JNIAccessFeature.createJavaCallTrampoline(access, JNIJavaCallWrapperMethod.CallVariant.ARRAY, true);
        this.valistNonvirtualCallTrampolineMethod = JNIAccessFeature.createJavaCallTrampoline(access, JNIJavaCallWrapperMethod.CallVariant.VA_LIST, true);
    }

    private static JNICallTrampolineMethod createJavaCallTrampoline(FeatureImpl.BeforeAnalysisAccessImpl access, JNIJavaCallWrapperMethod.CallVariant variant, boolean nonVirtual) {
        MetaAccessProvider wrappedMetaAccess = access.getMetaAccess().getWrapped();
        ResolvedJavaField field = JNIAccessibleMethod.getCallWrapperField(wrappedMetaAccess, variant, nonVirtual);
        access.getUniverse().lookup((JavaType)field.getDeclaringClass()).registerAsReachable();
        access.registerAsAccessed(access.getUniverse().lookup((JavaField)field));
        ResolvedJavaMethod method = JNIJavaCallWrappers.lookupJavaCallTrampoline(wrappedMetaAccess, variant, nonVirtual);
        JNICallTrampolineMethod trampoline = new JNICallTrampolineMethod(method, field, nonVirtual);
        access.registerAsCompiled(access.getUniverse().lookup((JavaMethod)trampoline));
        return trampoline;
    }

    public JNICallTrampolineMethod getCallTrampolineMethod(JNIJavaCallWrapperMethod.CallVariant variant, boolean nonVirtual) {
        JNICallTrampolineMethod method = null;
        if (variant == JNIJavaCallWrapperMethod.CallVariant.VARARGS) {
            method = nonVirtual ? this.varargsNonvirtualCallTrampolineMethod : this.varargsCallTrampolineMethod;
        } else if (variant == JNIJavaCallWrapperMethod.CallVariant.ARRAY) {
            method = nonVirtual ? this.arrayNonvirtualCallTrampolineMethod : this.arrayCallTrampolineMethod;
        } else if (variant == JNIJavaCallWrapperMethod.CallVariant.VA_LIST) {
            JNICallTrampolineMethod jNICallTrampolineMethod = method = nonVirtual ? this.valistNonvirtualCallTrampolineMethod : this.valistCallTrampolineMethod;
        }
        assert (method != null);
        return method;
    }

    public JNINativeLinkage makeLinkage(String declaringClass, String name, String descriptor) {
        UserError.guarantee(!this.sealed, "All linkages for JNI calls must be created before the analysis has completed.%nOffending class: %s name: %s descriptor: %s", declaringClass, name, descriptor);
        JNINativeLinkage key = new JNINativeLinkage(declaringClass, name, descriptor);
        if (Options.PrintJNIMethods.getValue().booleanValue()) {
            System.out.println("Creating a new JNINativeLinkage: " + key.toString());
        }
        return this.nativeLinkages.computeIfAbsent(key, linkage -> {
            this.newLinkages.put((JNINativeLinkage)linkage, (JNINativeLinkage)linkage);
            return linkage;
        });
    }

    private boolean wereElementsAdded() {
        return !this.newClasses.isEmpty() || !this.newMethods.isEmpty() || !this.newFields.isEmpty() || !this.newLinkages.isEmpty();
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        if (!this.wereElementsAdded()) {
            return;
        }
        for (Class<?> clazz : this.newClasses) {
            JNIAccessFeature.addClass(clazz, access);
        }
        this.newClasses.clear();
        for (Executable method : this.newMethods) {
            this.addMethod(method, access);
        }
        this.newMethods.clear();
        this.newFields.forEach((field, writable) -> JNIAccessFeature.addField(field, writable, access));
        this.newFields.clear();
        JNIReflectionDictionary.singleton().addLinkages(this.newLinkages);
        this.newLinkages.clear();
        access.requireAnalysisIteration();
    }

    private static JNIAccessibleClass addClass(Class<?> classObj, FeatureImpl.DuringAnalysisAccessImpl access) {
        if (SubstitutionReflectivityFilter.shouldExclude(classObj, access.getMetaAccess(), access.getUniverse())) {
            return null;
        }
        return JNIReflectionDictionary.singleton().addClassIfAbsent(classObj, c -> {
            AnalysisType analysisClass = access.getMetaAccess().lookupJavaType(classObj);
            if (analysisClass.isInterface() || analysisClass.isInstanceClass() && analysisClass.isAbstract()) {
                analysisClass.registerAsReachable();
            } else {
                analysisClass.registerAsAllocated(null);
            }
            return new JNIAccessibleClass(classObj);
        });
    }

    private void addMethod(Executable method, FeatureImpl.DuringAnalysisAccessImpl access) {
        if (SubstitutionReflectivityFilter.shouldExclude(method, access.getMetaAccess(), access.getUniverse())) {
            return;
        }
        JNIAccessibleClass jniClass = JNIAccessFeature.addClass(method.getDeclaringClass(), access);
        JNIAccessibleMethodDescriptor descriptor = JNIAccessibleMethodDescriptor.of(method);
        jniClass.addMethodIfAbsent(descriptor, d -> {
            MetaAccessProvider wrappedMetaAccess = access.getMetaAccess().getWrapped();
            JNIJavaCallWrapperMethod varargsCallWrapper = new JNIJavaCallWrapperMethod(method, JNIJavaCallWrapperMethod.CallVariant.VARARGS, false, wrappedMetaAccess, this.nativeLibraries);
            JNIJavaCallWrapperMethod arrayCallWrapper = new JNIJavaCallWrapperMethod(method, JNIJavaCallWrapperMethod.CallVariant.ARRAY, false, wrappedMetaAccess, this.nativeLibraries);
            JNIJavaCallWrapperMethod valistCallWrapper = new JNIJavaCallWrapperMethod(method, JNIJavaCallWrapperMethod.CallVariant.VA_LIST, false, wrappedMetaAccess, this.nativeLibraries);
            Stream<JNIJavaCallWrapperMethod> wrappers = Stream.of(varargsCallWrapper, arrayCallWrapper, valistCallWrapper);
            JNIJavaCallWrapperMethod varargsNonvirtualCallWrapper = null;
            JNIJavaCallWrapperMethod arrayNonvirtualCallWrapper = null;
            JNIJavaCallWrapperMethod valistNonvirtualCallWrapper = null;
            if (!Modifier.isStatic(method.getModifiers()) && !Modifier.isAbstract(method.getModifiers())) {
                varargsNonvirtualCallWrapper = new JNIJavaCallWrapperMethod(method, JNIJavaCallWrapperMethod.CallVariant.VARARGS, true, wrappedMetaAccess, this.nativeLibraries);
                arrayNonvirtualCallWrapper = new JNIJavaCallWrapperMethod(method, JNIJavaCallWrapperMethod.CallVariant.ARRAY, true, wrappedMetaAccess, this.nativeLibraries);
                valistNonvirtualCallWrapper = new JNIJavaCallWrapperMethod(method, JNIJavaCallWrapperMethod.CallVariant.VA_LIST, true, wrappedMetaAccess, this.nativeLibraries);
                wrappers = Stream.concat(wrappers, Stream.of(varargsNonvirtualCallWrapper, arrayNonvirtualCallWrapper, valistNonvirtualCallWrapper));
            }
            JNIAccessibleMethod jniMethod = new JNIAccessibleMethod((JNIAccessibleMethodDescriptor)d, method.getModifiers(), jniClass, varargsCallWrapper, arrayCallWrapper, valistCallWrapper, varargsNonvirtualCallWrapper, arrayNonvirtualCallWrapper, valistNonvirtualCallWrapper);
            CEntryPointData unpublished = CEntryPointData.createCustomUnpublished();
            wrappers.forEach(wrapper -> {
                AnalysisMethod analysisWrapper = access.getUniverse().lookup((JavaMethod)wrapper);
                access.getBigBang().addRootMethod(analysisWrapper);
                analysisWrapper.registerAsEntryPoint((Object)unpublished);
            });
            return jniMethod;
        });
    }

    private static void addField(Field reflField, boolean writable, FeatureImpl.DuringAnalysisAccessImpl access) {
        access.getMetaAccess().lookupJavaType(reflField.getDeclaringClass()).registerAsReachable();
        if (SubstitutionReflectivityFilter.shouldExclude(reflField, access.getMetaAccess(), access.getUniverse())) {
            return;
        }
        JNIAccessibleClass jniClass = JNIAccessFeature.addClass(reflField.getDeclaringClass(), access);
        AnalysisField field = access.getMetaAccess().lookupJavaField(reflField);
        jniClass.addFieldIfAbsent(field.getName(), name -> new JNIAccessibleField(jniClass, (String)name, field.getJavaKind(), field.getModifiers()));
        field.registerAsJNIAccessed();
        field.registerAsRead(null);
        if (writable) {
            field.registerAsWritten(null);
            AnalysisType fieldType = field.getType();
            if (fieldType.isArray() && !access.isReachable(fieldType)) {
                access.registerReachabilityHandler(a -> fieldType.registerAsAllocated(null), ((AnalysisType)fieldType.getElementalType()).getJavaClass());
            }
        } else if (field.isStatic() && field.isFinal()) {
            MaterializedConstantFields.singleton().register(field);
        }
        BigBang bigBang = access.getBigBang();
        AllInstantiatedTypeFlow declaredTypeFlow = field.getType().getTypeFlow(bigBang, true);
        if (field.isStatic()) {
            declaredTypeFlow.addUse(bigBang, (TypeFlow)field.getStaticFieldFlow());
        } else {
            FieldTypeFlow instanceFieldFlow = field.getDeclaringClass().getContextInsensitiveAnalysisObject().getInstanceFieldFlow(bigBang, field, writable);
            declaredTypeFlow.addUse(bigBang, (TypeFlow)instanceFieldFlow);
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.sealed = true;
        if (this.wereElementsAdded()) {
            this.abortIfSealed();
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        FallbackFeature.FallbackImageRequest jniFallback;
        if (ImageSingletons.contains(FallbackFeature.class) && (jniFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).jniFallback) != null && this.loadedConfigurations == 0) {
            throw jniFallback;
        }
        FeatureImpl.CompilationAccessImpl access = (FeatureImpl.CompilationAccessImpl)a;
        for (JNIAccessibleClass clazz : JNIReflectionDictionary.singleton().getClasses()) {
            for (JNIAccessibleField field : clazz.getFields()) {
                field.finishBeforeCompilation(access);
            }
            for (JNIAccessibleMethod method : clazz.getMethods()) {
                method.finishBeforeCompilation(access);
                access.registerAsImmutable(method);
            }
        }
    }

    private class JNIRuntimeAccessibilitySupportImpl
    implements JNIRuntimeAccess.JNIRuntimeAccessibilitySupport,
    ReflectionRegistry {
        private JNIRuntimeAccessibilitySupportImpl() {
        }

        public void register(Class<?> ... classes) {
            JNIAccessFeature.this.abortIfSealed();
            JNIAccessFeature.this.newClasses.addAll(Arrays.asList(classes));
        }

        public void register(Executable ... methods) {
            JNIAccessFeature.this.abortIfSealed();
            JNIAccessFeature.this.newMethods.addAll(Arrays.asList(methods));
        }

        public void register(boolean finalIsWritable, Field ... fields) {
            JNIAccessFeature.this.abortIfSealed();
            for (Field field : fields) {
                boolean writable = finalIsWritable || !Modifier.isFinal(field.getModifiers());
                JNIAccessFeature.this.newFields.put(field, writable);
            }
        }
    }

    public static class Options {
        @Option(help={"Print JNI methods added to generated image"})
        public static final HostedOptionKey<Boolean> PrintJNIMethods = new HostedOptionKey<Boolean>(false);
    }
}

