/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.hosted.SVMHost;
import java.util.function.Supplier;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;

public class SubstrateClassInitializationPlugin
implements ClassInitializationPlugin {
    private final SVMHost host;

    public SubstrateClassInitializationPlugin(SVMHost host) {
        this.host = host;
    }

    public boolean supportsLazyInitialization(ConstantPool cp) {
        return true;
    }

    public void loadReferencedType(GraphBuilderContext builder, ConstantPool constantPool, int cpi, int bytecode) {
        constantPool.loadReferencedType(cpi, bytecode);
    }

    public boolean apply(GraphBuilderContext builder, ResolvedJavaType type, Supplier<FrameState> frameState, ValueNode[] classInit) {
        if (SubstrateClassInitializationPlugin.needsRuntimeInitialization(builder.getMethod().getDeclaringClass(), type)) {
            SubstrateClassInitializationPlugin.emitEnsureClassInitialized(builder, SubstrateObjectConstant.forObject(this.host.dynamicHub(type)), frameState.get());
            if (classInit != null) {
                classInit[0] = null;
            }
            return true;
        }
        return false;
    }

    private static void emitEnsureClassInitialized(GraphBuilderContext builder, JavaConstant hubConstant, FrameState frameState) {
        ConstantNode hub = ConstantNode.forConstant((JavaConstant)hubConstant, (MetaAccessProvider)builder.getMetaAccess(), (StructuredGraph)builder.getGraph());
        EnsureClassInitializedNode node = new EnsureClassInitializedNode((ValueNode)hub, frameState);
        builder.add((ValueNode)node);
    }

    static boolean needsRuntimeInitialization(ResolvedJavaType declaringClass, ResolvedJavaType type) {
        return !declaringClass.equals(type) && !type.isInitialized() && !type.isArray();
    }
}

