/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.SubstrateSegfaultHandler;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.windows.headers.ErrHandlingAPI;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunctionPointer;

class WindowsSubstrateSegfaultHandler
extends SubstrateSegfaultHandler {
    private static final CEntryPointLiteral<CFunctionPointer> HANDLER_LITERAL = CEntryPointLiteral.create(WindowsSubstrateSegfaultHandler.class, (String)"handler", (Class[])new Class[]{ErrHandlingAPI.EXCEPTION_POINTERS.class});

    WindowsSubstrateSegfaultHandler() {
    }

    @Override
    protected void install() {
        if (ErrHandlingAPI.AddVectoredContinueHandler(0, HANDLER_LITERAL.getFunctionPointer()).isNull()) {
            VMError.shouldNotReachHere("SubstrateSegfaultHandler installation failed.");
        }
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, publishAs=CEntryPointOptions.Publish.SymbolOnly, include=CEntryPointOptions.NotIncludedAutomatically.class)
    @Uninterruptible(reason="Must be uninterruptible until we get immune to safepoints.")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_HEAP_ACCESS, reason="We have yet to enter the isolate.")
    private static int handler(ErrHandlingAPI.EXCEPTION_POINTERS exceptionInfo) {
        ErrHandlingAPI.EXCEPTION_RECORD exceptionRecord = exceptionInfo.ExceptionRecord();
        if (exceptionRecord.ExceptionCode() != ErrHandlingAPI.EXCEPTION_ACCESS_VIOLATION()) {
            return ErrHandlingAPI.EXCEPTION_CONTINUE_SEARCH();
        }
        ErrHandlingAPI.CONTEXT context = exceptionInfo.ContextRecord();
        if (WindowsSubstrateSegfaultHandler.tryEnterIsolate(context)) {
            WindowsSubstrateSegfaultHandler.dump(context);
            throw WindowsSubstrateSegfaultHandler.shouldNotReachHere();
        }
        return ErrHandlingAPI.EXCEPTION_CONTINUE_SEARCH();
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in segfault handler.", overridesCallers=true)
    private static RuntimeException shouldNotReachHere() {
        throw VMError.shouldNotReachHere();
    }
}

