/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.amd64;

import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.posix.UContextRegisterDumper;
import com.oracle.svm.core.posix.headers.Signal;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

class AMD64UContextRegisterDumper
implements UContextRegisterDumper {
    AMD64UContextRegisterDumper() {
    }

    @Override
    public void dumpRegisters(Log log, Signal.ucontext_t uContext) {
        Signal.GregsPointer gregs = uContext.uc_mcontext_gregs();
        RegisterDumper.dumpReg(log, "RAX ", gregs.read(Signal.GregEnum.REG_RAX()));
        RegisterDumper.dumpReg(log, "RBX ", gregs.read(Signal.GregEnum.REG_RBX()));
        RegisterDumper.dumpReg(log, "RCX ", gregs.read(Signal.GregEnum.REG_RCX()));
        RegisterDumper.dumpReg(log, "RDX ", gregs.read(Signal.GregEnum.REG_RDX()));
        RegisterDumper.dumpReg(log, "RBP ", gregs.read(Signal.GregEnum.REG_RBP()));
        RegisterDumper.dumpReg(log, "RSI ", gregs.read(Signal.GregEnum.REG_RSI()));
        RegisterDumper.dumpReg(log, "RDI ", gregs.read(Signal.GregEnum.REG_RDI()));
        RegisterDumper.dumpReg(log, "RSP ", gregs.read(Signal.GregEnum.REG_RSP()));
        RegisterDumper.dumpReg(log, "R8  ", gregs.read(Signal.GregEnum.REG_R8()));
        RegisterDumper.dumpReg(log, "R9  ", gregs.read(Signal.GregEnum.REG_R9()));
        RegisterDumper.dumpReg(log, "R10 ", gregs.read(Signal.GregEnum.REG_R10()));
        RegisterDumper.dumpReg(log, "R11 ", gregs.read(Signal.GregEnum.REG_R11()));
        RegisterDumper.dumpReg(log, "R12 ", gregs.read(Signal.GregEnum.REG_R12()));
        RegisterDumper.dumpReg(log, "R13 ", gregs.read(Signal.GregEnum.REG_R13()));
        RegisterDumper.dumpReg(log, "R14 ", gregs.read(Signal.GregEnum.REG_R14()));
        RegisterDumper.dumpReg(log, "R15 ", gregs.read(Signal.GregEnum.REG_R15()));
        RegisterDumper.dumpReg(log, "EFL ", gregs.read(Signal.GregEnum.REG_EFL()));
        RegisterDumper.dumpReg(log, "RIP ", gregs.read(Signal.GregEnum.REG_RIP()));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true, calleeMustBe=false)
    public PointerBase getHeapBase(Signal.ucontext_t uContext) {
        Signal.GregsPointer gregs = uContext.uc_mcontext_gregs();
        return WordFactory.pointer((long)gregs.read(Signal.GregEnum.REG_R14()));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true, calleeMustBe=false)
    public PointerBase getThreadPointer(Signal.ucontext_t uContext) {
        Signal.GregsPointer gregs = uContext.uc_mcontext_gregs();
        return WordFactory.pointer((long)gregs.read(Signal.GregEnum.REG_R15()));
    }

    @Override
    public PointerBase getSP(Signal.ucontext_t uContext) {
        Signal.GregsPointer gregs = uContext.uc_mcontext_gregs();
        return WordFactory.pointer((long)gregs.read(Signal.GregEnum.REG_RSP()));
    }

    @Override
    public PointerBase getIP(Signal.ucontext_t uContext) {
        Signal.GregsPointer gregs = uContext.uc_mcontext_gregs();
        return WordFactory.pointer((long)gregs.read(Signal.GregEnum.REG_RIP()));
    }
}

