/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.log;

import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.log.FunctionPointerLogHandler;
import com.oracle.svm.core.log.RealLog;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;

public abstract class Log
implements AutoCloseable {
    public static final int NO_ALIGN = 0;
    public static final int LEFT_ALIGN = 1;
    public static final int RIGHT_ALIGN = 2;
    private static RealLog log = new RealLog();
    private static final NoopLog noopLog = new NoopLog();
    private static final PrintStream logStream = new PrintStream(new LogOutputStream());

    public static void finalizeDefaultLogHandler(LogHandler handler) {
        if (!ImageSingletons.contains(LogHandler.class)) {
            ImageSingletons.add(LogHandler.class, (Object)new FunctionPointerLogHandler(handler));
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setLog(RealLog realLog) {
        log = realLog;
    }

    @Fold
    public static Log log() {
        return log;
    }

    public static PrintStream logStream() {
        return logStream;
    }

    @Fold
    public static Log noopLog() {
        return noopLog;
    }

    protected Log() {
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract boolean isEnabled();

    public abstract Log string(String var1);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log string(String var1, int var2, int var3);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log string(char[] var1);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public final Log string(byte[] value) {
        this.string(value, 0, value.length);
        return this;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log string(byte[] var1, int var2, int var3);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log string(CCharPointer var1);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log character(char var1);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log newline();

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log autoflush(boolean var1);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log number(long var1, int var3, boolean var4);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log signed(WordBase var1);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log signed(int var1);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log signed(long var1);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log unsigned(WordBase var1);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log unsigned(WordBase var1, int var2, int var3);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log unsigned(int var1);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log unsigned(long var1);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log unsigned(long var1, int var3, int var4);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log rational(long var1, long var3, long var5);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log hex(WordBase var1);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log hex(int var1);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log hex(long var1);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log zhex(long var1);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log zhex(int var1);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log zhex(short var1);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log zhex(byte var1);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log hexdump(PointerBase var1, int var2, int var3);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log redent(boolean var1);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public final Log indent(boolean addOrRemove) {
        this.redent(addOrRemove).newline();
        return this;
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log resetIndentation();

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log bool(boolean var1);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log object(Object var1);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log spaces(int var1);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public Log exception(Throwable t) {
        this.exception(t, Integer.MAX_VALUE);
        return this;
    }

    public abstract Log exception(Throwable var1, int var2);

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, mayBeInlined=true, reason="Must not allocate when logging.")
    public abstract Log flush();

    @Override
    public void close() {
    }

    static class LogOutputStream
    extends OutputStream {
        LogOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            Log.log().character((char)b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Log.log().string(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            Log.log().flush();
        }
    }

    private static final class NoopLog
    extends Log {
        protected NoopLog() {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public Log string(String value) {
            return this;
        }

        @Override
        public Log string(String str, int fill, int align) {
            return this;
        }

        @Override
        public Log string(char[] value) {
            return this;
        }

        @Override
        public Log string(byte[] value, int offset, int length) {
            return this;
        }

        @Override
        public Log string(CCharPointer value) {
            return this;
        }

        @Override
        public Log character(char value) {
            return this;
        }

        @Override
        public Log newline() {
            return this;
        }

        @Override
        public Log number(long value, int radix, boolean signed) {
            return this;
        }

        @Override
        public Log signed(WordBase value) {
            return this;
        }

        @Override
        public Log signed(int value) {
            return this;
        }

        @Override
        public Log signed(long value) {
            return this;
        }

        @Override
        public Log unsigned(WordBase value) {
            return this;
        }

        @Override
        public Log unsigned(WordBase value, int fill, int align) {
            return this;
        }

        @Override
        public Log unsigned(int value) {
            return this;
        }

        @Override
        public Log unsigned(long value) {
            return this;
        }

        @Override
        public Log unsigned(long value, int fill, int align) {
            return this;
        }

        @Override
        public Log rational(long numerator, long denominator, long decimals) {
            return this;
        }

        @Override
        public Log hex(WordBase value) {
            return this;
        }

        @Override
        public Log hex(int value) {
            return this;
        }

        @Override
        public Log hex(long value) {
            return this;
        }

        @Override
        public Log bool(boolean value) {
            return this;
        }

        @Override
        public Log object(Object value) {
            return this;
        }

        @Override
        public Log spaces(int value) {
            return this;
        }

        @Override
        public Log flush() {
            return this;
        }

        @Override
        public Log autoflush(boolean onOrOff) {
            return this;
        }

        @Override
        public Log zhex(long value) {
            return this;
        }

        @Override
        public Log zhex(int value) {
            return this;
        }

        @Override
        public Log zhex(short value) {
            return this;
        }

        @Override
        public Log zhex(byte value) {
            return this;
        }

        @Override
        public Log hexdump(PointerBase from, int wordSize, int numWords) {
            return this;
        }

        @Override
        public Log exception(Throwable t, int maxFrames) {
            return this;
        }

        @Override
        public Log redent(boolean addOrRemove) {
            return this;
        }

        @Override
        public Log resetIndentation() {
            return this;
        }
    }
}

