/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.jdk;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.VirtualizableAllocation;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.nodes.virtual.VirtualArrayNode;

public interface SubstrateArraysCopyOf
extends Lowerable,
VirtualizableAllocation {
    public ValueNode getOriginal();

    public ValueNode getOriginalLength();

    public ValueNode getNewObjectArrayType();

    public ValueNode getNewLength();

    public static Stamp computeStamp(Stamp result) {
        if (result instanceof ObjectStamp) {
            return result.join(StampFactory.objectNonNull());
        }
        return result;
    }

    default public void virtualize(VirtualizerTool tool) {
        if (!this.getNewObjectArrayType().isConstant()) {
            return;
        }
        ConstantNode from = ConstantNode.forInt((int)0);
        ResolvedJavaType newComponentType = tool.getConstantReflection().asJavaType(this.getNewObjectArrayType().asConstant()).getComponentType();
        GraphUtil.virtualizeArrayCopy((VirtualizerTool)tool, (ValueNode)this.getOriginal(), (ValueNode)this.getOriginalLength(), (ValueNode)this.getNewLength(), (ValueNode)from, (ResolvedJavaType)newComponentType, (JavaKind)JavaKind.Object, (StructuredGraph)this.asNode().graph(), (componentType, length) -> new VirtualArrayNode(componentType, length.intValue()));
    }
}

