/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.genscavenge.HeapVerifier;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.VMThreads;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

final class StackVerifier {
    private static final StackFrameVerificationVisitor STACK_FRAME_VISITOR = new StackFrameVerificationVisitor();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private StackVerifier() {
    }

    @NeverInline(value="Starts a stack walk in the caller frame")
    public static boolean verifyAllThreads() {
        STACK_FRAME_VISITOR.reset();
        JavaStackWalker.walkCurrentThread(KnownIntrinsics.readCallerStackPointer(), STACK_FRAME_VISITOR);
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            IsolateThread vmThread = VMThreads.firstThread();
            while (vmThread.isNonNull()) {
                if (vmThread != CurrentIsolate.getCurrentThread()) {
                    JavaStackWalker.walkThread(vmThread, STACK_FRAME_VISITOR);
                }
                vmThread = VMThreads.nextThread(vmThread);
            }
        }
        return STACK_FRAME_VISITOR.getResult();
    }

    private static class VerifyFrameReferencesVisitor
    implements ObjectReferenceVisitor {
        private boolean result;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        VerifyFrameReferencesVisitor() {
        }

        public void reset() {
            this.result = true;
        }

        @Override
        public boolean visitObjectReference(Pointer objRef, boolean compressed) {
            this.result &= HeapVerifier.verifyReference(null, objRef, compressed);
            return true;
        }
    }

    private static class StackFrameVerificationVisitor
    extends StackFrameVisitor {
        private final VerifyFrameReferencesVisitor verifyFrameReferencesVisitor = new VerifyFrameReferencesVisitor();

        @Platforms(value={Platform.HOSTED_ONLY.class})
        StackFrameVerificationVisitor() {
        }

        public void reset() {
            this.verifyFrameReferencesVisitor.reset();
        }

        public boolean getResult() {
            return this.verifyFrameReferencesVisitor.result;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while verifying the stack.")
        public boolean visitFrame(Pointer currentSP, CodePointer currentIP, CodeInfo codeInfo, DeoptimizedFrame deoptimizedFrame) {
            CodeInfoTable.visitObjectReferences(currentSP, currentIP, codeInfo, deoptimizedFrame, this.verifyFrameReferencesVisitor);
            return true;
        }
    }
}

