/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.HeapOptions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.graalvm.compiler.options.OptionDescriptor;
import org.graalvm.compiler.options.OptionDescriptors;
import org.graalvm.compiler.options.OptionType;

public class HeapOptions_OptionDescriptors
implements OptionDescriptors {
    public OptionDescriptor get(String value) {
        switch (value) {
            case "ImageHeapCardMarking": {
                return OptionDescriptor.create((String)"ImageHeapCardMarking", (OptionType)OptionType.Expert, Boolean.class, (String)"Enables card marking for image heap objects, which arranges them in chunks. Automatically enabled when supported.", HeapOptions.class, (String)"ImageHeapCardMarking", HeapOptions.ImageHeapCardMarking, (boolean)false);
            }
            case "PrintGCSummary": {
                return OptionDescriptor.create((String)"PrintGCSummary", (OptionType)OptionType.Debug, Boolean.class, (String)"Print summary GC information after application main method returns.", HeapOptions.class, (String)"PrintGCSummary", HeapOptions.PrintGCSummary, (boolean)false);
            }
            case "PrintGCTimeStamps": {
                return OptionDescriptor.create((String)"PrintGCTimeStamps", (OptionType)OptionType.Debug, Boolean.class, (String)"Print a time stamp at each collection, if +PrintGC or +VerboseGC.", HeapOptions.class, (String)"PrintGCTimeStamps", HeapOptions.PrintGCTimeStamps, (boolean)false);
            }
            case "PrintGCTimes": {
                return OptionDescriptor.create((String)"PrintGCTimes", (OptionType)OptionType.Debug, Boolean.class, (String)"Print the time for each of the phases of each collection, if +VerboseGC.", HeapOptions.class, (String)"PrintGCTimes", HeapOptions.PrintGCTimes, (boolean)false);
            }
            case "PrintHeapShape": {
                return OptionDescriptor.create((String)"PrintHeapShape", (OptionType)OptionType.Debug, Boolean.class, (String)"Print the shape of the heap before and after each collection, if +VerboseGC.", HeapOptions.class, (String)"PrintHeapShape", HeapOptions.PrintHeapShape, (boolean)false);
            }
            case "SoftRefLRUPolicyMSPerMB": {
                return OptionDescriptor.create((String)"SoftRefLRUPolicyMSPerMB", (OptionType)OptionType.Expert, Integer.class, (String)"Soft references: this number of milliseconds multiplied by the free heap memory in MByte is the time span for which a soft reference will keep its referent alive after its last access.", HeapOptions.class, (String)"SoftRefLRUPolicyMSPerMB", HeapOptions.SoftRefLRUPolicyMSPerMB, (boolean)false);
            }
            case "VerifyReferences": {
                return OptionDescriptor.create((String)"VerifyReferences", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify all object references if VerifyHeap is enabled.", HeapOptions.class, (String)"VerifyReferences", HeapOptions.VerifyReferences, (boolean)false);
            }
            case "VerifyRememberedSet": {
                return OptionDescriptor.create((String)"VerifyRememberedSet", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify the remembered set if VerifyHeap is enabled.", HeapOptions.class, (String)"VerifyRememberedSet", HeapOptions.VerifyRememberedSet, (boolean)false);
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 8;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return HeapOptions_OptionDescriptors.this.get("ImageHeapCardMarking");
                    }
                    case 1: {
                        return HeapOptions_OptionDescriptors.this.get("PrintGCSummary");
                    }
                    case 2: {
                        return HeapOptions_OptionDescriptors.this.get("PrintGCTimeStamps");
                    }
                    case 3: {
                        return HeapOptions_OptionDescriptors.this.get("PrintGCTimes");
                    }
                    case 4: {
                        return HeapOptions_OptionDescriptors.this.get("PrintHeapShape");
                    }
                    case 5: {
                        return HeapOptions_OptionDescriptors.this.get("SoftRefLRUPolicyMSPerMB");
                    }
                    case 6: {
                        return HeapOptions_OptionDescriptors.this.get("VerifyReferences");
                    }
                    case 7: {
                        return HeapOptions_OptionDescriptors.this.get("VerifyRememberedSet");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

