/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.HostedOptionKey;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

final class GreyToBlackObjRefVisitor
implements ObjectReferenceVisitor {
    private final Counters counters = Options.GreyToBlackObjRefDemographics.getValue() != false ? new RealCounters() : new NoopCounters();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    GreyToBlackObjRefVisitor() {
    }

    @Override
    public boolean visitObjectReference(Pointer objRef, boolean compressed) {
        return this.visitObjectReferenceInline(objRef, 0, compressed, null);
    }

    @Override
    @AlwaysInline(value="GC performance")
    public boolean visitObjectReferenceInline(Pointer objRef, boolean compressed, Object holderObject) {
        return this.visitObjectReferenceInline(objRef, 0, compressed, holderObject);
    }

    @Override
    @AlwaysInline(value="GC performance")
    public boolean visitObjectReferenceInline(Pointer objRef, int innerOffset, boolean compressed) {
        return this.visitObjectReferenceInline(objRef, innerOffset, compressed, null);
    }

    @Override
    @AlwaysInline(value="GC performance")
    public boolean visitObjectReferenceInline(Pointer objRef, int innerOffset, boolean compressed, Object holderObject) {
        assert (innerOffset >= 0);
        assert (!objRef.isNull());
        this.counters.noteObjRef();
        Word offsetP = ReferenceAccess.singleton().readObjectAsUntrackedPointer(objRef, compressed);
        assert (offsetP.isNonNull() || innerOffset == 0);
        Pointer p = offsetP.subtract(innerOffset);
        if (p.isNull()) {
            this.counters.noteNullReferent();
            return true;
        }
        if (HeapImpl.getHeapImpl().isInImageHeap(p)) {
            this.counters.noteNonHeapReferent();
            return true;
        }
        UnsignedWord header = ObjectHeaderImpl.readHeaderFromPointer(p);
        if (GCImpl.getGCImpl().isCompleteCollection() || !RememberedSet.get().hasRememberedSet(header)) {
            if (ObjectHeaderImpl.isForwardedHeader(header)) {
                this.counters.noteForwardedReferent();
                Object obj = ObjectHeaderImpl.getForwardedObject(p, header);
                Object offsetObj = innerOffset == 0 ? obj : Word.objectToUntrackedPointer((Object)obj).add(innerOffset).toObject();
                ReferenceAccess.singleton().writeObjectAt(objRef, offsetObj, compressed);
                RememberedSet.get().dirtyCardIfNecessary(holderObject, obj);
                return true;
            }
            Object obj = p.toObject();
            assert ((long)innerOffset < LayoutEncoding.getSizeFromObject(obj).rawValue());
            Object copy = HeapImpl.getHeapImpl().promoteObject(obj, header);
            if (copy != obj) {
                this.counters.noteCopiedReferent();
                Object offsetCopy = innerOffset == 0 ? copy : Word.objectToUntrackedPointer((Object)copy).add(innerOffset).toObject();
                ReferenceAccess.singleton().writeObjectAt(objRef, offsetCopy, compressed);
            } else {
                this.counters.noteUnmodifiedReference();
            }
            RememberedSet.get().dirtyCardIfNecessary(holderObject, copy);
        }
        return true;
    }

    public Counters openCounters() {
        return this.counters.open();
    }

    public static class NoopCounters
    implements Counters {
        NoopCounters() {
        }

        @Override
        public NoopCounters open() {
            return this;
        }

        @Override
        public void close() {
        }

        @Override
        public void noteObjRef() {
        }

        @Override
        public void noteNullReferent() {
        }

        @Override
        public void noteForwardedReferent() {
        }

        @Override
        public void noteNonHeapReferent() {
        }

        @Override
        public void noteCopiedReferent() {
        }

        @Override
        public void noteUnmodifiedReference() {
        }

        @Override
        public void toLog() {
        }

        @Override
        public void reset() {
        }
    }

    public static class RealCounters
    implements Counters {
        private long objRef;
        private long nullObjRef;
        private long nullReferent;
        private long forwardedReferent;
        private long nonHeapReferent;
        private long copiedReferent;
        private long unmodifiedReference;

        RealCounters() {
            this.reset();
        }

        @Override
        public void reset() {
            this.objRef = 0L;
            this.nullObjRef = 0L;
            this.nullReferent = 0L;
            this.forwardedReferent = 0L;
            this.nonHeapReferent = 0L;
            this.copiedReferent = 0L;
            this.unmodifiedReference = 0L;
        }

        @Override
        public RealCounters open() {
            this.reset();
            return this;
        }

        @Override
        public void close() {
            this.toLog();
            this.reset();
        }

        @Override
        public void noteObjRef() {
            ++this.objRef;
        }

        @Override
        public void noteNullReferent() {
            ++this.nullReferent;
        }

        @Override
        public void noteForwardedReferent() {
            ++this.forwardedReferent;
        }

        @Override
        public void noteNonHeapReferent() {
            ++this.nonHeapReferent;
        }

        @Override
        public void noteCopiedReferent() {
            ++this.copiedReferent;
        }

        @Override
        public void noteUnmodifiedReference() {
            ++this.unmodifiedReference;
        }

        @Override
        public void toLog() {
            Log log = Log.log();
            log.string("[GreyToBlackObjRefVisitor.counters:");
            log.string("  objRef: ").signed(this.objRef);
            log.string("  nullObjRef: ").signed(this.nullObjRef);
            log.string("  nullReferent: ").signed(this.nullReferent);
            log.string("  forwardedReferent: ").signed(this.forwardedReferent);
            log.string("  nonHeapReferent: ").signed(this.nonHeapReferent);
            log.string("  copiedReferent: ").signed(this.copiedReferent);
            log.string("  unmodifiedReference: ").signed(this.unmodifiedReference);
            log.string("]").newline();
        }
    }

    public static interface Counters
    extends AutoCloseable {
        public Counters open();

        @Override
        public void close();

        public void noteObjRef();

        public void noteNullReferent();

        public void noteForwardedReferent();

        public void noteNonHeapReferent();

        public void noteCopiedReferent();

        public void noteUnmodifiedReference();

        public void toLog();

        public void reset();
    }

    public static class Options {
        @Option(help={"Develop demographics of the object references visited."})
        public static final HostedOptionKey<Boolean> GreyToBlackObjRefDemographics = new HostedOptionKey<Boolean>(false);
    }
}

