/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.RuntimeAssertionsSupport;
import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.RuntimeCodeInfoAccess;
import com.oracle.svm.core.code.RuntimeCodeInfoMemory;
import com.oracle.svm.core.code.SimpleCodeInfoQueryResult;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.AuxiliaryImageHeap;
import com.oracle.svm.core.genscavenge.CollectionPolicy;
import com.oracle.svm.core.genscavenge.GCAccounting;
import com.oracle.svm.core.genscavenge.GreyToBlackObjRefVisitor;
import com.oracle.svm.core.genscavenge.GreyToBlackObjectVisitor;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapOptions;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.HeapPolicyOptions;
import com.oracle.svm.core.genscavenge.HeapVerifier;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.genscavenge.PinnedObjectImpl;
import com.oracle.svm.core.genscavenge.ReferenceObjectProcessing;
import com.oracle.svm.core.genscavenge.RuntimeCodeCacheWalker;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.StackVerifier;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.genscavenge.ThreadLocalMTWalker;
import com.oracle.svm.core.genscavenge.Timer;
import com.oracle.svm.core.genscavenge.Timers;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.heap.CodeReferenceMapDecoder;
import com.oracle.svm.core.heap.GC;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.heap.NoAllocationVerifier;
import com.oracle.svm.core.heap.ReferenceHandler;
import com.oracle.svm.core.heap.RuntimeCodeCacheCleaner;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalk;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.ThreadStackPrinter;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.NativeVMOperation;
import com.oracle.svm.core.thread.NativeVMOperationData;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.VMError;
import java.lang.ref.Reference;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class GCImpl
implements GC {
    private final GreyToBlackObjRefVisitor greyToBlackObjRefVisitor = new GreyToBlackObjRefVisitor();
    private final GreyToBlackObjectVisitor greyToBlackObjectVisitor = new GreyToBlackObjectVisitor(this.greyToBlackObjRefVisitor);
    private final BlackenImageHeapRootsVisitor blackenImageHeapRootsVisitor = new BlackenImageHeapRootsVisitor();
    private final RuntimeCodeCacheWalker runtimeCodeCacheWalker = new RuntimeCodeCacheWalker(this.greyToBlackObjRefVisitor);
    private final RuntimeCodeCacheCleaner runtimeCodeCacheCleaner = new RuntimeCodeCacheCleaner();
    private final GCAccounting accounting = new GCAccounting();
    private final Timers timers = new Timers();
    private final CollectionVMOperation collectOperation = new CollectionVMOperation();
    private final NoAllocationVerifier noAllocationVerifier = NoAllocationVerifier.factory("GCImpl.GCImpl()", false);
    private final ChunkReleaser chunkReleaser = new ChunkReleaser();
    private final CollectionPolicy policy;
    private boolean completeCollection = false;
    private UnsignedWord sizeBefore = (UnsignedWord)WordFactory.zero();
    private boolean collectionInProgress = false;
    private UnsignedWord collectionEpoch = (UnsignedWord)WordFactory.zero();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    GCImpl(Feature.FeatureAccess access) {
        this.policy = CollectionPolicy.getInitialPolicy(access);
        RuntimeSupport.getRuntimeSupport().addShutdownHook(this::printGCSummary);
    }

    @Override
    public void collect(GCCause cause) {
        this.collect(cause, false);
    }

    private void collect(GCCause cause, boolean forceFullGC) {
        if (!GCImpl.hasNeverCollectPolicy()) {
            UnsignedWord requestingEpoch = this.possibleCollectionPrologue();
            this.collectWithoutAllocating(cause, forceFullGC);
            this.possibleCollectionEpilogue(requestingEpoch);
        }
    }

    @Uninterruptible(reason="Avoid races with other threads that also try to trigger a GC")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of garbage collection.")
    boolean collectWithoutAllocating(GCCause cause, boolean forceFullGC) {
        VMError.guarantee(!GCImpl.hasNeverCollectPolicy());
        int size = SizeOf.get(CollectionVMOperationData.class);
        CollectionVMOperationData data = (CollectionVMOperationData)StackValue.get((int)size);
        UnmanagedMemoryUtil.fill((Pointer)data, WordFactory.unsigned((int)size), (byte)0);
        data.setNativeVMOperation(this.collectOperation);
        data.setCauseId(cause.getId());
        data.setRequestingEpoch(this.getCollectionEpoch());
        data.setForceFullGC(forceFullGC);
        this.enqueueCollectOperation(data);
        return data.getOutOfMemory();
    }

    @Uninterruptible(reason="Used as a transition between uninterruptible and interruptible code", calleeMustBe=false)
    private void enqueueCollectOperation(CollectionVMOperationData data) {
        this.collectOperation.enqueue(data);
    }

    private boolean collectOperation(GCCause cause, UnsignedWord requestingEpoch, boolean forceFullGC) {
        assert (VMOperation.isGCInProgress()) : "Collection should be a VMOperation.";
        assert (this.getCollectionEpoch().equal(requestingEpoch));
        this.timers.mutator.close();
        this.startCollectionOrExit();
        this.timers.resetAllExceptMutator();
        this.collectionEpoch = this.collectionEpoch.add(1);
        ThreadLocalAllocation.disableAndFlushForAllThreads();
        this.printGCBefore(cause.getName());
        boolean outOfMemory = this.collectImpl(forceFullGC);
        HeapPolicy.setEdenAndYoungGenBytes(WordFactory.unsigned((int)0), this.accounting.getYoungChunkBytesAfter());
        this.printGCAfter(cause.getName());
        this.finishCollection();
        this.timers.mutator.open();
        return outOfMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean collectImpl(boolean forceFullGC) {
        boolean outOfMemory;
        block6: {
            GCImpl.precondition();
            this.verifyBeforeGC();
            try (NoAllocationVerifier nav = this.noAllocationVerifier.open();){
                outOfMemory = this.doCollectImpl(forceFullGC);
                if (!outOfMemory) break block6;
                ReferenceObjectProcessing.setSoftReferencesAreWeak(true);
                try {
                    outOfMemory = this.doCollectImpl(true);
                }
                finally {
                    ReferenceObjectProcessing.setSoftReferencesAreWeak(false);
                }
            }
        }
        this.verifyAfterGC();
        GCImpl.postcondition();
        return outOfMemory;
    }

    private boolean doCollectImpl(boolean forceFullGC) {
        CommittedMemoryProvider.get().beforeGarbageCollection();
        this.accounting.beforeCollection();
        try (Timer collectionTimer = this.timers.collection.open();){
            boolean bl = this.completeCollection = forceFullGC || this.policy.collectCompletely();
            if (this.completeCollection) {
                if (HeapPolicyOptions.CollectYoungGenerationSeparately.getValue().booleanValue()) {
                    this.scavenge(true);
                }
                this.scavenge(false);
            } else if (this.policy.collectIncrementally()) {
                this.scavenge(true);
            } else {
                VMError.shouldNotReachHere("A safepoint for a GC was triggered, so why did the GC policy decide not to do a GC?");
            }
        }
        CommittedMemoryProvider.get().afterGarbageCollection(this.completeCollection);
        this.accounting.afterCollection(this.completeCollection, this.timers.collection);
        UnsignedWord maxBytes = HeapPolicy.getMaximumHeapSize();
        UnsignedWord usedBytes = GCImpl.getChunkBytes();
        boolean outOfMemory = usedBytes.aboveThan(maxBytes);
        ReferenceObjectProcessing.afterCollection(usedBytes, maxBytes);
        return outOfMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyBeforeGC() {
        if (SubstrateGCOptions.VerifyHeap.getValue().booleanValue()) {
            try (Timer verifyBeforeTimer = this.timers.verifyBefore.open();){
                boolean success = true;
                success &= HeapVerifier.verify(HeapVerifier.Occasion.BEFORE_COLLECTION);
                if (!(success &= StackVerifier.verifyAllThreads())) {
                    String kind = this.getGCKind();
                    Log.log().string("Heap verification failed before ").string(kind).string(" garbage collection.").newline();
                    VMError.shouldNotReachHere();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAfterGC() {
        if (SubstrateGCOptions.VerifyHeap.getValue().booleanValue()) {
            try (Timer verifyAfterTime = this.timers.verifyAfter.open();){
                boolean success = true;
                success &= HeapVerifier.verify(HeapVerifier.Occasion.AFTER_COLLECTION);
                if (!(success &= StackVerifier.verifyAllThreads())) {
                    String kind = this.getGCKind();
                    Log.log().string("Heap verification failed after ").string(kind).string(" garbage collection.").newline();
                    VMError.shouldNotReachHere();
                }
            }
        }
    }

    private String getGCKind() {
        return this.isCompleteCollection() ? "complete" : "incremental";
    }

    public static UnsignedWord getChunkBytes() {
        UnsignedWord youngBytes = HeapImpl.getHeapImpl().getYoungGeneration().getChunkBytes();
        UnsignedWord oldBytes = HeapImpl.getHeapImpl().getOldGeneration().getChunkBytes();
        return youngBytes.add(oldBytes);
    }

    private void printGCBefore(String cause) {
        Log verboseGCLog = Log.log();
        HeapImpl heap = HeapImpl.getHeapImpl();
        UnsignedWord unsignedWord = this.sizeBefore = SubstrateGCOptions.PrintGC.getValue() != false || HeapOptions.PrintHeapShape.getValue() != false ? GCImpl.getChunkBytes() : (UnsignedWord)WordFactory.zero();
        if (SubstrateGCOptions.VerboseGC.getValue().booleanValue() && this.getCollectionEpoch().equal(1)) {
            verboseGCLog.string("[Heap policy parameters: ").newline();
            verboseGCLog.string("  YoungGenerationSize: ").unsigned((WordBase)HeapPolicy.getMaximumYoungGenerationSize()).newline();
            verboseGCLog.string("      MaximumHeapSize: ").unsigned((WordBase)HeapPolicy.getMaximumHeapSize()).newline();
            verboseGCLog.string("      MinimumHeapSize: ").unsigned((WordBase)HeapPolicy.getMinimumHeapSize()).newline();
            verboseGCLog.string("     AlignedChunkSize: ").unsigned((WordBase)HeapPolicy.getAlignedHeapChunkSize()).newline();
            verboseGCLog.string("  LargeArrayThreshold: ").unsigned((WordBase)HeapPolicy.getLargeArrayThreshold()).string("]").newline();
            if (HeapOptions.PrintHeapShape.getValue().booleanValue()) {
                HeapImpl.getHeapImpl().logImageHeapPartitionBoundaries(verboseGCLog).newline();
            }
        }
        if (SubstrateGCOptions.VerboseGC.getValue().booleanValue()) {
            verboseGCLog.string("[");
            verboseGCLog.string("[");
            long startTime = System.nanoTime();
            if (HeapOptions.PrintGCTimeStamps.getValue().booleanValue()) {
                verboseGCLog.unsigned(TimeUtils.roundNanosToMillis(Timer.getTimeSinceFirstAllocation(startTime))).string(" msec: ");
            } else {
                verboseGCLog.unsigned(startTime);
            }
            verboseGCLog.string(" GC:").string(" before").string("  epoch: ").unsigned((WordBase)this.getCollectionEpoch()).string("  cause: ").string(cause);
            if (HeapOptions.PrintHeapShape.getValue().booleanValue()) {
                heap.report(verboseGCLog);
            }
            verboseGCLog.string("]").newline();
        }
    }

    private void printGCAfter(String cause) {
        Log verboseGCLog = Log.log();
        HeapImpl heap = HeapImpl.getHeapImpl();
        if (SubstrateGCOptions.PrintGC.getValue().booleanValue() || SubstrateGCOptions.VerboseGC.getValue().booleanValue()) {
            if (SubstrateGCOptions.PrintGC.getValue().booleanValue()) {
                Log printGCLog = Log.log();
                UnsignedWord sizeAfter = GCImpl.getChunkBytes();
                printGCLog.string("[");
                if (HeapOptions.PrintGCTimeStamps.getValue().booleanValue()) {
                    long finishNanos = this.timers.collection.getFinish();
                    printGCLog.unsigned(TimeUtils.roundNanosToMillis(Timer.getTimeSinceFirstAllocation(finishNanos))).string(" msec: ");
                }
                printGCLog.string(this.completeCollection ? "Full GC" : "Incremental GC");
                printGCLog.string(" (").string(cause).string(") ");
                printGCLog.unsigned((WordBase)this.sizeBefore.unsignedDivide(1024));
                printGCLog.string("K->");
                printGCLog.unsigned((WordBase)sizeAfter.unsignedDivide(1024)).string("K, ");
                printGCLog.rational(this.timers.collection.getMeasuredNanos(), 1000000000L, 7L).string(" secs");
                printGCLog.string("]").newline();
            }
            if (SubstrateGCOptions.VerboseGC.getValue().booleanValue()) {
                verboseGCLog.string(" [");
                long finishNanos = this.timers.collection.getFinish();
                if (HeapOptions.PrintGCTimeStamps.getValue().booleanValue()) {
                    verboseGCLog.unsigned(TimeUtils.roundNanosToMillis(Timer.getTimeSinceFirstAllocation(finishNanos))).string(" msec: ");
                } else {
                    verboseGCLog.unsigned(finishNanos);
                }
                verboseGCLog.string(" GC:").string(" after ").string("  epoch: ").unsigned((WordBase)this.getCollectionEpoch()).string("  cause: ").string(cause);
                verboseGCLog.string("  policy: ");
                verboseGCLog.string(GCImpl.getPolicy().getName());
                verboseGCLog.string("  type: ").string(this.completeCollection ? "complete" : "incremental");
                if (HeapOptions.PrintHeapShape.getValue().booleanValue()) {
                    heap.report(verboseGCLog);
                }
                if (!HeapOptions.PrintGCTimes.getValue().booleanValue()) {
                    verboseGCLog.newline();
                    verboseGCLog.string("  collection time: ").unsigned(this.timers.collection.getMeasuredNanos()).string(" nanoSeconds");
                } else {
                    this.timers.logAfterCollection(verboseGCLog);
                }
                verboseGCLog.string("]");
                verboseGCLog.string("]").newline();
            }
        }
    }

    private static void precondition() {
        OldGeneration oldGen = HeapImpl.getHeapImpl().getOldGeneration();
        assert (oldGen.getToSpace().isEmpty()) : "oldGen.getToSpace() should be empty before a collection.";
    }

    private static void postcondition() {
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        OldGeneration oldGen = heap.getOldGeneration();
        GCImpl.verbosePostCondition();
        assert (youngGen.getEden().isEmpty()) : "youngGen.getEden() should be empty after a collection.";
        assert (oldGen.getToSpace().isEmpty()) : "oldGen.getToSpace() should be empty after a collection.";
    }

    private static void verbosePostCondition() {
        boolean forceForTesting = false;
        if (GCImpl.runtimeAssertions()) {
            HeapImpl heap = HeapImpl.getHeapImpl();
            YoungGeneration youngGen = heap.getYoungGeneration();
            OldGeneration oldGen = heap.getOldGeneration();
            Log log = Log.log();
            if (!youngGen.getEden().isEmpty()) {
                log.string("[GCImpl.postcondition: Eden space should be empty after a collection.").newline();
                log.string("  These should all be 0:").newline();
                log.string("    Eden space first AlignedChunk:   ").hex((WordBase)youngGen.getEden().getFirstAlignedHeapChunk()).newline();
                log.string("    Eden space last  AlignedChunk:   ").hex((WordBase)youngGen.getEden().getLastAlignedHeapChunk()).newline();
                log.string("    Eden space first UnalignedChunk: ").hex((WordBase)youngGen.getEden().getFirstUnalignedHeapChunk()).newline();
                log.string("    Eden space last  UnalignedChunk: ").hex((WordBase)youngGen.getEden().getLastUnalignedHeapChunk()).newline();
                youngGen.getEden().report(log, true).newline();
                log.string("]").newline();
            }
            for (int i = 0; i < HeapPolicy.getMaxSurvivorSpaces(); ++i) {
                if (youngGen.getSurvivorToSpaceAt(i).isEmpty()) continue;
                log.string("[GCImpl.postcondition: Survivor toSpace should be empty after a collection.").newline();
                log.string("  These should all be 0:").newline();
                log.string("    Survivor space ").signed(i).string(" first AlignedChunk:   ").hex((WordBase)youngGen.getSurvivorToSpaceAt(i).getFirstAlignedHeapChunk()).newline();
                log.string("    Survivor space ").signed(i).string(" last  AlignedChunk:   ").hex((WordBase)youngGen.getSurvivorToSpaceAt(i).getLastAlignedHeapChunk()).newline();
                log.string("    Survivor space ").signed(i).string(" first UnalignedChunk: ").hex((WordBase)youngGen.getSurvivorToSpaceAt(i).getFirstUnalignedHeapChunk()).newline();
                log.string("    Survivor space ").signed(i).string(" last  UnalignedChunk: ").hex((WordBase)youngGen.getSurvivorToSpaceAt(i).getLastUnalignedHeapChunk()).newline();
                youngGen.getSurvivorToSpaceAt(i).report(log, true).newline();
                log.string("]").newline();
            }
            if (!oldGen.getToSpace().isEmpty()) {
                log.string("[GCImpl.postcondition: oldGen toSpace should be empty after a collection.").newline();
                log.string("  These should all be 0:").newline();
                log.string("    oldGen toSpace first AlignedChunk:   ").hex((WordBase)oldGen.getToSpace().getFirstAlignedHeapChunk()).newline();
                log.string("    oldGen toSpace last  AlignedChunk:   ").hex((WordBase)oldGen.getToSpace().getLastAlignedHeapChunk()).newline();
                log.string("    oldGen.toSpace first UnalignedChunk: ").hex((WordBase)oldGen.getToSpace().getFirstUnalignedHeapChunk()).newline();
                log.string("    oldGen.toSpace last  UnalignedChunk: ").hex((WordBase)oldGen.getToSpace().getLastUnalignedHeapChunk()).newline();
                oldGen.getToSpace().report(log, true).newline();
                oldGen.getFromSpace().report(log, true).newline();
                log.string("]").newline();
            }
        }
    }

    @Fold
    static boolean runtimeAssertions() {
        return RuntimeAssertionsSupport.singleton().desiredAssertionStatus(GCImpl.class);
    }

    @Fold
    public static GCImpl getGCImpl() {
        GCImpl gcImpl = HeapImpl.getHeapImpl().getGCImpl();
        assert (gcImpl != null);
        return gcImpl;
    }

    @Override
    public void collectCompletely(GCCause cause) {
        this.collect(cause, true);
    }

    public boolean isCompleteCollection() {
        return this.completeCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scavenge(boolean fromDirtyRoots) {
        try (GreyToBlackObjRefVisitor.Counters counters = this.greyToBlackObjRefVisitor.openCounters();){
            try (Timer rootScanTimer = this.timers.rootScan.open();){
                if (fromDirtyRoots) {
                    this.cheneyScanFromDirtyRoots();
                } else {
                    this.cheneyScanFromRoots();
                }
            }
            if (DeoptimizationSupport.enabled()) {
                try (Timer cleanCodeCacheTimer = this.timers.cleanCodeCache.open();){
                    this.cleanRuntimeCodeCache();
                }
            }
            try (Timer referenceObjectsTimer = this.timers.referenceObjects.open();){
                Reference<?> newlyPendingList = ReferenceObjectProcessing.processRememberedReferences();
                HeapImpl.getHeapImpl().addToReferencePendingList(newlyPendingList);
            }
            try (Timer releaseSpacesTimer = this.timers.releaseSpaces.open();){
                assert (this.chunkReleaser.isEmpty());
                this.releaseSpaces();
                this.chunkReleaser.release();
            }
            GCImpl.swapSpaces();
        }
    }

    private void walkRuntimeCodeCache() {
        try (Timer walkRuntimeCodeCacheTimer = this.timers.walkRuntimeCodeCache.open();){
            RuntimeCodeInfoMemory.singleton().walkRuntimeMethodsDuringGC(this.runtimeCodeCacheWalker);
        }
    }

    private void cleanRuntimeCodeCache() {
        try (Timer cleanRuntimeCodeCacheTimer = this.timers.cleanRuntimeCodeCache.open();){
            RuntimeCodeInfoMemory.singleton().walkRuntimeMethodsDuringGC(this.runtimeCodeCacheCleaner);
        }
    }

    private void cheneyScanFromRoots() {
        try (Timer cheneyScanFromRootsTimer = this.timers.cheneyScanFromRoots.open();){
            GCImpl.prepareForPromotion(false);
            this.promoteChunksWithPinnedObjects();
            this.blackenStackRoots();
            this.walkThreadLocals();
            this.blackenImageHeapRoots();
            this.scanGreyObjects(false);
            if (DeoptimizationSupport.enabled()) {
                this.walkRuntimeCodeCache();
                this.scanGreyObjects(false);
            }
            this.greyToBlackObjectVisitor.reset();
        }
    }

    private void cheneyScanFromDirtyRoots() {
        try (Timer cheneyScanFromDirtyRootsTimer = this.timers.cheneyScanFromDirtyRoots.open();){
            OldGeneration oldGen = HeapImpl.getHeapImpl().getOldGeneration();
            oldGen.emptyFromSpaceIntoToSpace();
            GCImpl.prepareForPromotion(true);
            this.promoteChunksWithPinnedObjects();
            this.blackenDirtyCardRoots();
            this.blackenStackRoots();
            this.walkThreadLocals();
            this.blackenDirtyImageHeapRoots();
            this.scanGreyObjects(true);
            if (DeoptimizationSupport.enabled()) {
                this.walkRuntimeCodeCache();
                this.scanGreyObjects(true);
            }
            this.greyToBlackObjectVisitor.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promoteChunksWithPinnedObjects() {
        try (Timer promotePinnedObjectsTimer = this.timers.promotePinnedObjects.open();){
            PinnedObjectImpl pinnedObjects = GCImpl.removeClosedPinnedObjects(PinnedObjectImpl.getPinnedObjects());
            PinnedObjectImpl.setPinnedObjects(pinnedObjects);
            for (PinnedObjectImpl cur = pinnedObjects; cur != null; cur = cur.getNext()) {
                assert (cur.isOpen());
                GCImpl.promotePinnedObject(cur);
            }
        }
    }

    private static PinnedObjectImpl removeClosedPinnedObjects(PinnedObjectImpl list) {
        PinnedObjectImpl firstOpen = null;
        PinnedObjectImpl lastOpen = null;
        for (PinnedObjectImpl cur = list; cur != null; cur = cur.getNext()) {
            if (!cur.isOpen()) continue;
            if (firstOpen == null) {
                assert (lastOpen == null);
                firstOpen = cur;
                lastOpen = cur;
                continue;
            }
            lastOpen.setNext(cur);
            lastOpen = cur;
        }
        if (lastOpen != null) {
            lastOpen.setNext(null);
        }
        return firstOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NeverInline(value="Starting a stack walk in the caller frame. Note that we could start the stack frame also further down the stack, because GC stack frames must not access any objects that are processed by the GC. But we don't store stack frame information for the first frame we would need to process.")
    @Uninterruptible(reason="Required by called JavaStackWalker methods. We are at a safepoint during GC, so it does not change anything for this method.", calleeMustBe=false)
    private void blackenStackRoots() {
        try (Timer blackenStackRootsTimer = this.timers.blackenStackRoots.open();){
            Pointer sp = KnownIntrinsics.readCallerStackPointer();
            CodePointer ip = KnownIntrinsics.readReturnAddress();
            JavaStackWalk walk = (JavaStackWalk)StackValue.get(JavaStackWalk.class);
            JavaStackWalker.initWalk(walk, sp, ip);
            this.walkStack(walk);
            if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                IsolateThread vmThread = VMThreads.firstThread();
                while (vmThread.isNonNull()) {
                    if (vmThread != CurrentIsolate.getCurrentThread() && JavaStackWalker.initWalk(walk, vmThread)) {
                        this.walkStack(walk);
                    }
                    vmThread = VMThreads.nextThread(vmThread);
                }
            }
        }
    }

    @Uninterruptible(reason="Required by called JavaStackWalker methods. We are at a safepoint during GC, so it does not change anything for this method.", calleeMustBe=false)
    private void walkStack(JavaStackWalk walk) {
        DeoptimizedFrame deoptFrame;
        SimpleCodeInfoQueryResult queryResult;
        assert (VMOperation.isGCInProgress()) : "This methods accesses a CodeInfo without a tether";
        do {
            queryResult = (SimpleCodeInfoQueryResult)StackValue.get(SimpleCodeInfoQueryResult.class);
            Pointer sp = walk.getSP();
            CodePointer ip = walk.getPossiblyStaleIP();
            CodeInfo codeInfo = CodeInfoAccess.convert(walk.getIPCodeInfo());
            deoptFrame = Deoptimizer.checkDeoptimized(sp);
            if (deoptFrame == null) {
                if (codeInfo.isNull()) {
                    throw JavaStackWalker.reportUnknownFrameEncountered(sp, ip, deoptFrame);
                }
                CodeInfoAccess.lookupCodeInfo(codeInfo, CodeInfoAccess.relativeIP(codeInfo, ip), queryResult);
                assert (Deoptimizer.checkDeoptimized(sp) == null) : "We are at a safepoint, so no deoptimization can have happened even though looking up the code info is not uninterruptible";
                NonmovableArray<Byte> referenceMapEncoding = CodeInfoAccess.getStackReferenceMapEncoding(codeInfo);
                long referenceMapIndex = queryResult.getReferenceMapIndex();
                if (referenceMapIndex == -1L) {
                    throw CodeInfoTable.reportNoReferenceMap(sp, ip, codeInfo);
                }
                CodeReferenceMapDecoder.walkOffsetsFromPointer((PointerBase)sp, referenceMapEncoding, referenceMapIndex, this.greyToBlackObjRefVisitor);
            }
            if (!DeoptimizationSupport.enabled() || codeInfo == CodeInfoTable.getImageCodeInfo()) continue;
            RuntimeCodeInfoAccess.walkStrongReferences(codeInfo, this.greyToBlackObjRefVisitor);
            RuntimeCodeInfoAccess.walkWeakReferences(codeInfo, this.greyToBlackObjRefVisitor);
        } while (JavaStackWalker.continueWalk(walk, queryResult, deoptFrame));
    }

    private void walkThreadLocals() {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            try (Timer walkThreadLocalsTimer = this.timers.walkThreadLocals.open();){
                ThreadLocalMTWalker.walk(this.greyToBlackObjRefVisitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blackenDirtyImageHeapRoots() {
        if (!HeapImpl.usesImageHeapCardMarking()) {
            this.blackenImageHeapRoots();
            return;
        }
        try (Timer blackenImageHeapRootsTimer = this.timers.blackenImageHeapRoots.open();){
            ImageHeapInfo auxInfo;
            ImageHeapInfo info = HeapImpl.getImageHeapInfo();
            this.blackenDirtyImageHeapChunkRoots(info.getFirstAlignedImageHeapChunk(), info.getFirstUnalignedImageHeapChunk());
            if (AuxiliaryImageHeap.isPresent() && (auxInfo = AuxiliaryImageHeap.singleton().getImageHeapInfo()) != null) {
                this.blackenDirtyImageHeapChunkRoots(info.getFirstAlignedImageHeapChunk(), info.getFirstUnalignedImageHeapChunk());
            }
        }
    }

    private void blackenDirtyImageHeapChunkRoots(AlignedHeapChunk.AlignedHeader firstAligned, UnalignedHeapChunk.UnalignedHeader firstUnaligned) {
        AlignedHeapChunk.AlignedHeader aligned = firstAligned;
        while (aligned.isNonNull()) {
            RememberedSet.get().walkDirtyObjects(aligned, this.greyToBlackObjectVisitor);
            aligned = HeapChunk.getNext(aligned);
        }
        UnalignedHeapChunk.UnalignedHeader unaligned = firstUnaligned;
        while (unaligned.isNonNull()) {
            RememberedSet.get().walkDirtyObjects(unaligned, this.greyToBlackObjectVisitor);
            unaligned = HeapChunk.getNext(unaligned);
        }
    }

    private void blackenImageHeapRoots() {
        try (Timer blackenImageHeapRootsTimer = this.timers.blackenImageHeapRoots.open();){
            HeapImpl.getHeapImpl().walkNativeImageHeapRegions(this.blackenImageHeapRootsVisitor);
        }
    }

    private void blackenDirtyCardRoots() {
        try (Timer blackenDirtyCardRootsTimer = this.timers.blackenDirtyCardRoots.open();){
            Space oldGenToSpace = HeapImpl.getHeapImpl().getOldGeneration().getToSpace();
            RememberedSet.get().walkDirtyObjects(oldGenToSpace, this.greyToBlackObjectVisitor);
        }
    }

    private static void prepareForPromotion(boolean isIncremental) {
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        oldGen.prepareForPromotion();
        if (isIncremental) {
            heap.getYoungGeneration().prepareForPromotion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanGreyObjects(boolean isIncremental) {
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        try (Timer scanGreyObjectsTimer = this.timers.scanGreyObjects.open();){
            if (isIncremental) {
                GCImpl.scanGreyObjectsLoop();
            } else {
                oldGen.scanGreyObjects();
            }
        }
    }

    private static void scanGreyObjectsLoop() {
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        OldGeneration oldGen = heap.getOldGeneration();
        for (boolean hasGrey = true; hasGrey; hasGrey |= oldGen.scanGreyObjects()) {
            hasGrey = youngGen.scanGreyObjects();
        }
    }

    private static void promotePinnedObject(PinnedObjectImpl pinned) {
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        Object referent = pinned.getObject();
        if (referent != null && !heap.isInImageHeap(referent)) {
            oldGen.promoteObjectChunk(referent);
        }
    }

    private static void swapSpaces() {
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        heap.getYoungGeneration().swapSpaces();
        oldGen.swapSpaces();
    }

    private void releaseSpaces() {
        HeapImpl heap = HeapImpl.getHeapImpl();
        heap.getYoungGeneration().releaseSpaces(this.chunkReleaser);
        if (this.completeCollection) {
            heap.getOldGeneration().releaseSpaces(this.chunkReleaser);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean isCollectionInProgress() {
        return this.collectionInProgress;
    }

    private void startCollectionOrExit() {
        CollectionInProgressError.exitIf(this.collectionInProgress);
        this.collectionInProgress = true;
    }

    private void finishCollection() {
        assert (this.collectionInProgress);
        this.collectionInProgress = false;
    }

    UnsignedWord possibleCollectionPrologue() {
        return this.getCollectionEpoch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void possibleCollectionEpilogue(UnsignedWord requestingEpoch) {
        if (requestingEpoch.aboveOrEqual(this.getCollectionEpoch())) {
            return;
        }
        if (VMOperation.isInProgress()) {
            return;
        }
        if (!JavaThreads.currentJavaThreadInitialized()) {
            return;
        }
        Timer refsTimer = new Timer("Enqueuing pending references and invoking internal cleaners");
        try (Timer timer = refsTimer.open();){
            ReferenceHandler.maybeProcessCurrentlyPending();
        }
        if (SubstrateGCOptions.VerboseGC.getValue().booleanValue() && HeapOptions.PrintGCTimes.getValue().booleanValue()) {
            Timers.logOneTimer(Log.log(), "[GC epilogue reference processing: ", refsTimer);
            Log.log().string("]");
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord getCollectionEpoch() {
        return this.collectionEpoch;
    }

    public GCAccounting getAccounting() {
        return this.accounting;
    }

    @Fold
    public static CollectionPolicy getPolicy() {
        return GCImpl.getGCImpl().policy;
    }

    @Fold
    public static boolean hasNeverCollectPolicy() {
        return GCImpl.getPolicy() instanceof CollectionPolicy.NeverCollect;
    }

    GreyToBlackObjectVisitor getGreyToBlackObjectVisitor() {
        return this.greyToBlackObjectVisitor;
    }

    private void printGCSummary() {
        if (!HeapOptions.PrintGCSummary.getValue().booleanValue()) {
            return;
        }
        Log log = Log.log();
        String prefix = "PrintGCSummary: ";
        log.string("PrintGCSummary: ").string("YoungGenerationSize: ").unsigned((WordBase)HeapPolicy.getMaximumYoungGenerationSize()).newline();
        log.string("PrintGCSummary: ").string("MinimumHeapSize: ").unsigned((WordBase)HeapPolicy.getMinimumHeapSize()).newline();
        log.string("PrintGCSummary: ").string("MaximumHeapSize: ").unsigned((WordBase)HeapPolicy.getMaximumHeapSize()).newline();
        log.string("PrintGCSummary: ").string("AlignedChunkSize: ").unsigned((WordBase)HeapPolicy.getAlignedHeapChunkSize()).newline();
        JavaVMOperation.enqueueBlockingSafepoint("PrintGCSummaryShutdownHook", ThreadLocalAllocation::disableAndFlushForAllThreads);
        HeapImpl heap = HeapImpl.getHeapImpl();
        Space edenSpace = heap.getYoungGeneration().getEden();
        UnsignedWord youngChunkBytes = edenSpace.getChunkBytes();
        UnsignedWord youngObjectBytes = edenSpace.computeObjectBytes();
        UnsignedWord allocatedChunkBytes = this.accounting.getAllocatedChunkBytes().add(youngChunkBytes);
        UnsignedWord allocatedObjectBytes = this.accounting.getAllocatedObjectBytes().add(youngObjectBytes);
        log.string("PrintGCSummary: ").string("CollectedTotalChunkBytes: ").signed((WordBase)this.accounting.getCollectedTotalChunkBytes()).newline();
        log.string("PrintGCSummary: ").string("CollectedTotalObjectBytes: ").signed((WordBase)this.accounting.getCollectedTotalObjectBytes()).newline();
        log.string("PrintGCSummary: ").string("AllocatedNormalChunkBytes: ").signed((WordBase)allocatedChunkBytes).newline();
        log.string("PrintGCSummary: ").string("AllocatedNormalObjectBytes: ").signed((WordBase)allocatedObjectBytes).newline();
        long incrementalNanos = this.accounting.getIncrementalCollectionTotalNanos();
        log.string("PrintGCSummary: ").string("IncrementalGCCount: ").signed(this.accounting.getIncrementalCollectionCount()).newline();
        log.string("PrintGCSummary: ").string("IncrementalGCNanos: ").signed(incrementalNanos).newline();
        long completeNanos = this.accounting.getCompleteCollectionTotalNanos();
        log.string("PrintGCSummary: ").string("CompleteGCCount: ").signed(this.accounting.getCompleteCollectionCount()).newline();
        log.string("PrintGCSummary: ").string("CompleteGCNanos: ").signed(completeNanos).newline();
        long gcNanos = incrementalNanos + completeNanos;
        long mutatorNanos = this.timers.mutator.getMeasuredNanos();
        long totalNanos = gcNanos + mutatorNanos;
        long roundedGCLoad = 0L < totalNanos ? TimeUtils.roundedDivide(100L * gcNanos, totalNanos) : 0L;
        log.string("PrintGCSummary: ").string("GCNanos: ").signed(gcNanos).newline();
        log.string("PrintGCSummary: ").string("TotalNanos: ").signed(totalNanos).newline();
        log.string("PrintGCSummary: ").string("GCLoadPercent: ").signed(roundedGCLoad).newline();
    }

    public static class ChunkReleaser {
        private AlignedHeapChunk.AlignedHeader firstAligned;
        private UnalignedHeapChunk.UnalignedHeader firstUnaligned;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        ChunkReleaser() {
        }

        public boolean isEmpty() {
            return this.firstAligned.isNull() && this.firstUnaligned.isNull();
        }

        public void add(AlignedHeapChunk.AlignedHeader chunks) {
            if (chunks.isNonNull()) {
                assert (HeapChunk.getPrevious(chunks).isNull()) : "prev must be null";
                if (this.firstAligned.isNonNull()) {
                    AlignedHeapChunk.AlignedHeader lastNewChunk = ChunkReleaser.getLast(chunks);
                    HeapChunk.setNext(lastNewChunk, this.firstAligned);
                    HeapChunk.setPrevious(this.firstAligned, lastNewChunk);
                }
                this.firstAligned = chunks;
            }
        }

        public void add(UnalignedHeapChunk.UnalignedHeader chunks) {
            if (chunks.isNonNull()) {
                assert (HeapChunk.getPrevious(chunks).isNull()) : "prev must be null";
                if (this.firstUnaligned.isNonNull()) {
                    UnalignedHeapChunk.UnalignedHeader lastNewChunk = ChunkReleaser.getLast(chunks);
                    HeapChunk.setNext(lastNewChunk, this.firstUnaligned);
                    HeapChunk.setPrevious(this.firstUnaligned, lastNewChunk);
                }
                this.firstUnaligned = chunks;
            }
        }

        void release() {
            if (this.firstAligned.isNonNull()) {
                HeapImpl.getChunkProvider().consumeAlignedChunks(this.firstAligned);
                this.firstAligned = (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
            }
            if (this.firstUnaligned.isNonNull()) {
                HeapChunkProvider.consumeUnalignedChunks(this.firstUnaligned);
                this.firstUnaligned = (UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer();
            }
        }

        private static <T extends HeapChunk.Header<T>> T getLast(T chunks) {
            T prev = chunks;
            Object next = HeapChunk.getNext(prev);
            while (next.isNonNull()) {
                prev = next;
                next = HeapChunk.getNext(prev);
            }
            return prev;
        }
    }

    @RawStructure
    private static interface CollectionVMOperationData
    extends NativeVMOperationData {
        @RawField
        public int getCauseId();

        @RawField
        public void setCauseId(int var1);

        @RawField
        public UnsignedWord getRequestingEpoch();

        @RawField
        public void setRequestingEpoch(UnsignedWord var1);

        @RawField
        public boolean getForceFullGC();

        @RawField
        public void setForceFullGC(boolean var1);

        @RawField
        public boolean getOutOfMemory();

        @RawField
        public void setOutOfMemory(boolean var1);
    }

    private static class CollectionVMOperation
    extends NativeVMOperation {
        CollectionVMOperation() {
            super("Garbage collection", VMOperation.SystemEffect.SAFEPOINT);
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected boolean isGC() {
            return true;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while collecting")
        protected void operate(NativeVMOperationData data) {
            ImplicitExceptions.activateImplicitExceptionsAreFatal();
            try {
                CollectionVMOperationData d = (CollectionVMOperationData)data;
                boolean outOfMemory = HeapImpl.getHeapImpl().getGCImpl().collectOperation(GCCause.fromId(d.getCauseId()), d.getRequestingEpoch(), d.getForceFullGC());
                d.setOutOfMemory(outOfMemory);
            }
            catch (Throwable t) {
                throw VMError.shouldNotReachHere(t);
            }
            finally {
                ImplicitExceptions.deactivateImplicitExceptionsAreFatal();
            }
        }

        @Override
        protected boolean hasWork(NativeVMOperationData data) {
            CollectionVMOperationData d = (CollectionVMOperationData)data;
            return HeapImpl.getHeapImpl().getGCImpl().getCollectionEpoch().equal(d.getRequestingEpoch());
        }
    }

    static final class CollectionInProgressError
    extends Error {
        private static final CollectionInProgressError SINGLETON = new CollectionInProgressError();

        static void exitIf(boolean state) {
            if (state) {
                Log failure = Log.log();
                failure.string("[CollectionInProgressError:");
                failure.newline();
                ThreadStackPrinter.printBacktrace();
                failure.string("]").newline();
                throw SINGLETON;
            }
        }

        private CollectionInProgressError() {
        }
    }

    private class BlackenImageHeapRootsVisitor
    implements MemoryWalker.ImageHeapRegionVisitor {
        private BlackenImageHeapRootsVisitor() {
        }

        @Override
        public <T> boolean visitNativeImageHeapRegion(T region, MemoryWalker.NativeImageHeapRegionAccess<T> access) {
            if (access.containsReferences(region) && access.isWritable(region)) {
                access.visitObjects(region, GCImpl.this.greyToBlackObjectVisitor);
            }
            return true;
        }
    }
}

