/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.TypeResult;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.ReflectionConfigurationParserDelegate;
import com.oracle.svm.core.util.json.JSONParser;
import com.oracle.svm.core.util.json.JSONParserException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class ReflectionConfigurationParser<T>
extends ConfigurationParser {
    private static final String CONSTRUCTOR_NAME = "<init>";
    private final ReflectionConfigurationParserDelegate<T> delegate;
    private final boolean allowIncompleteClasspath;

    public ReflectionConfigurationParser(ReflectionConfigurationParserDelegate<T> delegate) {
        this(delegate, false);
    }

    public ReflectionConfigurationParser(ReflectionConfigurationParserDelegate<T> delegate, boolean allowIncompleteClasspath) {
        this.delegate = delegate;
        this.allowIncompleteClasspath = allowIncompleteClasspath;
    }

    @Override
    public void parseAndRegister(Reader reader) throws IOException {
        JSONParser parser = new JSONParser(reader);
        Object json = parser.parse();
        this.parseClassArray(ReflectionConfigurationParser.asList(json, "first level of document must be an array of class descriptors"));
    }

    private void parseClassArray(List<Object> classes) {
        for (Object clazz : classes) {
            this.parseClass(ReflectionConfigurationParser.asMap(clazz, "second level of document must be class descriptor objects"));
        }
    }

    private void parseClass(Map<String, Object> data) {
        Object classObject = data.get("name");
        if (classObject == null) {
            throw new JSONParserException("Missing attribute 'name' in class descriptor object");
        }
        String className = ReflectionConfigurationParser.asString(classObject, "name");
        TypeResult<T> result = this.delegate.resolveTypeResult(className);
        if (!result.isPresent()) {
            this.handleError("Could not resolve " + className + " for reflection configuration.", result.getException());
            return;
        }
        T clazz = result.get();
        this.delegate.registerType(clazz);
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            try {
                if (name.equals("name")) continue;
                if (name.equals("allDeclaredConstructors")) {
                    if (!ReflectionConfigurationParser.asBoolean(value, "allDeclaredConstructors")) continue;
                    this.delegate.registerDeclaredConstructors(clazz);
                    continue;
                }
                if (name.equals("allPublicConstructors")) {
                    if (!ReflectionConfigurationParser.asBoolean(value, "allPublicConstructors")) continue;
                    this.delegate.registerPublicConstructors(clazz);
                    continue;
                }
                if (name.equals("allDeclaredMethods")) {
                    if (!ReflectionConfigurationParser.asBoolean(value, "allDeclaredMethods")) continue;
                    this.delegate.registerDeclaredMethods(clazz);
                    continue;
                }
                if (name.equals("allPublicMethods")) {
                    if (!ReflectionConfigurationParser.asBoolean(value, "allPublicMethods")) continue;
                    this.delegate.registerPublicMethods(clazz);
                    continue;
                }
                if (name.equals("allDeclaredFields")) {
                    if (!ReflectionConfigurationParser.asBoolean(value, "allDeclaredFields")) continue;
                    this.delegate.registerDeclaredFields(clazz);
                    continue;
                }
                if (name.equals("allPublicFields")) {
                    if (!ReflectionConfigurationParser.asBoolean(value, "allPublicFields")) continue;
                    this.delegate.registerPublicFields(clazz);
                    continue;
                }
                if (name.equals("allDeclaredClasses")) {
                    if (!ReflectionConfigurationParser.asBoolean(value, "allDeclaredClasses")) continue;
                    this.delegate.registerDeclaredClasses(clazz);
                    continue;
                }
                if (name.equals("allPublicClasses")) {
                    if (!ReflectionConfigurationParser.asBoolean(value, "allPublicClasses")) continue;
                    this.delegate.registerPublicClasses(clazz);
                    continue;
                }
                if (name.equals("methods")) {
                    this.parseMethods(ReflectionConfigurationParser.asList(value, "Attribute 'methods' must be an array of method descriptors"), clazz);
                    continue;
                }
                if (name.equals("fields")) {
                    this.parseFields(ReflectionConfigurationParser.asList(value, "Attribute 'fields' must be an array of field descriptors"), clazz);
                    continue;
                }
                throw new JSONParserException("Unknown attribute '" + name + "' (supported attributes: allDeclaredConstructors, allPublicConstructors, allDeclaredMethods, allPublicMethods, allDeclaredFields, allPublicFields, methods, fields) in defintion of class " + this.delegate.getTypeName(clazz));
            }
            catch (LinkageError e) {
                this.handleError("Could not register " + this.delegate.getTypeName(clazz) + ": " + name + " for reflection.", e);
            }
        }
    }

    private void parseFields(List<Object> fields, T clazz) {
        for (Object field : fields) {
            this.parseField(ReflectionConfigurationParser.asMap(field, "Elements of 'fields' array must be field descriptor objects"), clazz);
        }
    }

    private void parseField(Map<String, Object> data, T clazz) {
        String fieldName = null;
        boolean allowWrite = false;
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String propertyName = entry.getKey();
            if (propertyName.equals("name")) {
                fieldName = ReflectionConfigurationParser.asString(entry.getValue(), "name");
                continue;
            }
            if (propertyName.equals("allowWrite")) {
                allowWrite = ReflectionConfigurationParser.asBoolean(entry.getValue(), "allowWrite");
                continue;
            }
            if (propertyName.equals("allowUnsafeAccess")) continue;
            throw new JSONParserException("Unknown attribute '" + propertyName + "' (supported attributes: 'name') in definition of field for class '" + this.delegate.getTypeName(clazz) + "'");
        }
        if (fieldName == null) {
            throw new JSONParserException("Missing attribute 'name' in definition of field for class " + this.delegate.getTypeName(clazz));
        }
        try {
            this.delegate.registerField(clazz, fieldName, allowWrite);
        }
        catch (NoSuchFieldException e) {
            this.handleError("Field " + this.formatField(clazz, fieldName) + " not found.");
        }
        catch (LinkageError e) {
            this.handleError("Could not register field " + this.formatField(clazz, fieldName) + " for reflection.", e);
        }
    }

    private void parseMethods(List<Object> methods, T clazz) {
        for (Object method : methods) {
            this.parseMethod(ReflectionConfigurationParser.asMap(method, "Elements of 'methods' array must be method descriptor objects"), clazz);
        }
    }

    private void parseMethod(Map<String, Object> data, T clazz) {
        block13: {
            String methodName = null;
            List<T> methodParameterTypes = null;
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                String propertyName = entry.getKey();
                if (propertyName.equals("name")) {
                    methodName = ReflectionConfigurationParser.asString(entry.getValue(), "name");
                    continue;
                }
                if (propertyName.equals("parameterTypes")) {
                    methodParameterTypes = this.parseMethodParameters(clazz, methodName, ReflectionConfigurationParser.asList(entry.getValue(), "Attribute 'parameterTypes' must be a list of type names"));
                    if (methodParameterTypes != null) continue;
                    return;
                }
                throw new JSONParserException("Unknown attribute '" + propertyName + "' (supported attributes: 'name', 'parameterTypes') in definition of method for class '" + this.delegate.getTypeName(clazz) + "'");
            }
            if (methodName == null) {
                throw new JSONParserException("Missing attribute 'name' in definition of method for class '" + this.delegate.getTypeName(clazz) + "'");
            }
            boolean isConstructor = CONSTRUCTOR_NAME.equals(methodName);
            if (methodParameterTypes != null) {
                try {
                    if (isConstructor) {
                        this.delegate.registerConstructor(clazz, methodParameterTypes);
                        break block13;
                    }
                    this.delegate.registerMethod(clazz, methodName, methodParameterTypes);
                }
                catch (NoSuchMethodException e) {
                    this.handleError("Method " + this.formatMethod(clazz, methodName, methodParameterTypes) + " not found.");
                }
                catch (LinkageError e) {
                    this.handleError("Could not register method " + this.formatMethod(clazz, methodName, methodParameterTypes) + " for reflection.", e);
                }
            } else {
                try {
                    boolean found = isConstructor ? this.delegate.registerAllConstructors(clazz) : this.delegate.registerAllMethodsWithName(clazz, methodName);
                    if (!found) {
                        throw new JSONParserException("Method " + this.formatMethod(clazz, methodName) + " not found");
                    }
                }
                catch (LinkageError e) {
                    this.handleError("Could not register method " + this.formatMethod(clazz, methodName) + " for reflection.", e);
                }
            }
        }
    }

    private List<T> parseMethodParameters(T clazz, String methodName, List<Object> types) {
        ArrayList<T> result = new ArrayList<T>();
        for (Object type : types) {
            String typeName = ReflectionConfigurationParser.asString(type, "types");
            TypeResult<T> typeResult = this.delegate.resolveTypeResult(typeName);
            if (!typeResult.isPresent()) {
                this.handleError("Could not register method " + this.formatMethod(clazz, methodName) + " for reflection.", typeResult.getException());
                return null;
            }
            result.add(typeResult.get());
        }
        return result;
    }

    private static String formatError(Throwable e) {
        return e.getClass().getTypeName() + ": " + e.getMessage();
    }

    private String formatField(T clazz, String fieldName) {
        return this.delegate.getTypeName(clazz) + '.' + fieldName;
    }

    private String formatMethod(T clazz, String methodName) {
        return this.formatMethod(clazz, methodName, Collections.emptyList());
    }

    private String formatMethod(T clazz, String methodName, List<T> paramTypes) {
        String parameterTypeNames = paramTypes.stream().map(this.delegate::getSimpleName).collect(Collectors.joining(", "));
        return this.delegate.getTypeName(clazz) + '.' + methodName + '(' + parameterTypeNames + ')';
    }

    private void handleError(String message) {
        this.handleError(message, null);
    }

    private void handleError(String msg, Throwable cause) {
        String message = msg;
        if (cause != null) {
            message = message + " Reason: " + ReflectionConfigurationParser.formatError(cause) + '.';
        }
        if (!this.allowIncompleteClasspath) {
            throw new JSONParserException(message + " To allow unresolvable reflection configuration, use option -H:+AllowIncompleteClasspath");
        }
        System.out.println("WARNING: " + message);
    }
}

