/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.ThreadStackPrinter;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalBytes;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfos;
import com.oracle.svm.core.util.Counter;
import java.util.Arrays;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class SubstrateDiagnostics {
    private static final int REGISTERS = 1;
    private static final int FRAME_ANCHORS = 2;
    private static final int DEOPT_STUB_POINTERS = 4;
    private static final int TOP_FRAME = 8;
    private static final int THREADS = 16;
    private static final int THREAD_STATES = 32;
    private static final int VM_OPERATIONS = 64;
    private static final int RUNTIME_COMPILATIONS = 128;
    private static final int COUNTERS = 256;
    private static final int CURRENT_THREAD_RAW_STACKTRACE = 512;
    private static final int CURRENT_THREAD_DECODED_STACKTRACE = 1024;
    private static final int OTHER_STACK_TRACES = 2048;
    private static final ThreadStackPrinter.Stage0StackFramePrintVisitor[] PRINT_VISITORS = new ThreadStackPrinter.Stage0StackFramePrintVisitor[]{ThreadStackPrinter.Stage0StackFramePrintVisitor.SINGLETON, ThreadStackPrinter.Stage1StackFramePrintVisitor.SINGLETON, ThreadStackPrinter.StackFramePrintVisitor.SINGLETON};
    private static final UninterruptibleUtils.AtomicWord<IsolateThread> diagnosticThread = new UninterruptibleUtils.AtomicWord();
    private static final FastThreadLocalBytes<CCharPointer> threadOnlyAttachedForCrashHandler = FastThreadLocalFactory.createBytes(() -> 1);
    private static volatile int diagnosticSections = 0;
    private static volatile int diagnosticThunkIndex = 0;

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setOnlyAttachedForCrashHandler(IsolateThread thread) {
        threadOnlyAttachedForCrashHandler.getAddress(thread).write((byte)1);
    }

    private static boolean isThreadOnlyAttachedForCrashHandler(IsolateThread thread) {
        return threadOnlyAttachedForCrashHandler.getAddress(thread).read() != 0;
    }

    public static boolean isInProgress() {
        return diagnosticThread.get().isNonNull();
    }

    public static void print(Log log, Pointer sp, CodePointer ip) {
        SubstrateDiagnostics.print(log, sp, ip, (RegisterDumper.Context)WordFactory.nullPointer());
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate during printing diagnostics.")
    static void print(Log log, Pointer sp, CodePointer ip, RegisterDumper.Context context) {
        log.newline();
        IsolateThread currentThread = CurrentIsolate.getCurrentThread();
        if (!diagnosticThread.compareAndSet((IsolateThread)WordFactory.nullPointer(), currentThread) && diagnosticThread.get().notEqual((ComparableWord)currentThread)) {
            log.string("Error: printDiagnostics already in progress by another thread.").newline();
            log.newline();
            return;
        }
        if (diagnosticSections > 0) {
            log.newline();
            log.string("An error occurred while printing diagnostics. The remaining part of this section will be skipped.").newline();
            log.resetIndentation();
        }
        if (SubstrateDiagnostics.shouldPrint(1)) {
            try {
                SubstrateDiagnostics.dumpRegisters(log, context);
            }
            catch (Exception e) {
                SubstrateDiagnostics.dumpException(log, "dumpRegisters", e);
            }
        }
        if (SubstrateDiagnostics.shouldPrint(2)) {
            try {
                SubstrateDiagnostics.dumpJavaFrameAnchors(log);
            }
            catch (Exception e) {
                SubstrateDiagnostics.dumpException(log, "dumpJavaFrameAnchors", e);
            }
        }
        if (SubstrateDiagnostics.shouldPrint(4)) {
            try {
                SubstrateDiagnostics.dumpDeoptStubPointer(log);
            }
            catch (Exception e) {
                SubstrateDiagnostics.dumpException(log, "dumpDeoptStubPointer", e);
            }
        }
        if (SubstrateDiagnostics.shouldPrint(8)) {
            try {
                SubstrateDiagnostics.dumpTopFrame(log, sp, ip);
            }
            catch (Exception e) {
                SubstrateDiagnostics.dumpException(log, "dumpTopFrame", e);
            }
        }
        if (SubstrateDiagnostics.shouldPrint(16)) {
            try {
                SubstrateDiagnostics.dumpVMThreads(log);
            }
            catch (Exception e) {
                SubstrateDiagnostics.dumpException(log, "dumpVMThreads", e);
            }
        }
        if (SubstrateDiagnostics.shouldPrint(32)) {
            try {
                SubstrateDiagnostics.dumpVMThreadState(log, currentThread);
            }
            catch (Exception e) {
                SubstrateDiagnostics.dumpException(log, "dumpVMThreadState", e);
            }
        }
        if (SubstrateDiagnostics.shouldPrint(64)) {
            try {
                SubstrateDiagnostics.dumpRecentVMOperations(log);
            }
            catch (Exception e) {
                SubstrateDiagnostics.dumpException(log, "dumpRecentVMOperations", e);
            }
        }
        if (SubstrateDiagnostics.shouldPrint(128)) {
            SubstrateDiagnostics.dumpRuntimeCompilation(log);
        }
        if (SubstrateDiagnostics.shouldPrint(256)) {
            try {
                SubstrateDiagnostics.dumpCounters(log);
            }
            catch (Exception e) {
                SubstrateDiagnostics.dumpException(log, "dumpCounters", e);
            }
        }
        if (SubstrateDiagnostics.shouldPrint(512)) {
            try {
                SubstrateDiagnostics.dumpStacktraceRaw(log, sp);
            }
            catch (Exception e) {
                SubstrateDiagnostics.dumpException(log, "dumpStacktraceRaw", e);
            }
        }
        if (SubstrateDiagnostics.shouldPrint(1024)) {
            SubstrateDiagnostics.dumpStacktrace(log, sp, ip);
        }
        if (SubstrateDiagnostics.shouldPrint(2048) && VMOperation.isInProgressAtSafepoint()) {
            IsolateThread vmThread = VMThreads.firstThreadUnsafe();
            while (vmThread.isNonNull()) {
                if (vmThread != currentThread) {
                    try {
                        SubstrateDiagnostics.dumpStacktrace(log, vmThread);
                    }
                    catch (Exception e) {
                        SubstrateDiagnostics.dumpException(log, "dumpStacktrace", e);
                    }
                }
                vmThread = VMThreads.nextThread(vmThread);
            }
        }
        int numDiagnosticThunks = DiagnosticThunkRegister.getSingleton().size();
        while (diagnosticThunkIndex < numDiagnosticThunks) {
            try {
                int index;
                ++diagnosticThunkIndex;
                DiagnosticThunkRegister.getSingleton().callDiagnosticThunk(log, index);
            }
            catch (Exception e) {
                SubstrateDiagnostics.dumpException(log, "callThunks", e);
            }
        }
        diagnosticThunkIndex = 0;
        diagnosticSections = 0;
        diagnosticThread.set((IsolateThread)WordFactory.nullPointer());
    }

    private static boolean shouldPrint(int sectionBit) {
        if ((diagnosticSections & sectionBit) == 0) {
            diagnosticSections |= sectionBit;
            return true;
        }
        return false;
    }

    private static void dumpException(Log log, String context, Exception e) {
        log.newline().string("[!!! Exception during ").string(context).string(": ").string(e.getClass().getName()).string("]").newline();
    }

    private static void dumpRegisters(Log log, RegisterDumper.Context context) {
        if (context.isNonNull()) {
            log.string("General Purpose Register Set values:").newline();
            log.indent(true);
            RegisterDumper.singleton().dumpRegisters(log, context);
            log.indent(false);
        }
    }

    private static void dumpJavaFrameAnchors(Log log) {
        log.string("JavaFrameAnchor dump:").newline();
        log.indent(true);
        JavaFrameAnchor anchor = JavaFrameAnchors.getFrameAnchor();
        if (anchor.isNull()) {
            log.string("No anchors").newline();
        }
        while (anchor.isNonNull()) {
            log.string("Anchor ").zhex(anchor.rawValue()).string(" LastJavaSP ").zhex(anchor.getLastJavaSP().rawValue()).string(" LastJavaIP ").zhex(anchor.getLastJavaIP().rawValue()).newline();
            anchor = anchor.getPreviousAnchor();
        }
        log.indent(false);
    }

    private static void dumpDeoptStubPointer(Log log) {
        if (DeoptimizationSupport.enabled()) {
            log.string("DeoptStubPointer address: ").zhex(DeoptimizationSupport.getDeoptStubPointer().rawValue()).newline().newline();
        }
    }

    private static void dumpTopFrame(Log log, Pointer sp, CodePointer ip) {
        log.string("TopFrame info:").newline();
        log.indent(true);
        if (sp.isNonNull() && ip.isNonNull()) {
            long totalFrameSize = SubstrateDiagnostics.getTotalFrameSize(sp, ip);
            DeoptimizedFrame deoptFrame = Deoptimizer.checkDeoptimized(sp);
            if (deoptFrame != null) {
                log.string("RSP ").zhex(sp.rawValue()).string(" frame was deoptimized:").newline();
                log.string("SourcePC ").zhex(deoptFrame.getSourcePC().rawValue()).newline();
                log.string("SourceTotalFrameSize ").signed(totalFrameSize).newline();
            } else if (totalFrameSize != -1L) {
                log.string("TotalFrameSize in CodeInfoTable ").signed(totalFrameSize).newline();
            }
            if (totalFrameSize == -1L) {
                log.string("Does not look like a Java Frame. Use JavaFrameAnchors to find LastJavaSP:").newline();
                JavaFrameAnchor anchor = JavaFrameAnchors.getFrameAnchor();
                while (anchor.isNonNull() && anchor.getLastJavaSP().belowOrEqual((UnsignedWord)sp)) {
                    anchor = anchor.getPreviousAnchor();
                }
                if (anchor.isNonNull()) {
                    log.string("Found matching Anchor:").zhex(anchor.rawValue()).newline();
                    Pointer lastSp = anchor.getLastJavaSP();
                    log.string("LastJavaSP ").zhex(lastSp.rawValue()).newline();
                    CodePointer lastIp = anchor.getLastJavaIP();
                    log.string("LastJavaIP ").zhex(lastIp.rawValue()).newline();
                }
            }
        }
        log.indent(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    private static long getTotalFrameSize(Pointer sp, CodePointer ip) {
        DeoptimizedFrame deoptFrame = Deoptimizer.checkDeoptimized(sp);
        if (deoptFrame != null) {
            return deoptFrame.getSourceTotalFrameSize();
        }
        UntetheredCodeInfo untetheredInfo = CodeInfoTable.lookupCodeInfo(ip);
        if (untetheredInfo.isNonNull()) {
            Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
            try {
                CodeInfo codeInfo = CodeInfoAccess.convert(untetheredInfo, tether);
                long l = SubstrateDiagnostics.getTotalFrameSize0(ip, codeInfo);
                return l;
            }
            finally {
                CodeInfoAccess.releaseTether(untetheredInfo, tether);
            }
        }
        return -1L;
    }

    @Uninterruptible(reason="Wrap the now safe call to interruptibly look up the frame size.", calleeMustBe=false)
    private static long getTotalFrameSize0(CodePointer ip, CodeInfo codeInfo) {
        return CodeInfoAccess.lookupTotalFrameSize(codeInfo, CodeInfoAccess.relativeIP(codeInfo, ip));
    }

    private static void dumpVMThreads(Log log) {
        log.string("VMThreads info:").newline();
        log.indent(true);
        IsolateThread vmThread = VMThreads.firstThreadUnsafe();
        while (vmThread.isNonNull()) {
            log.string("VMThread ").zhex(vmThread.rawValue()).spaces(2).string(VMThreads.StatusSupport.getStatusString(vmThread)).spaces(2).object(JavaThreads.fromVMThread(vmThread)).newline();
            vmThread = VMThreads.nextThread(vmThread);
        }
        log.indent(false);
    }

    private static void dumpVMThreadState(Log log, IsolateThread currentThread) {
        if (SubstrateDiagnostics.isThreadOnlyAttachedForCrashHandler(currentThread)) {
            log.string("The current thread ").zhex(currentThread.rawValue()).string(" does not have a VM Thread State as it is an unattached thread.").newline();
            log.newline();
        } else {
            log.string("VM Thread State for current thread ").zhex(currentThread.rawValue()).string(":").newline();
            log.indent(true);
            VMThreadLocalInfos.dumpToLog(log, currentThread);
            log.indent(false);
        }
    }

    private static void dumpRecentVMOperations(Log log) {
        log.string("VMOperation dump:").newline();
        log.indent(true);
        VMOperationControl.logRecentEvents(log);
        log.indent(false);
    }

    static void dumpRuntimeCompilation(Log log) {
        if (DeoptimizationSupport.enabled()) {
            log.newline().string("RuntimeCodeCache dump:").newline();
            log.indent(true);
            try {
                CodeInfoTable.getRuntimeCodeCache().logRecentOperations(log);
            }
            catch (Exception e) {
                SubstrateDiagnostics.dumpException(log, "dumpRecentRuntimeCodeCacheOperations", e);
            }
            log.newline();
            try {
                CodeInfoTable.getRuntimeCodeCache().logTable(log);
            }
            catch (Exception e) {
                SubstrateDiagnostics.dumpException(log, "dumpRuntimeCodeCacheTable", e);
            }
            log.indent(false);
            try {
                SubstrateDiagnostics.dumpRecentDeopts(log);
            }
            catch (Exception e) {
                SubstrateDiagnostics.dumpException(log, "dumpRecentDeopts", e);
            }
        }
    }

    private static void dumpRecentDeopts(Log log) {
        log.string("Deoptimizer dump:").newline();
        log.indent(true);
        Deoptimizer.logRecentDeoptimizationEvents(log);
        log.indent(false);
    }

    private static void dumpCounters(Log log) {
        log.string("Dump Counters:").newline();
        log.indent(true);
        Counter.logValues();
        log.indent(false);
    }

    private static void dumpStacktraceRaw(Log log, Pointer sp) {
        log.string("Raw Stacktrace:").newline();
        log.indent(true);
        log.hexdump((PointerBase)sp, 8, 16);
        log.indent(false);
    }

    private static void dumpStacktrace(Log log, Pointer sp, CodePointer ip) {
        for (int i = 0; i < PRINT_VISITORS.length; ++i) {
            try {
                log.string("Stacktrace Stage ").signed(i).string(":").newline();
                log.indent(true);
                ThreadStackPrinter.printStacktrace(sp, ip, PRINT_VISITORS[i], log);
                log.indent(false);
                continue;
            }
            catch (Exception e) {
                SubstrateDiagnostics.dumpException(log, "dumpStacktrace", e);
            }
        }
    }

    private static void dumpStacktrace(Log log, IsolateThread vmThread) {
        log.string("Full Stacktrace for VMThread ").zhex(vmThread.rawValue()).string(":").newline();
        log.indent(true);
        JavaStackWalker.walkThread(vmThread, ThreadStackPrinter.StackFramePrintVisitor.SINGLETON, log);
        log.indent(false);
    }

    public static class DiagnosticThunkRegister {
        DiagnosticThunk[] diagnosticThunkRegistry = new DiagnosticThunk[0];

        @Fold
        public static synchronized DiagnosticThunkRegister getSingleton() {
            if (!ImageSingletons.contains(DiagnosticThunkRegister.class)) {
                ImageSingletons.add(DiagnosticThunkRegister.class, (Object)new DiagnosticThunkRegister());
            }
            return (DiagnosticThunkRegister)ImageSingletons.lookup(DiagnosticThunkRegister.class);
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        DiagnosticThunkRegister() {
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public synchronized void register(DiagnosticThunk diagnosticThunk) {
            DiagnosticThunk[] newArray = Arrays.copyOf(this.diagnosticThunkRegistry, this.diagnosticThunkRegistry.length + 1);
            newArray[newArray.length - 1] = diagnosticThunk;
            this.diagnosticThunkRegistry = newArray;
        }

        @Fold
        int size() {
            return this.diagnosticThunkRegistry.length;
        }

        void callDiagnosticThunk(Log log, int index) {
            this.diagnosticThunkRegistry[index].invokeWithoutAllocation(log);
        }
    }

    @FunctionalInterface
    public static interface DiagnosticThunk {
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate during printing diagnostics.")
        public void invokeWithoutAllocation(Log var1);
    }
}

