/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.functions;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.jni.nativeapi.JNIInvokeInterface;
import com.oracle.svm.jni.nativeapi.JNIJavaVM;
import com.oracle.svm.jni.nativeapi.JNINativeInterface;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public final class JNIFunctionTables {
    private final WordBase[] javaVMData = new WordBase[JNIFunctionTables.wordArrayLength(SizeOf.get(JNIJavaVM.class))];
    private final WordBase[] invokeInterfaceDataMutable = new WordBase[JNIFunctionTables.wordArrayLength(SizeOf.get(JNIInvokeInterface.class))];
    final CFunctionPointer[] invokeInterfaceDataPrototype = new CFunctionPointer[JNIFunctionTables.wordArrayLength(SizeOf.get(JNIInvokeInterface.class))];
    final CFunctionPointer[] functionTableData = new CFunctionPointer[JNIFunctionTables.wordArrayLength(SizeOf.get(JNINativeInterface.class))];
    private JNIJavaVM globalJavaVM;
    private JNINativeInterface globalFunctionTable;

    static void create() {
        ImageSingletons.add(JNIFunctionTables.class, (Object)new JNIFunctionTables());
    }

    public static JNIFunctionTables singleton() {
        return (JNIFunctionTables)ImageSingletons.lookup(JNIFunctionTables.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private JNIFunctionTables() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static int wordArrayLength(int sizeInBytes) {
        int wordSize = FrameAccess.wordSize();
        VMError.guarantee(sizeInBytes % wordSize == 0);
        return sizeInBytes / wordSize;
    }

    public JNIJavaVM getGlobalJavaVM() {
        JNIJavaVM javaVM = this.globalJavaVM;
        if (javaVM.isNull()) {
            for (int i = 0; i < this.invokeInterfaceDataPrototype.length; ++i) {
                this.invokeInterfaceDataMutable[i] = this.invokeInterfaceDataPrototype[i];
            }
            javaVM = (JNIJavaVM)JNIFunctionTables.dataAddress(this.javaVMData);
            JNIInvokeInterface invokes = (JNIInvokeInterface)JNIFunctionTables.dataAddress(this.invokeInterfaceDataMutable);
            invokes.setIsolate(CurrentIsolate.getIsolate());
            javaVM.setFunctions(invokes);
            this.globalJavaVM = javaVM;
        }
        return javaVM;
    }

    public JNINativeInterface getGlobalFunctionTable() {
        JNINativeInterface functionTable = this.globalFunctionTable;
        if (functionTable.isNull()) {
            this.globalFunctionTable = functionTable = (JNINativeInterface)JNIFunctionTables.dataAddress((WordBase[])this.functionTableData);
        }
        return functionTable;
    }

    private static Pointer dataAddress(WordBase[] dataArray) {
        DynamicHub hub = DynamicHub.fromClass(dataArray.getClass());
        UnsignedWord offsetOfFirstArrayElement = LayoutEncoding.getArrayElementOffset(hub.getLayoutEncoding(), 0);
        return Word.objectToUntrackedPointer((Object)dataArray).add(offsetOfFirstArrayElement);
    }
}

