/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.nativeimage.ImageSingletons;

public class CompilationInfoSupport {
    protected boolean sealed;
    private final Set<AnalysisMethod> forcedCompilations = new HashSet<AnalysisMethod>();
    private final Set<AnalysisMethod> frameInformationRequired = new HashSet<AnalysisMethod>();
    private final Map<AnalysisMethod, Map<Long, DeoptSourceFrameInfo>> deoptEntries = new HashMap<AnalysisMethod, Map<Long, DeoptSourceFrameInfo>>();
    private final Set<AnalysisMethod> deoptInliningExcludes = new HashSet<AnalysisMethod>();

    public static CompilationInfoSupport singleton() {
        return (CompilationInfoSupport)ImageSingletons.lookup(CompilationInfoSupport.class);
    }

    public void registerForcedCompilation(ResolvedJavaMethod method) {
        assert (!this.sealed);
        this.forcedCompilations.add(CompilationInfoSupport.toAnalysisMethod(method));
    }

    public boolean isForcedCompilation(ResolvedJavaMethod method) {
        assert (this.seal());
        return this.forcedCompilations.contains(CompilationInfoSupport.toAnalysisMethod(method));
    }

    public void registerFrameInformationRequired(AnalysisMethod method) {
        assert (!this.sealed);
        this.frameInformationRequired.add(method);
        this.deoptEntries.computeIfAbsent(method, m -> new HashMap());
    }

    public boolean isFrameInformationRequired(ResolvedJavaMethod method) {
        assert (this.seal());
        return this.frameInformationRequired.contains(CompilationInfoSupport.toAnalysisMethod(method));
    }

    public void registerDeoptEntry(FrameState state) {
        assert (!this.sealed);
        assert (state.bci >= 0);
        long encodedBci = FrameInfoEncoder.encodeBci(state.bci, state.duringCall(), state.rethrowException());
        Map sourceFrameInfoMap = this.deoptEntries.computeIfAbsent(CompilationInfoSupport.toAnalysisMethod(state.getMethod()), m -> new HashMap());
        sourceFrameInfoMap.compute(encodedBci, (k, v) -> v == null ? DeoptSourceFrameInfo.create(state) : v.mergeStateInfo(state));
    }

    public boolean isDeoptTarget(ResolvedJavaMethod method) {
        assert (this.seal());
        return this.deoptEntries.containsKey(CompilationInfoSupport.toAnalysisMethod(method));
    }

    protected boolean isDeoptEntry(ResolvedJavaMethod method, int bci, boolean duringCall, boolean rethrowException) {
        assert (this.seal());
        Map<Long, DeoptSourceFrameInfo> bciMap = this.deoptEntries.get(CompilationInfoSupport.toAnalysisMethod(method));
        assert (bciMap != null) : "can only query for deopt entries for methods registered as deopt targets";
        long encodedBci = FrameInfoEncoder.encodeBci(bci, duringCall, rethrowException);
        return bciMap.containsKey(encodedBci);
    }

    public void registerAsDeoptInlininingExclude(ResolvedJavaMethod method) {
        assert (!this.sealed);
        this.deoptInliningExcludes.add(CompilationInfoSupport.toAnalysisMethod(method));
    }

    public boolean isDeoptInliningExclude(ResolvedJavaMethod method) {
        assert (this.seal());
        return this.deoptInliningExcludes.contains(CompilationInfoSupport.toAnalysisMethod(method));
    }

    public Map<AnalysisMethod, Map<Long, DeoptSourceFrameInfo>> getDeoptEntries() {
        assert (this.seal());
        return this.deoptEntries;
    }

    private static AnalysisMethod toAnalysisMethod(ResolvedJavaMethod method) {
        if (method instanceof AnalysisMethod) {
            return (AnalysisMethod)method;
        }
        if (method instanceof HostedMethod) {
            return ((HostedMethod)method).wrapped;
        }
        throw VMError.shouldNotReachHere();
    }

    private boolean seal() {
        this.sealed = true;
        return true;
    }

    public static final class DeoptSourceFrameInfo {
        public final List<JavaKind> expectedKinds;
        public final int numLocals;
        public final int numStack;
        public final int numLocks;

        private DeoptSourceFrameInfo(List<JavaKind> expectedKinds, int numLocals, int numStack, int numLocks) {
            this.expectedKinds = expectedKinds;
            this.numLocals = numLocals;
            this.numStack = numStack;
            this.numLocks = numLocks;
        }

        public static DeoptSourceFrameInfo create(FrameState state) {
            return new DeoptSourceFrameInfo(DeoptSourceFrameInfo.getKinds(state), state.localsSize(), state.stackSize(), state.locksSize());
        }

        private static List<JavaKind> getKinds(FrameState state) {
            return state.values().stream().map(DeoptSourceFrameInfo::getKind).collect(Collectors.toList());
        }

        private static JavaKind getKind(ValueNode value) {
            if (value == null) {
                return JavaKind.Illegal;
            }
            return value.getStackKind();
        }

        public DeoptSourceFrameInfo mergeStateInfo(FrameState state) {
            boolean matchingSizes;
            List<JavaKind> otherKinds = DeoptSourceFrameInfo.getKinds(state);
            boolean bl = matchingSizes = this.numLocals == state.localsSize() && this.numStack == state.stackSize() && this.numLocks == state.locksSize() && this.expectedKinds.size() == otherKinds.size();
            if (!matchingSizes) {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append("Unexpected number of values in state to merge.\n");
                errorMessage.append(String.format("DeoptSourceFrameInfo: locals-%d, stack-%d, locks-%d.\n", this.numLocals, this.numStack, this.numLocks));
                errorMessage.append(String.format("Merge FrameState: locals-%d, stack-%d, locks-%d.\n", state.localsSize(), state.stackSize(), state.locksSize()));
                VMError.shouldNotReachHere(errorMessage.toString());
            }
            for (int i = 0; i < this.expectedKinds.size(); ++i) {
                JavaKind current = this.expectedKinds.get(i);
                JavaKind other = otherKinds.get(i);
                if (current == JavaKind.Illegal || current == other) continue;
                this.expectedKinds.set(i, JavaKind.Illegal);
            }
            return this;
        }
    }
}

