/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ResourceConfigurationParser;
import com.oracle.svm.core.configure.ResourcesRegistry;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.jdk.localization.LocalizationFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.util.ModuleSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public final class ResourcesFeature
implements Feature {
    private boolean sealed = false;
    private Set<String> newResources = Collections.newSetFromMap(new ConcurrentHashMap());
    private Set<String> ignoredResources = Collections.newSetFromMap(new ConcurrentHashMap());
    private int loadedConfigurations;

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(ResourcesRegistry.class, (Object)new ResourcesRegistryImpl());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        ImageClassLoader imageClassLoader = ((FeatureImpl.BeforeAnalysisAccessImpl)access).getImageClassLoader();
        ResourceConfigurationParser parser = new ResourceConfigurationParser((ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class));
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurations(parser, imageClassLoader, "resource", ConfigurationFiles.Options.ResourceConfigurationFiles, ConfigurationFiles.Options.ResourceConfigurationResources, "resource-config.json");
        this.newResources.addAll(Options.IncludeResources.getValue().values());
        this.ignoredResources.addAll(Options.ExcludeResources.getValue().values());
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        if (this.newResources.isEmpty()) {
            return;
        }
        access.requireAnalysisIteration();
        DebugContext debugContext = ((FeatureImpl.DuringAnalysisAccessImpl)access).getDebugContext();
        Pattern[] includePatterns = ResourcesFeature.compilePatterns(this.newResources);
        Pattern[] excludePatterns = ResourcesFeature.compilePatterns(this.ignoredResources);
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            try {
                ModuleSupport.findResourcesInModules(name -> ResourcesFeature.matches(includePatterns, excludePatterns, name), (resName, content) -> ResourcesFeature.registerResource(debugContext, resName, content));
            }
            catch (IOException ex) {
                throw UserError.abort(ex, "Can not read resources from modules. This is possible due to incorrect module path or missing module visibility directives", new Object[0]);
            }
        }
        HashSet<File> todo = new HashSet<File>();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)contextClassLoader).getURLs()) {
                try {
                    File file = new File(url.toURI());
                    todo.add(file);
                }
                catch (IllegalArgumentException | URISyntaxException e) {
                    throw UserError.abort("Unable to handle imagecp element '%s'. Make sure that all imagecp entries are either directories or valid jar files.", url.toExternalForm());
                }
            }
        }
        for (File element : todo) {
            try {
                if (element.isDirectory()) {
                    this.scanDirectory(debugContext, element, "", includePatterns, excludePatterns);
                    continue;
                }
                ResourcesFeature.scanJar(debugContext, element, includePatterns, excludePatterns);
            }
            catch (IOException ex) {
                throw UserError.abort("Unable to handle classpath element '%s'. Make sure that all classpath entries are either directories or valid jar files.", element);
            }
        }
        this.newResources.clear();
    }

    private static Pattern[] compilePatterns(Set<String> patterns) {
        return patterns.stream().filter(s -> s.length() > 0).map(Pattern::compile).collect(Collectors.toList()).toArray(new Pattern[0]);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.sealed = true;
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (!ImageSingletons.contains(FallbackFeature.class)) {
            return;
        }
        FallbackFeature.FallbackImageRequest resourceFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).resourceFallback;
        if (resourceFallback != null && Options.IncludeResources.getValue().values().isEmpty() && this.loadedConfigurations == 0) {
            throw resourceFallback;
        }
    }

    private void scanDirectory(DebugContext debugContext, File f, String relativePath, Pattern[] includePatterns, Pattern[] excludePatterns) throws IOException {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            if (files == null) {
                throw UserError.abort("Cannot scan directory %s", f);
            }
            for (File ch : files) {
                this.scanDirectory(debugContext, ch, relativePath.isEmpty() ? ch.getName() : relativePath + "/" + ch.getName(), includePatterns, excludePatterns);
            }
        } else if (ResourcesFeature.matches(includePatterns, excludePatterns, relativePath)) {
            try (FileInputStream is = new FileInputStream(f);){
                ResourcesFeature.registerResource(debugContext, relativePath, is);
            }
        }
    }

    private static void scanJar(DebugContext debugContext, File element, Pattern[] includePatterns, Pattern[] excludePatterns) throws IOException {
        JarFile jf = new JarFile(element);
        Enumeration<JarEntry> en = jf.entries();
        HashMap<String, List> matchedDirectoryResources = new HashMap<String, List>();
        HashSet<String> allEntries = new HashSet<String>();
        while (en.hasMoreElements()) {
            JarEntry e = en.nextElement();
            if (e.isDirectory()) {
                String dirName = e.getName().substring(0, e.getName().length() - 1);
                allEntries.add(dirName);
                if (!ResourcesFeature.matches(includePatterns, excludePatterns, dirName)) continue;
                matchedDirectoryResources.put(dirName, new ArrayList());
                continue;
            }
            allEntries.add(e.getName());
            if (!ResourcesFeature.matches(includePatterns, excludePatterns, e.getName())) continue;
            InputStream is = jf.getInputStream(e);
            Throwable throwable = null;
            try {
                ResourcesFeature.registerResource(debugContext, e.getName(), is);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
        for (String entry : allEntries) {
            int last = entry.lastIndexOf(47);
            String key = last == -1 ? "" : entry.substring(0, last);
            List dirContent = (List)matchedDirectoryResources.get(key);
            if (dirContent == null || dirContent.contains(entry)) continue;
            dirContent.add(entry.substring(last + 1, entry.length()));
        }
        matchedDirectoryResources.forEach((dir, content) -> {
            content.sort(Comparator.naturalOrder());
            ResourcesFeature.registerDirectoryResource(debugContext, dir, String.join((CharSequence)System.lineSeparator(), content));
        });
    }

    private static boolean matches(Pattern[] includePatterns, Pattern[] excludePatterns, String relativePath) {
        for (Pattern p : excludePatterns) {
            if (!p.matcher(relativePath).matches()) continue;
            return false;
        }
        for (Pattern p : includePatterns) {
            if (!p.matcher(relativePath).matches()) continue;
            return true;
        }
        return false;
    }

    private static void registerResource(DebugContext debugContext, String resourceName, InputStream resourceStream) {
        try (DebugContext.Scope s = debugContext.scope((Object)"registerResource");){
            debugContext.log(3, "ResourcesFeature: registerResource: " + resourceName);
            Resources.registerResource(resourceName, resourceStream);
        }
    }

    private static void registerDirectoryResource(DebugContext debugContext, String dir, String content) {
        try (DebugContext.Scope s = debugContext.scope((Object)"registerResource");){
            debugContext.log(3, "ResourcesFeature: registerResource: " + dir);
            Resources.registerDirectoryResource(dir, content);
        }
    }

    private class ResourcesRegistryImpl
    implements ResourcesRegistry {
        private ResourcesRegistryImpl() {
        }

        @Override
        public void addResources(String pattern) {
            UserError.guarantee(!ResourcesFeature.this.sealed, "Resources added too late: %s", pattern);
            ResourcesFeature.this.newResources.add(pattern);
        }

        @Override
        public void ignoreResources(String pattern) {
            UserError.guarantee(!ResourcesFeature.this.sealed, "Resources ignored too late: %s", pattern);
            ResourcesFeature.this.ignoredResources.add(pattern);
        }

        @Override
        public void addResourceBundles(String name) {
            ((LocalizationFeature)ImageSingletons.lookup(LocalizationFeature.class)).prepareBundle(name);
        }
    }

    public static class Options {
        @Option(help={"Regexp to match names of resources to be included in the image."}, type=OptionType.User)
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> IncludeResources = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        @Option(help={"Regexp to match names of resources to be excluded from the image."}, type=OptionType.User)
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> ExcludeResources = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
    }
}

