/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.localization;

import com.oracle.svm.core.jdk.localization.BundleContentSubstitutedLocalizationSupport;
import com.oracle.svm.core.jdk.localization.LocalizationSupport;
import com.oracle.svm.core.jdk.localization.OptimizedLocalizationSupport;
import com.oracle.svm.core.jdk.localization.substitutions.Target_sun_util_locale_provider_LocaleServiceProviderPool_OptimizedLocaleMode;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.text.spi.BreakIteratorProvider;
import java.text.spi.CollatorProvider;
import java.text.spi.DateFormatProvider;
import java.text.spi.DateFormatSymbolsProvider;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.text.spi.NumberFormatProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IllformedLocaleException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.spi.CalendarDataProvider;
import java.util.spi.CalendarNameProvider;
import java.util.spi.CurrencyNameProvider;
import java.util.spi.LocaleNameProvider;
import java.util.spi.LocaleServiceProvider;
import java.util.spi.TimeZoneNameProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.ResourceBundleBasedAdapter;
import sun.util.resources.LocaleData;

public abstract class LocalizationFeature
implements Feature {
    protected final boolean optimizedMode = LocalizationFeature.optimizedMode();
    private final boolean substituteLoadLookup = Options.LocalizationSubstituteLoadLookup.getValue();
    protected final boolean trace = Options.TraceLocalizationFeature.getValue();
    private final ForkJoinPool compressionPool = Options.LocalizationCompressInParallel.getValue() != false ? new ForkJoinPool(Runtime.getRuntime().availableProcessors()) : null;
    protected Locale defaultLocale = Locale.getDefault();
    protected Set<Locale> allLocales;
    protected LocalizationSupport support;
    private Function<String, Class<?>> findClassByName;
    private static final List<Class<? extends LocaleServiceProvider>> spiClasses = Arrays.asList(BreakIteratorProvider.class, CollatorProvider.class, DateFormatProvider.class, DateFormatSymbolsProvider.class, DecimalFormatSymbolsProvider.class, NumberFormatProvider.class, CurrencyNameProvider.class, LocaleNameProvider.class, TimeZoneNameProvider.class, CalendarDataProvider.class, CalendarNameProvider.class);
    private static final Field PARENT_FIELD = ReflectionUtil.lookupField(ResourceBundle.class, (String)"parent");

    public static boolean optimizedMode() {
        return Options.LocalizationOptimizedMode.getValue();
    }

    public static boolean jvmMode() {
        return !LocalizationFeature.optimizedMode();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        this.findClassByName = arg_0 -> ((Feature.AfterRegistrationAccess)access).findClassByName(arg_0);
        this.allLocales = LocalizationFeature.processLocalesOption();
        this.defaultLocale = LocalizationFeature.parseLocaleFromTag(Options.DefaultLocale.getValue());
        UserError.guarantee(this.defaultLocale != null, "Invalid default locale %s", Options.DefaultLocale.getValue());
        this.allLocales.add(this.defaultLocale);
        this.support = this.selectLocalizationSupport();
        ImageSingletons.add(LocalizationSupport.class, (Object)this.support);
        ImageSingletons.add(LocalizationFeature.class, (Object)this);
        LocalizationFeature.addCharsets();
        if (this.optimizedMode) {
            this.addProviders();
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private LocalizationSupport selectLocalizationSupport() {
        if (this.optimizedMode) {
            return new OptimizedLocalizationSupport(this.defaultLocale, this.allLocales);
        }
        if (this.substituteLoadLookup) {
            List<String> requestedPatterns = Options.LocalizationCompressBundles.getValue().values();
            return new BundleContentSubstitutedLocalizationSupport(this.defaultLocale, this.allLocales, requestedPatterns, this.compressionPool);
        }
        return new LocalizationSupport(this.defaultLocale, this.allLocales);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.addResourceBundles();
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        if (this.compressionPool != null) {
            this.compressionPool.shutdown();
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static Locale parseLocaleFromTag(String tag) {
        try {
            return new Locale.Builder().setLanguageTag(tag).build();
        }
        catch (IllformedLocaleException ex) {
            String[] parts = tag.split("-");
            switch (parts.length) {
                case 1: {
                    return new Locale(parts[0]);
                }
                case 2: {
                    return new Locale(parts[0], parts[1]);
                }
                case 3: {
                    return new Locale(parts[0], parts[1], parts[2]);
                }
            }
            return null;
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static Set<Locale> processLocalesOption() {
        HashSet<Locale> locales = new HashSet<Locale>();
        if (Options.IncludeAllLocales.getValue().booleanValue()) {
            Collections.addAll(locales, Locale.getAvailableLocales());
        }
        ArrayList<String> invalid = new ArrayList<String>();
        for (String tag : Options.IncludeLocales.getValue().values()) {
            Locale locale = LocalizationFeature.parseLocaleFromTag(tag);
            if (locale != null) {
                locales.add(locale);
                continue;
            }
            invalid.add(tag);
        }
        if (!invalid.isEmpty()) {
            throw UserError.abort("Invalid locales specified: %s", invalid);
        }
        return locales;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static void addCharsets() {
        if (Options.AddAllCharsets.getValue().booleanValue()) {
            for (Charset c : Charset.availableCharsets().values()) {
                LocalizationFeature.addCharset(c);
            }
        } else {
            LocalizationFeature.addCharset(Charset.defaultCharset());
            LocalizationFeature.addCharset(Charset.forName("US-ASCII"));
            LocalizationFeature.addCharset(Charset.forName("ISO-8859-1"));
            LocalizationFeature.addCharset(Charset.forName("UTF-8"));
            LocalizationFeature.addCharset(Charset.forName("UTF-16BE"));
            LocalizationFeature.addCharset(Charset.forName("UTF-16LE"));
            LocalizationFeature.addCharset(Charset.forName("UTF-16"));
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void addCharset(Charset charset) {
        Map<String, Charset> charsets = ((LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class)).charsets;
        charsets.put(charset.name().toLowerCase(), charset);
        for (String name : charset.aliases()) {
            charsets.put(name.toLowerCase(), charset);
        }
        charset.newDecoder();
        if (charset.canEncode()) {
            charset.newEncoder();
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected List<Class<? extends LocaleServiceProvider>> getSpiClasses() {
        return spiClasses;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private void addProviders() {
        OptimizedLocalizationSupport optimizedLocalizationSupport = this.support.asOptimizedSupport();
        for (Class<? extends LocaleServiceProvider> providerClass : this.getSpiClasses()) {
            LocaleProviderAdapter adapter = Objects.requireNonNull(LocaleProviderAdapter.getAdapter(providerClass, this.defaultLocale));
            LocaleServiceProvider provider = Objects.requireNonNull(adapter.getLocaleServiceProvider(providerClass));
            optimizedLocalizationSupport.providerPools.put(providerClass, new Target_sun_util_locale_provider_LocaleServiceProviderPool_OptimizedLocaleMode(provider));
        }
        for (Locale locale : this.allLocales) {
            for (Locale candidateLocale : optimizedLocalizationSupport.control.getCandidateLocales("", locale)) {
                for (Class<? extends LocaleServiceProvider> providerClass : this.getSpiClasses()) {
                    LocaleProviderAdapter adapter = Objects.requireNonNull(LocaleProviderAdapter.getAdapter(providerClass, candidateLocale));
                    optimizedLocalizationSupport.adaptersByClass.put((Pair<Class<? extends LocaleServiceProvider>, Locale>)Pair.create(providerClass, (Object)candidateLocale), adapter);
                    LocaleProviderAdapter existing = optimizedLocalizationSupport.adaptersByType.put(adapter.getAdapterType(), adapter);
                    assert (existing == null || existing == adapter) : "Overwriting adapter type with a different adapter";
                }
            }
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void addResourceBundles() {
        for (Locale locale : this.allLocales) {
            this.prepareBundle(this.localeData(CalendarDataProvider.class, locale).getCalendarData(locale), locale);
            this.prepareBundle(this.localeData(CurrencyNameProvider.class, locale).getCurrencyNames(locale), locale);
            this.prepareBundle(this.localeData(LocaleNameProvider.class, locale).getLocaleNames(locale), locale);
            this.prepareBundle(this.localeData(TimeZoneNameProvider.class, locale).getTimeZoneNames(locale), locale);
            this.prepareBundle(this.localeData(BreakIteratorProvider.class, locale).getBreakIteratorInfo(locale), locale);
            this.prepareBundle(this.localeData(BreakIteratorProvider.class, locale).getCollationData(locale), locale);
            this.prepareBundle(this.localeData(DateFormatProvider.class, locale).getDateFormatData(locale), locale);
            this.prepareBundle(this.localeData(NumberFormatProvider.class, locale).getNumberFormatData(locale), locale);
        }
        String[] alwaysRegisteredResourceBundles = new String[]{"sun.util.logging.resources.logging", "sun.util.resources.TimeZoneNames", "sun.text.resources.FormatData"};
        for (String bundleName : alwaysRegisteredResourceBundles) {
            this.prepareBundle(bundleName);
        }
        for (String bundleName : OptionUtils.flatten(",", Options.IncludeResourceBundles.getValue())) {
            this.processRequestedBundle(bundleName);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected LocaleData localeData(Class<? extends LocaleServiceProvider> providerClass, Locale locale) {
        return ((ResourceBundleBasedAdapter)((Object)LocaleProviderAdapter.getAdapter(providerClass, locale))).getLocaleData();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private void processRequestedBundle(String input) {
        Locale locale;
        boolean specificLocaleRequested;
        int splitIndex = input.indexOf(95);
        boolean bl = specificLocaleRequested = splitIndex != -1;
        if (!specificLocaleRequested) {
            this.prepareBundle(input, this.allLocales);
            return;
        }
        Locale locale2 = locale = splitIndex + 1 < input.length() ? LocalizationFeature.parseLocaleFromTag(input.substring(splitIndex + 1)) : Locale.ROOT;
        if (locale == null) {
            this.trace("Cannot parse wanted locale " + input.substring(splitIndex + 1) + ", default will be used instead.");
            locale = this.defaultLocale;
        }
        String baseName = input.substring(0, splitIndex);
        this.prepareBundle(baseName, Collections.singletonList(locale));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void prepareBundle(String baseName) {
        this.prepareBundle(baseName, this.allLocales);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void prepareBundle(String baseName, Collection<Locale> wantedLocales) {
        Class<?> clazz;
        if (baseName.isEmpty()) {
            return;
        }
        boolean somethingFound = false;
        for (Locale locale : wantedLocales) {
            ResourceBundle resourceBundle;
            try {
                resourceBundle = ModuleSupport.getResourceBundle((String)baseName, (Locale)locale, (ClassLoader)Thread.currentThread().getContextClassLoader());
            }
            catch (MissingResourceException mre) {
                if (!baseName.contains("/")) continue;
                String dotBundleName = baseName.replace("/", ".");
                try {
                    resourceBundle = ModuleSupport.getResourceBundle((String)dotBundleName, (Locale)locale, (ClassLoader)Thread.currentThread().getContextClassLoader());
                }
                catch (MissingResourceException ex) {
                    continue;
                }
            }
            somethingFound = true;
            this.prepareBundle(baseName, resourceBundle, locale);
        }
        if (!somethingFound && (clazz = this.findClassByName.apply(baseName)) != null && ResourceBundle.class.isAssignableFrom(clazz)) {
            this.trace("Found non-compliant class-based bundle " + clazz);
            somethingFound = true;
            this.support.prepareNonCompliant(clazz);
        }
        if (!somethingFound) {
            String errorMessage = "The bundle named: " + baseName + ", has not been found. If the bundle is part of a module, verify the bundle name is a fully qualified class name. Otherwise verify the bundle path is accessible in the classpath.";
            this.trace(errorMessage);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void prepareBundle(ResourceBundle bundle, Locale locale) {
        this.prepareBundle(bundle.getBaseBundleName(), bundle, locale);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private void prepareBundle(String bundleName, ResourceBundle bundle, Locale locale) {
        this.trace("Adding bundle " + bundleName);
        ResourceBundle cur = bundle;
        while (cur != null) {
            this.support.prepareBundle(bundleName, cur, cur.getLocale());
            cur = LocalizationFeature.getParent(cur);
        }
        this.support.prepareBundle(bundleName, bundle, locale);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static ResourceBundle getParent(ResourceBundle bundle) {
        try {
            return (ResourceBundle)PARENT_FIELD.get(bundle);
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected void trace(String msg) {
        if (this.trace) {
            System.out.println(msg);
        }
    }

    public static final class CharsetNodePlugin
    implements NodePlugin {
        public boolean handleInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
            if ((method.getName().equals("initc2b") || method.getName().equals("initb2c")) && b.getMetaAccess().lookupJavaType(Charset.class).isAssignableFrom(method.getDeclaringClass())) {
                ResolvedJavaType charsetType = method.getDeclaringClass();
                ResolvedJavaField initializedField = CharsetNodePlugin.findStaticField(charsetType, method.getName().substring(4, 7) + "Initialized");
                if (!b.getConstantReflection().readFieldValue(initializedField, null).asBoolean()) {
                    String charsetName = charsetType.getUnqualifiedName();
                    try {
                        Charset charset = Charset.forName(charsetName);
                        LocalizationFeature.addCharset(charset);
                    }
                    catch (UnsupportedCharsetException e) {
                        throw VMError.shouldNotReachHere("Could not find non-initialized charset " + charsetType.getSourceFileName(), e);
                    }
                }
                return true;
            }
            return false;
        }

        private static ResolvedJavaField findStaticField(ResolvedJavaType declaringClass, String name) {
            for (ResolvedJavaField field : declaringClass.getStaticFields()) {
                if (!field.getName().equals(name)) continue;
                return field;
            }
            throw VMError.shouldNotReachHere();
        }
    }

    public static class Options {
        @Option(help={"Comma separated list of bundles to be included into the image."}, type=OptionType.User)
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> IncludeResourceBundles = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        @Option(help={"Make all hosted charsets available at run time"})
        public static final HostedOptionKey<Boolean> AddAllCharsets = new HostedOptionKey<Boolean>(false);
        @Option(help={"Default locale of the image, by the default it is the same as the default locale of the image builder."}, type=OptionType.User)
        public static final HostedOptionKey<String> DefaultLocale = new HostedOptionKey<String>(Locale.getDefault().toLanguageTag());
        @Option(help={"Comma separated list of locales to be included into the image. The default locale is included in the list automatically if not present."}, type=OptionType.User)
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> IncludeLocales = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        @Option(help={"Make all hosted locales available at run time."}, type=OptionType.User)
        public static final HostedOptionKey<Boolean> IncludeAllLocales = new HostedOptionKey<Boolean>(false);
        @Option(help={"Optimize the resource bundle lookup using a simple map."}, type=OptionType.User)
        public static final HostedOptionKey<Boolean> LocalizationOptimizedMode = new HostedOptionKey<Boolean>(true);
        @Option(help={"Store the resource bundle content more efficiently in the fallback mode."}, type=OptionType.User)
        public static final HostedOptionKey<Boolean> LocalizationSubstituteLoadLookup = new HostedOptionKey<Boolean>(true);
        @Option(help={"Regular expressions matching which bundles should be compressed."}, type=OptionType.User)
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> LocalizationCompressBundles = new HostedOptionKey<LocatableMultiOptionValue.Strings>(new LocatableMultiOptionValue.Strings());
        @Option(help={"Compress the bundles in parallel."}, type=OptionType.Expert)
        public static final HostedOptionKey<Boolean> LocalizationCompressInParallel = new HostedOptionKey<Boolean>(true);
        @Option(help={"When enabled, localization feature details are printed."}, type=OptionType.Debug)
        public static final HostedOptionKey<Boolean> TraceLocalizationFeature = new HostedOptionKey<Boolean>(false);
    }
}

